/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;

abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E> {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();

    public BaseMpscLinkedAtomicArrayQueue(int n2) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n2, 2, "initialCapacity");
        int n3 = Pow2.roundToPowerOfTwo(n2);
        long l2 = n3 - 1 << 1;
        this.producerBuffer = atomicReferenceArray = AtomicQueueUtil.allocateRefArray(n3 + 1);
        this.producerMask = l2;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l2;
        this.soProducerLimit(l2);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public boolean isEmpty() {
        return (this.lvConsumerIndex() - this.lvProducerIndex()) / 2L == 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e2) {
        AtomicReferenceArray atomicReferenceArray;
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            if (l4 <= l3) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, atomicReferenceArray, l3, e2, null);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l3, l3 + 2L)) break;
        }
        int n3 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n3, e2);
        return true;
    }

    @Override
    public E poll() {
        long l2;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        int n2 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        if (e2 == null) {
            long l4 = this.lvProducerIndex();
            if ((l3 - l4) / 2L == 0L) {
                return null;
            }
            while ((e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2)) == null) {
            }
        }
        if (e2 == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.nextBuffer(atomicReferenceArray, l2);
            return this.newBufferPoll(atomicReferenceArray2, l3);
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l3 + 2L);
        return e2;
    }

    @Override
    public E peek() {
        long l2;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        int n2 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        if (e2 == null) {
            long l4 = this.lvProducerIndex();
            if ((l3 - l4) / 2L == 0L) {
                return null;
            }
            while ((e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2)) == null) {
            }
        }
        if (e2 == JUMP) {
            return this.newBufferPeek(this.nextBuffer(atomicReferenceArray, l2), l3);
        }
        return e2;
    }

    private int offerSlowPath(long l2, long l3, long l4) {
        long l5;
        long l6 = this.lvConsumerIndex();
        if (l6 + (l5 = this.getCurrentBufferCapacity(l2)) > l3) {
            if (!this.casProducerLimit(l4, l6 + l5)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l3, l6) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l3, l3 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> nextBuffer(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        AtomicReferenceArray atomicReferenceArray2;
        int n2 = BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(l2);
        this.consumerBuffer = atomicReferenceArray2 = (AtomicReferenceArray)AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        this.consumerMask = AtomicQueueUtil.length(atomicReferenceArray2) - 2 << 1;
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n2, BUFFER_CONSUMED);
        return atomicReferenceArray2;
    }

    private static int nextArrayOffset(long l2) {
        return AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n2 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, this.consumerMask);
        E e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        if (e2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    private E newBufferPeek(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n2 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, this.consumerMask);
        E e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        if (null == e2) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e2;
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        long l2;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        int n2 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        if (e2 == null) {
            return null;
        }
        if (e2 == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.nextBuffer(atomicReferenceArray, l2);
            return this.newBufferPoll(atomicReferenceArray2, l3);
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l3 + 2L);
        return e2;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2) {
        return MessagePassingQueueUtil.drain(this, consumer, n2);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    private void resize(long l2, AtomicReferenceArray<E> atomicReferenceArray, long l3, E e2, MessagePassingQueue.Supplier<E> supplier) {
        AtomicReferenceArray atomicReferenceArray2;
        assert (e2 != null && supplier == null || e2 == null || supplier != null);
        int n2 = this.getNextBufferSize(atomicReferenceArray);
        try {
            atomicReferenceArray2 = AtomicQueueUtil.allocateRefArray(n2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            assert (this.lvProducerIndex() == l3 + 1L);
            this.soProducerIndex(l3);
            throw outOfMemoryError;
        }
        this.producerBuffer = atomicReferenceArray2;
        int n3 = n2 - 2 << 1;
        this.producerMask = n3;
        int n4 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        int n5 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3, n3);
        AtomicQueueUtil.soRefElement(atomicReferenceArray2, n5, e2 == null ? supplier.get() : e2);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(l2), atomicReferenceArray2);
        long l4 = this.lvConsumerIndex();
        long l5 = this.availableInQueue(l3, l4);
        RangeUtil.checkPositive(l5, "availableInQueue");
        this.soProducerLimit(l3 + Math.min((long)n3, l5));
        this.soProducerIndex(l3 + 2L);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n4, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private long nextIndex;
        private E nextElement;
        private AtomicReferenceArray<E> currentBuffer;
        private int mask;

        WeakIterator(AtomicReferenceArray<E> atomicReferenceArray, long l2, long l3) {
            this.pIndex = l3 >> 1;
            this.nextIndex = l2 >> 1;
            this.setBuffer(atomicReferenceArray);
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e2 = this.nextElement;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e2;
        }

        private void setBuffer(AtomicReferenceArray<E> atomicReferenceArray) {
            this.currentBuffer = atomicReferenceArray;
            this.mask = AtomicQueueUtil.length(atomicReferenceArray) - 2;
        }

        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                long l2;
                ++this.nextIndex;
                E e2 = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcCircularRefElementOffset(l2, this.mask));
                if (e2 == null) continue;
                if (e2 != JUMP) {
                    return e2;
                }
                int n2 = this.mask + 1;
                E e3 = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcRefElementOffset(n2));
                if (e3 == BUFFER_CONSUMED || e3 == null) {
                    return null;
                }
                this.setBuffer((AtomicReferenceArray)e3);
                e2 = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcCircularRefElementOffset(l2, this.mask));
                if (e2 == null) continue;
                return e2;
            }
            return null;
        }
    }
}

