/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.Cleaner;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent0;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;

final class CleanerJava25
implements Cleaner {
    private static final InternalLogger logger;
    private static final MethodHandle INVOKE_ALLOCATOR;

    CleanerJava25() {
    }

    static boolean isSupported() {
        return INVOKE_ALLOCATOR != null;
    }

    @Override
    public CleanableDirectBuffer allocate(int n2) {
        try {
            return INVOKE_ALLOCATOR.invokeExact(n2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unexpected allocation exception", throwable);
        }
    }

    @Override
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Cannot clean arbitrary ByteBuffer instances");
    }

    static {
        Throwable throwable;
        boolean bl2;
        Object object;
        if (System.getProperty("org.graalvm.nativeimage.imagecode") != null) {
            object = System.getProperty("java.specification.version");
            try {
                bl2 = Integer.parseInt((String)object) >= 25;
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
            }
            logger = null;
        } else {
            bl2 = PlatformDependent0.javaVersion() >= 25;
            logger = InternalLoggerFactory.getInstance(CleanerJava25.class);
        }
        if (bl2) {
            try {
                Class<?> clazz = Class.forName("java.lang.foreign.Arena");
                Class<?> clazz2 = Class.forName("java.lang.foreign.MemorySegment");
                Class<CleanableDirectBufferImpl> clazz3 = CleanableDirectBufferImpl.class;
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle methodHandle = lookup.findStatic(clazz, "ofShared", MethodType.methodType(clazz));
                MethodHandle methodHandle2 = lookup.findVirtual(clazz, "allocate", MethodType.methodType(clazz2, Long.TYPE));
                MethodHandle methodHandle3 = lookup.findVirtual(clazz2, "asByteBuffer", MethodType.methodType(ByteBuffer.class));
                MethodHandle methodHandle4 = lookup.findVirtual(clazz2, "address", MethodType.methodType(Long.TYPE));
                MethodHandle methodHandle5 = lookup.findConstructor(clazz3, MethodType.methodType(Void.TYPE, AutoCloseable.class, ByteBuffer.class, Long.TYPE));
                MethodHandle methodHandle6 = MethodHandles.explicitCastArguments(methodHandle2, MethodType.methodType(clazz2, clazz, Integer.TYPE));
                MethodHandle methodHandle7 = MethodHandles.explicitCastArguments(MethodHandles.filterArguments(methodHandle5, 1, methodHandle3, methodHandle4), MethodType.methodType(clazz3, clazz, clazz2, clazz2));
                MethodHandle methodHandle8 = MethodHandles.permuteArguments(methodHandle7, MethodType.methodType(clazz3, clazz, clazz2, clazz2), 0, 1, 1);
                MethodHandle methodHandle9 = MethodHandles.insertArguments(methodHandle8, 2, new Object[]{null});
                MethodHandle methodHandle10 = MethodHandles.collectArguments(methodHandle9, 1, methodHandle6);
                MethodHandle methodHandle11 = MethodHandles.permuteArguments(methodHandle10, MethodType.methodType(clazz3, clazz, clazz, Integer.TYPE), 0, 0, 2);
                MethodHandle methodHandle12 = MethodHandles.insertArguments(methodHandle11, 1, new Object[]{null});
                object = MethodHandles.foldArguments(methodHandle12, methodHandle);
                throwable = null;
            }
            catch (Throwable throwable2) {
                object = null;
                throwable = throwable2;
            }
        } else {
            object = null;
            throwable = new UnsupportedOperationException("java.lang.foreign.MemorySegment unavailable");
        }
        if (logger != null) {
            if (throwable == null) {
                logger.debug("java.nio.ByteBuffer.cleaner(): available");
            } else {
                logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
            }
        }
        INVOKE_ALLOCATOR = object;
    }

    private static final class CleanableDirectBufferImpl
    implements CleanableDirectBuffer {
        private final AutoCloseable closeable;
        private final ByteBuffer buffer;
        private final long memoryAddress;

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void clean() {
            try {
                this.closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unexpected close exception", exception);
            }
        }

        @Override
        public boolean hasMemoryAddress() {
            return true;
        }

        @Override
        public long memoryAddress() {
            return this.memoryAddress;
        }
    }
}

