/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelId;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelMetadata;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelOutboundInvoker;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.EventLoop;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.util.AttributeMap;
import java.net.SocketAddress;

public interface Channel
extends ChannelOutboundInvoker,
AttributeMap,
Comparable<Channel> {
    public ChannelId id();

    public EventLoop eventLoop();

    public ChannelConfig config();

    public boolean isOpen();

    public boolean isRegistered();

    public boolean isActive();

    public ChannelMetadata metadata();

    public SocketAddress remoteAddress();

    public ChannelFuture closeFuture();

    default public boolean isWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe().outboundBuffer();
        return channelOutboundBuffer != null && channelOutboundBuffer.isWritable();
    }

    public Unsafe unsafe();

    public ChannelPipeline pipeline();

    default public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    default public Channel read() {
        this.pipeline().read();
        return this;
    }

    @Override
    default public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline().writeAndFlush(object);
    }

    @Override
    default public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.pipeline().writeAndFlush(object, channelPromise);
    }

    @Override
    default public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline().write(object, channelPromise);
    }

    @Override
    default public ChannelFuture write(Object object) {
        return this.pipeline().write(object);
    }

    @Override
    default public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline().deregister(channelPromise);
    }

    @Override
    default public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline().close(channelPromise);
    }

    @Override
    default public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline().disconnect(channelPromise);
    }

    @Override
    default public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    default public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, channelPromise);
    }

    @Override
    default public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().bind(socketAddress, channelPromise);
    }

    @Override
    default public ChannelFuture close() {
        return this.pipeline().close();
    }

    @Override
    default public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    @Override
    default public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline().newFailedFuture(throwable);
    }

    @Override
    default public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    public static interface Unsafe {
        public RecvByteBufAllocator.Handle recvBufAllocHandle();

        public SocketAddress localAddress();

        public SocketAddress remoteAddress();

        public void register(EventLoop var1, ChannelPromise var2);

        public void bind(SocketAddress var1, ChannelPromise var2);

        public void connect(SocketAddress var1, SocketAddress var2, ChannelPromise var3);

        public void disconnect(ChannelPromise var1);

        public void close(ChannelPromise var1);

        public void closeForcibly();

        public void deregister(ChannelPromise var1);

        public void beginRead();

        public void write(Object var1, ChannelPromise var2);

        public void flush();

        public ChannelOutboundBuffer outboundBuffer();
    }
}

