/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;
    private final int startIndex;
    private DataOutputStream utf8out;
    private boolean closed;
    private final boolean releaseOnClose;

    public ByteBufOutputStream(ByteBuf byteBuf) {
        this(byteBuf, false);
    }

    public ByteBufOutputStream(ByteBuf byteBuf, boolean bl2) {
        this.releaseOnClose = bl2;
        this.buffer = ObjectUtil.checkNotNull(byteBuf, "buffer");
        this.startIndex = byteBuf.writerIndex();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.buffer.writeBytes(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.buffer.writeBytes(byArray);
    }

    @Override
    public void write(int n2) throws IOException {
        this.buffer.writeByte(n2);
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this.buffer.writeBoolean(bl2);
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.buffer.writeByte(n2);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n2 = string.length();
        this.buffer.ensureWritable(n2);
        int n3 = this.buffer.writerIndex();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.setByte(n3 + i2, (byte)string.charAt(i2));
        }
        this.buffer.writerIndex(n3 + n2);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.buffer.writeChar(n2);
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.writeChar(string.charAt(i2));
        }
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.buffer.writeDouble(d2);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.buffer.writeFloat(f2);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.buffer.writeInt(n2);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.buffer.writeLong(l2);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.buffer.writeShort((short)n2);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        DataOutputStream dataOutputStream = this.utf8out;
        if (dataOutputStream == null) {
            if (this.closed) {
                throw new IOException("The stream is closed");
            }
            this.utf8out = dataOutputStream = new DataOutputStream(this);
        }
        dataOutputStream.writeUTF(string);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            super.close();
        }
        finally {
            if (this.utf8out != null) {
                this.utf8out.close();
            }
            if (this.releaseOnClose) {
                this.buffer.release();
            }
        }
    }
}

