/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.util;

import com.gradle.scan.plugin.internal.dep.oshi.util.GlobalConfig;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class Memoizer {
    private static final Supplier<Long> DEFAULT_EXPIRATION_NANOS = Memoizer.memoize(Memoizer::queryExpirationConfig, TimeUnit.MINUTES.toNanos(1L));

    private static long queryExpirationConfig() {
        return TimeUnit.MILLISECONDS.toNanos(GlobalConfig.get("com.gradle.scan.plugin.internal.dep.oshi.util.memoizer.expiration", 300));
    }

    public static long installedAppsExpiration() {
        return TimeUnit.MINUTES.toNanos(1L);
    }

    public static long defaultExpiration() {
        return DEFAULT_EXPIRATION_NANOS.get();
    }

    public static <T> Supplier<T> memoize(final Supplier<T> supplier, final long l2) {
        return new Supplier<T>(){
            private final Supplier<T> delegate;
            private volatile T value;
            private volatile long expirationNanos;
            {
                this.delegate = supplier;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                long l22 = this.expirationNanos;
                long l3 = System.nanoTime();
                if (l22 == 0L || l2 >= 0L && l3 - l22 >= 0L) {
                    1 var5_3 = this;
                    synchronized (var5_3) {
                        if (l22 == this.expirationNanos) {
                            Object t2 = this.delegate.get();
                            this.value = t2;
                            l22 = l3 + l2;
                            this.expirationNanos = l22 == 0L ? 1L : l22;
                            return t2;
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        return Memoizer.memoize(supplier, -1L);
    }
}

