/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.entity;

import com.gradle.scan.plugin.internal.dep.org.apache.http.Header;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpEntity;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.BasicHeader;

public abstract class AbstractHttpEntity
implements HttpEntity {
    protected Header contentType;
    protected Header contentEncoding;
    protected boolean chunked;

    protected AbstractHttpEntity() {
    }

    @Override
    public Header getContentType() {
        return this.contentType;
    }

    @Override
    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    public void setContentType(Header header) {
        this.contentType = header;
    }

    public void setContentType(String string) {
        BasicHeader basicHeader = null;
        if (string != null) {
            basicHeader = new BasicHeader("Content-Type", string);
        }
        this.setContentType(basicHeader);
    }

    public void setContentEncoding(Header header) {
        this.contentEncoding = header;
    }

    public void setContentEncoding(String string) {
        BasicHeader basicHeader = null;
        if (string != null) {
            basicHeader = new BasicHeader("Content-Encoding", string);
        }
        this.setContentEncoding(basicHeader);
    }

    public void setChunked(boolean bl2) {
        this.chunked = bl2;
    }

    public String toString() {
        long l2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.contentType != null) {
            stringBuilder.append("Content-Type: ");
            stringBuilder.append(this.contentType.getValue());
            stringBuilder.append(',');
        }
        if (this.contentEncoding != null) {
            stringBuilder.append("Content-Encoding: ");
            stringBuilder.append(this.contentEncoding.getValue());
            stringBuilder.append(',');
        }
        if ((l2 = this.getContentLength()) >= 0L) {
            stringBuilder.append("Content-Length: ");
            stringBuilder.append(l2);
            stringBuilder.append(',');
        }
        stringBuilder.append("Chunked: ");
        stringBuilder.append(this.chunked);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

