/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslEngineMap;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslInternalSession;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionId;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLSession;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLSessionCache;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetectorFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.cert.X509Certificate;

class OpenSslSessionCache
implements SSLSessionCache {
    private static final OpenSslInternalSession[] EMPTY_SESSIONS = new OpenSslInternalSession[0];
    private static final int DEFAULT_CACHE_SIZE;
    private final OpenSslEngineMap engineMap;
    private final Map<OpenSslSessionId, NativeSslSession> sessions = new LinkedHashMap<OpenSslSessionId, NativeSslSession>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<OpenSslSessionId, NativeSslSession> entry) {
            int n2 = OpenSslSessionCache.this.maximumCacheSize.get();
            if (n2 >= 0 && this.size() > n2) {
                OpenSslSessionCache.this.removeSessionWithId(entry.getKey());
            }
            return false;
        }
    };
    private final AtomicInteger maximumCacheSize = new AtomicInteger(DEFAULT_CACHE_SIZE);
    private final AtomicInteger sessionTimeout = new AtomicInteger(300);

    OpenSslSessionCache(OpenSslEngineMap openSslEngineMap) {
        this.engineMap = openSslEngineMap;
    }

    final void setSessionTimeout(int n2) {
        int n3 = this.sessionTimeout.getAndSet(n2);
        if (n3 > n2) {
            this.clear();
        }
    }

    final int getSessionTimeout() {
        return this.sessionTimeout.get();
    }

    protected void sessionRemoved(NativeSslSession nativeSslSession) {
    }

    final void setSessionCacheSize(int n2) {
        long l2 = this.maximumCacheSize.getAndSet(n2);
        if (l2 > (long)n2 || n2 == 0) {
            this.clear();
        }
    }

    final int getSessionCacheSize() {
        return this.maximumCacheSize.get();
    }

    boolean setSession(long l2, OpenSslInternalSession openSslInternalSession, String string, int n2) {
        return false;
    }

    final synchronized void removeSessionWithId(OpenSslSessionId openSslSessionId) {
        NativeSslSession nativeSslSession = this.sessions.remove(openSslSessionId);
        if (nativeSslSession != null) {
            this.notifyRemovalAndFree(nativeSslSession);
        }
    }

    final synchronized boolean containsSessionWithId(OpenSslSessionId openSslSessionId) {
        return this.sessions.containsKey(openSslSessionId);
    }

    private void notifyRemovalAndFree(NativeSslSession nativeSslSession) {
        this.sessionRemoved(nativeSslSession);
        nativeSslSession.free();
    }

    final synchronized OpenSslInternalSession getSession(OpenSslSessionId openSslSessionId) {
        NativeSslSession nativeSslSession = this.sessions.get(openSslSessionId);
        if (nativeSslSession != null && !nativeSslSession.isValid()) {
            this.removeSessionWithId(nativeSslSession.sessionId());
            return null;
        }
        return nativeSslSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<OpenSslSessionId> getIds() {
        OpenSslInternalSession[] openSslInternalSessionArray;
        Object object = this;
        synchronized (object) {
            openSslInternalSessionArray = this.sessions.values().toArray(EMPTY_SESSIONS);
        }
        object = new ArrayList(openSslInternalSessionArray.length);
        for (OpenSslInternalSession openSslInternalSession : openSslInternalSessionArray) {
            if (!openSslInternalSession.isValid()) continue;
            object.add(openSslInternalSession.sessionId());
        }
        return object;
    }

    synchronized void clear() {
        Iterator<Map.Entry<OpenSslSessionId, NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            NativeSslSession nativeSslSession = iterator.next().getValue();
            iterator.remove();
            this.notifyRemovalAndFree(nativeSslSession);
        }
    }

    static {
        int n2 = SystemPropertyUtil.getInt("javax.net.ssl.sessionCacheSize", 20480);
        DEFAULT_CACHE_SIZE = n2 >= 0 ? n2 : 20480;
    }

    static final class NativeSslSession
    implements OpenSslInternalSession {
        static final ResourceLeakDetector<NativeSslSession> LEAK_DETECTOR = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(NativeSslSession.class);
        private final ResourceLeakTracker<NativeSslSession> leakTracker;
        final Map<String, Object> keyValueStorage;
        private final long session;
        private final String peerHost;
        private final int peerPort;
        private final OpenSslSessionId id;
        private final long timeout;
        private final long creationTime;
        private volatile long lastAccessedTime;
        private volatile boolean valid;
        private boolean freed;

        @Override
        public void prepareHandshake() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSessionDetails(long l2, long l3, OpenSslSessionId openSslSessionId, Map<String, Object> map) {
            throw new UnsupportedOperationException();
        }

        boolean shouldBeSingleUse() {
            assert (!this.freed);
            return SSLSession.shouldBeSingleUse((long)this.session);
        }

        long session() {
            assert (!this.freed);
            return this.session;
        }

        synchronized void free() {
            this.close();
            SSLSession.free((long)this.session);
        }

        void close() {
            assert (!this.freed);
            this.freed = true;
            this.invalidate();
            if (this.leakTracker != null) {
                this.leakTracker.close(this);
            }
        }

        @Override
        public OpenSslSessionId sessionId() {
            return this.id;
        }

        boolean isValid(long l2) {
            return this.creationTime + this.timeout >= l2 && this.valid;
        }

        @Override
        public void setLocalCertificate(Certificate[] certificateArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OpenSslSessionContext getSessionContext() {
            return null;
        }

        @Override
        public void tryExpandApplicationBufferSize(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handshakeFinished(byte[] byArray, String string, String string2, byte[] byArray2, byte[][] byArray3, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getId() {
            return this.id.cloneBytes();
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        public void setLastAccessedTime(long l2) {
            this.lastAccessedTime = l2;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        @Override
        public void invalidate() {
            this.valid = false;
        }

        @Override
        public boolean isValid() {
            return this.isValid(System.currentTimeMillis());
        }

        @Override
        public void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(String string) {
            return null;
        }

        @Override
        public void removeValue(String string) {
        }

        @Override
        public String[] getValueNames() {
            return EmptyArrays.EMPTY_STRINGS;
        }

        @Override
        public Certificate[] getPeerCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Certificate[] getLocalCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getPeerPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getLocalPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCipherSuite() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public String getPeerHost() {
            return this.peerHost;
        }

        @Override
        public int getPeerPort() {
            return this.peerPort;
        }

        @Override
        public int getPacketBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_RECORD_SIZE;
        }

        @Override
        public int getApplicationBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof OpenSslInternalSession)) {
                return false;
            }
            OpenSslInternalSession openSslInternalSession = (OpenSslInternalSession)object;
            return this.id.equals(openSslInternalSession.sessionId());
        }
    }
}

