/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;

final class Java8SslUtils {
    static List<String> getSniHostNames(SSLParameters sSLParameters) {
        List<SNIServerName> list = sSLParameters.getServerNames();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (SNIServerName sNIServerName : list) {
            if (sNIServerName instanceof SNIHostName) {
                arrayList.add(((SNIHostName)sNIServerName).getAsciiName());
                continue;
            }
            throw new IllegalArgumentException("Only " + SNIHostName.class.getName() + " instances are supported, but found: " + sNIServerName);
        }
        return arrayList;
    }

    static void setSniHostNames(SSLParameters sSLParameters, List<String> list) {
        sSLParameters.setServerNames(Java8SslUtils.getSniHostNames(list));
    }

    static boolean isValidHostNameForSNI(String string) {
        try {
            new SNIHostName(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    static List getSniHostNames(List<String> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIHostName> arrayList = new ArrayList<SNIHostName>(list.size());
        for (String string : list) {
            arrayList.add(new SNIHostName(string.getBytes(CharsetUtil.UTF_8)));
        }
        return arrayList;
    }

    static List getSniHostName(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SNIHostName(byArray));
    }

    static boolean getUseCipherSuitesOrder(SSLParameters sSLParameters) {
        return sSLParameters.getUseCipherSuitesOrder();
    }

    static void setUseCipherSuitesOrder(SSLParameters sSLParameters, boolean bl2) {
        sSLParameters.setUseCipherSuitesOrder(bl2);
    }

    static void setSNIMatchers(SSLParameters sSLParameters, Collection<?> collection) {
        sSLParameters.setSNIMatchers(collection);
    }
}

