/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.EmptyHttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.net.URI;

public final class WebSocketClientProtocolConfig {
    private final URI webSocketUri;
    private final String subprotocol;
    private final WebSocketVersion version;
    private final boolean allowExtensions;
    private final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;
    private final boolean handleCloseFrames;
    private final WebSocketCloseStatus sendCloseFrame;
    private final boolean dropPongFrames;
    private final long handshakeTimeoutMillis;
    private final long forceCloseTimeoutMillis;
    private final boolean absoluteUpgradeUrl;
    private final boolean generateOriginHeader;
    private final boolean withUTF8Validator;

    private WebSocketClientProtocolConfig(URI uRI, String string, WebSocketVersion webSocketVersion, boolean bl2, HttpHeaders httpHeaders, int n2, boolean bl3, boolean bl4, boolean bl5, WebSocketCloseStatus webSocketCloseStatus, boolean bl6, long l2, long l3, boolean bl7, boolean bl8, boolean bl9) {
        this.webSocketUri = uRI;
        this.subprotocol = string;
        this.version = webSocketVersion;
        this.allowExtensions = bl2;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n2;
        this.performMasking = bl3;
        this.allowMaskMismatch = bl4;
        this.forceCloseTimeoutMillis = l3;
        this.handleCloseFrames = bl5;
        this.sendCloseFrame = webSocketCloseStatus;
        this.dropPongFrames = bl6;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive(l2, "handshakeTimeoutMillis");
        this.absoluteUpgradeUrl = bl7;
        this.generateOriginHeader = bl8;
        this.withUTF8Validator = bl9;
    }

    public URI webSocketUri() {
        return this.webSocketUri;
    }

    public String subprotocol() {
        return this.subprotocol;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public boolean allowExtensions() {
        return this.allowExtensions;
    }

    public HttpHeaders customHeaders() {
        return this.customHeaders;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean performMasking() {
        return this.performMasking;
    }

    public boolean allowMaskMismatch() {
        return this.allowMaskMismatch;
    }

    public boolean handleCloseFrames() {
        return this.handleCloseFrames;
    }

    public WebSocketCloseStatus sendCloseFrame() {
        return this.sendCloseFrame;
    }

    public boolean dropPongFrames() {
        return this.dropPongFrames;
    }

    public long handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    public boolean absoluteUpgradeUrl() {
        return this.absoluteUpgradeUrl;
    }

    public boolean generateOriginHeader() {
        return this.generateOriginHeader;
    }

    public boolean withUTF8Validator() {
        return this.withUTF8Validator;
    }

    public String toString() {
        return "WebSocketClientProtocolConfig {webSocketUri=" + this.webSocketUri + ", subprotocol=" + this.subprotocol + ", version=" + (Object)((Object)this.version) + ", allowExtensions=" + this.allowExtensions + ", customHeaders=" + this.customHeaders + ", maxFramePayloadLength=" + this.maxFramePayloadLength + ", performMasking=" + this.performMasking + ", allowMaskMismatch=" + this.allowMaskMismatch + ", handleCloseFrames=" + this.handleCloseFrames + ", sendCloseFrame=" + this.sendCloseFrame + ", dropPongFrames=" + this.dropPongFrames + ", handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", forceCloseTimeoutMillis=" + this.forceCloseTimeoutMillis + ", absoluteUpgradeUrl=" + this.absoluteUpgradeUrl + ", generateOriginHeader=" + this.generateOriginHeader + "}";
    }

    public static Builder newBuilder() {
        return new Builder(URI.create("https://localhost/"), null, WebSocketVersion.V13, false, EmptyHttpHeaders.INSTANCE, 65536, true, false, true, WebSocketCloseStatus.NORMAL_CLOSURE, true, 10000L, -1L, false, true, true);
    }

    public static final class Builder {
        private URI webSocketUri;
        private String subprotocol;
        private WebSocketVersion version;
        private boolean allowExtensions;
        private HttpHeaders customHeaders;
        private int maxFramePayloadLength;
        private boolean performMasking;
        private boolean allowMaskMismatch;
        private boolean handleCloseFrames;
        private WebSocketCloseStatus sendCloseFrame;
        private boolean dropPongFrames;
        private long handshakeTimeoutMillis;
        private long forceCloseTimeoutMillis;
        private boolean absoluteUpgradeUrl;
        private boolean generateOriginHeader;
        private boolean withUTF8Validator;

        private Builder(URI uRI, String string, WebSocketVersion webSocketVersion, boolean bl2, HttpHeaders httpHeaders, int n2, boolean bl3, boolean bl4, boolean bl5, WebSocketCloseStatus webSocketCloseStatus, boolean bl6, long l2, long l3, boolean bl7, boolean bl8, boolean bl9) {
            this.webSocketUri = uRI;
            this.subprotocol = string;
            this.version = webSocketVersion;
            this.allowExtensions = bl2;
            this.customHeaders = httpHeaders;
            this.maxFramePayloadLength = n2;
            this.performMasking = bl3;
            this.allowMaskMismatch = bl4;
            this.handleCloseFrames = bl5;
            this.sendCloseFrame = webSocketCloseStatus;
            this.dropPongFrames = bl6;
            this.handshakeTimeoutMillis = l2;
            this.forceCloseTimeoutMillis = l3;
            this.absoluteUpgradeUrl = bl7;
            this.generateOriginHeader = bl8;
            this.withUTF8Validator = bl9;
        }

        public Builder webSocketUri(URI uRI) {
            this.webSocketUri = uRI;
            return this;
        }

        public Builder customHeaders(HttpHeaders httpHeaders) {
            this.customHeaders = httpHeaders;
            return this;
        }

        public Builder maxFramePayloadLength(int n2) {
            this.maxFramePayloadLength = n2;
            return this;
        }

        public Builder handleCloseFrames(boolean bl2) {
            this.handleCloseFrames = bl2;
            return this;
        }

        public Builder handshakeTimeoutMillis(long l2) {
            this.handshakeTimeoutMillis = l2;
            return this;
        }

        public Builder forceCloseTimeoutMillis(long l2) {
            this.forceCloseTimeoutMillis = l2;
            return this;
        }

        public Builder withUTF8Validator(boolean bl2) {
            this.withUTF8Validator = bl2;
            return this;
        }

        public WebSocketClientProtocolConfig build() {
            return new WebSocketClientProtocolConfig(this.webSocketUri, this.subprotocol, this.version, this.allowExtensions, this.customHeaders, this.maxFramePayloadLength, this.performMasking, this.allowMaskMismatch, this.handleCloseFrames, this.sendCloseFrame, this.dropPongFrames, this.handshakeTimeoutMillis, this.forceCloseTimeoutMillis, this.absoluteUpgradeUrl, this.generateOriginHeader, this.withUTF8Validator);
        }
    }
}

