/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.FullHttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.FullHttpResponse;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponseStatus;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.net.URI;
import java.nio.ByteBuffer;

public class WebSocketClientHandshaker00
extends WebSocketClientHandshaker {
    private ByteBuf expectedChallengeResponseBytes;

    WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n2, long l2, boolean bl2, boolean bl3) {
        super(uRI, webSocketVersion, string, httpHeaders, n2, l2, bl2, bl3);
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        String string;
        int n2 = WebSocketUtil.randomNumber(1, 12);
        int n3 = WebSocketUtil.randomNumber(1, 12);
        int n4 = Integer.MAX_VALUE / n2;
        int n5 = Integer.MAX_VALUE / n3;
        int n6 = WebSocketUtil.randomNumber(0, n4);
        int n7 = WebSocketUtil.randomNumber(0, n5);
        int n8 = n6 * n2;
        int n9 = n7 * n3;
        String string2 = Integer.toString(n8);
        String string3 = Integer.toString(n9);
        string2 = WebSocketClientHandshaker00.insertRandomCharacters(string2);
        string3 = WebSocketClientHandshaker00.insertRandomCharacters(string3);
        string2 = WebSocketClientHandshaker00.insertSpaces(string2, n2);
        string3 = WebSocketClientHandshaker00.insertSpaces(string3, n3);
        byte[] byArray = WebSocketUtil.randomBytes(8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n6);
        byte[] byArray2 = byteBuffer.array();
        byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n7);
        byte[] byArray3 = byteBuffer.array();
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray2, 0, byArray4, 0, 4);
        System.arraycopy(byArray3, 0, byArray4, 4, 4);
        System.arraycopy(byArray, 0, byArray4, 8, 8);
        this.expectedChallengeResponseBytes = Unpooled.wrappedBuffer(WebSocketUtil.md5(byArray4));
        URI uRI = this.uri();
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(uRI), Unpooled.wrappedBuffer(byArray));
        HttpHeaders httpHeaders = defaultFullHttpRequest.headers();
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
            if (!httpHeaders.contains(HttpHeaderNames.HOST)) {
                httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker00.websocketHostValue(uRI));
            }
        } else {
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker00.websocketHostValue(uRI));
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1, (Object)string2).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2, (Object)string3);
        if (this.generateOriginHeader && !httpHeaders.contains(HttpHeaderNames.ORIGIN)) {
            httpHeaders.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)WebSocketClientHandshaker00.websocketOriginValue(uRI));
        }
        if ((string = this.expectedSubprotocol()) != null && !string.isEmpty()) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byArray.length);
        return defaultFullHttpRequest;
    }

    @Override
    protected void verify(FullHttpResponse fullHttpResponse) {
        HttpResponseStatus httpResponseStatus = fullHttpResponse.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(httpResponseStatus)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response getStatus: " + httpResponseStatus, fullHttpResponse);
        }
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        String string = httpHeaders.get(HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(string)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + string, fullHttpResponse);
        }
        if (!httpHeaders.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + httpHeaders.get(HttpHeaderNames.CONNECTION), fullHttpResponse);
        }
        ByteBuf byteBuf = fullHttpResponse.content();
        if (!byteBuf.equals(this.expectedChallengeResponseBytes)) {
            throw new WebSocketClientHandshakeException("Invalid challenge", fullHttpResponse);
        }
    }

    private static String insertRandomCharacters(String string) {
        int n2;
        int n3 = WebSocketUtil.randomNumber(1, 12);
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            n2 = PlatformDependent.threadLocalRandom().nextInt(126) + 33;
            if ((33 >= n2 || n2 >= 47) && (58 >= n2 || n2 >= 126)) continue;
            cArray[n4] = (char)n2;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = WebSocketUtil.randomNumber(0, string.length());
            String string2 = string.substring(0, n5);
            String string3 = string.substring(n5);
            string = string2 + cArray[n2] + string3;
        }
        return string;
    }

    private static String insertSpaces(String string, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = WebSocketUtil.randomNumber(1, string.length() - 1);
            String string2 = string.substring(0, n3);
            String string3 = string.substring(n3);
            string = string2 + ' ' + string3;
        }
        return string;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }
}

