/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.CombinedChannelDuplexHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.PrematureChannelClosureException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpDecoderConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMessage;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpRequestEncoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponse;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponseDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponseStatus;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpStatusClass;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public final class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder> {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();
    private final boolean parseHttpAfterConnectRequest;
    private boolean done;
    private final AtomicLong requestResponseCounter = new AtomicLong();
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(new HttpDecoderConfig(), false, false);
    }

    public HttpClientCodec(HttpDecoderConfig httpDecoderConfig, boolean bl2, boolean bl3) {
        this.init(new Decoder(httpDecoderConfig), new Encoder());
        this.parseHttpAfterConnectRequest = bl2;
        this.failOnMissingResponse = bl3;
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(HttpDecoderConfig httpDecoderConfig) {
            super(httpDecoderConfig);
        }

        @Override
        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            if (HttpClientCodec.this.done) {
                int n2 = this.actualReadableBytes();
                if (n2 == 0) {
                    return;
                }
                list.add(byteBuf.readBytes(n2));
            } else {
                int n3 = list.size();
                super.decode(channelHandlerContext, byteBuf, list);
                if (HttpClientCodec.this.failOnMissingResponse) {
                    int n4 = list.size();
                    for (int i2 = n3; i2 < n4; ++i2) {
                        this.decrement(list.get(i2));
                    }
                }
            }
        }

        private void decrement(Object object) {
            if (object == null) {
                return;
            }
            if (object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            HttpMethod httpMethod = (HttpMethod)HttpClientCodec.this.queue.poll();
            HttpResponseStatus httpResponseStatus = ((HttpResponse)httpMessage).status();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            int n2 = httpResponseStatus.code();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL) {
                return super.isContentAlwaysEmpty(httpMessage);
            }
            if (httpMethod != null) {
                char c2 = httpMethod.name().charAt(0);
                switch (c2) {
                    case 'H': {
                        if (!HttpMethod.HEAD.equals(httpMethod)) break;
                        return true;
                    }
                    case 'C': {
                        if (n2 != 200 || !HttpMethod.CONNECT.equals(httpMethod)) break;
                        if (!HttpClientCodec.this.parseHttpAfterConnectRequest) {
                            HttpClientCodec.this.done = true;
                            HttpClientCodec.this.queue.clear();
                        }
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty(httpMessage);
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            long l2;
            super.channelInactive(channelHandlerContext);
            if (HttpClientCodec.this.failOnMissingResponse && (l2 = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                channelHandlerContext.fireExceptionCaught(new PrematureChannelClosureException("channel gone inactive with " + l2 + " missing response(s)"));
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        boolean upgraded;

        private Encoder() {
        }

        @Override
        protected void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
            if (this.upgraded) {
                list.add(object);
                return;
            }
            if (object instanceof HttpRequest) {
                HttpClientCodec.this.queue.offer(((HttpRequest)object).method());
            }
            super.encode(channelHandlerContext, object, list);
            if (HttpClientCodec.this.failOnMissingResponse && !HttpClientCodec.this.done && object instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

