/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializable;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Objects;

public class POJONode
extends ValueNode {
    protected final Object _value;

    public POJONode(Object object) {
        this._value = object;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.POJO;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() throws IOException {
        if (this._value instanceof byte[]) {
            return (byte[])this._value;
        }
        return super.binaryValue();
    }

    @Override
    public String asText() {
        return this._value == null ? "null" : this._value.toString();
    }

    @Override
    public long asLong(long l2) {
        if (this._value instanceof Number) {
            return ((Number)this._value).longValue();
        }
        return l2;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._value == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else if (this._value instanceof JsonSerializable) {
            ((JsonSerializable)this._value).serialize(jsonGenerator, serializerProvider);
        } else {
            serializerProvider.defaultSerializeValue(this._value, jsonGenerator);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof POJONode) {
            return this._pojoEquals((POJONode)object);
        }
        return false;
    }

    protected boolean _pojoEquals(POJONode pOJONode) {
        if (this._value == null) {
            return pOJONode._value == null;
        }
        return this._value.equals(pOJONode._value);
    }

    public int hashCode() {
        return Objects.hashCode(this._value);
    }
}

