/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonParserBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonReadFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;

public class ReaderBasedJsonParser
extends JsonParserBase {
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete;
    protected long _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer, char[] cArray, int n3, int n4, boolean bl2) {
        super(iOContext, n2, objectCodec);
        this._reader = reader;
        this._inputBuffer = cArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._currInputRowStart = n3;
        this._currInputProcessed = -n3;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = bl2;
    }

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n2, objectCodec);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = true;
    }

    protected char getNextChar(String string, JsonToken jsonToken) throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(string, jsonToken);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        char[] cArray;
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable && (cArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }

    protected void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected boolean _loadMore() throws IOException {
        if (this._reader != null) {
            int n2 = this._inputEnd;
            this._currInputProcessed += (long)n2;
            this._currInputRowStart -= n2;
            this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
            int n3 = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n3 > 0) {
                this._nameStartOffset -= (long)n2;
                this._inputPtr = 0;
                this._inputEnd = n3;
                return true;
            }
            this._inputEnd = 0;
            this._inputPtr = 0;
            this._closeInput();
            if (n3 == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    @Override
    public final String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public final String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public final String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        return super.getValueAsString(string);
    }

    protected final String _getText2(JsonToken jsonToken) throws IOException {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public final char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public final int getTextLength() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return this._parsingContext.getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public final int getTextOffset() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && this._binaryValue != null) {
            return this._binaryValue;
        }
        if (this._currToken != JsonToken.VALUE_STRING) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n5 = base64Variant.decodeBase64Char(c2);
            if (n5 < 0) {
                if (c2 == '\"') break;
                n5 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n5 < 0) continue;
            }
            if (n2 > n3) {
                n4 += n2;
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            int n6 = n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n5 = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n5 != -2) {
                    if (c2 == '\"') {
                        byArray[n2++] = (byte)(n6 >>= 4);
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n5 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(base64Variant, c2, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n2++] = (byte)(n6 >>= 4);
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n5 != -2) {
                    if (c2 == '\"') {
                        byArray[n2++] = (byte)((n6 >>= 2) >> 8);
                        byArray[n2++] = (byte)n6;
                        if (!base64Variant.requiresPaddingOnRead()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n5 == -2) {
                    byArray[n2++] = (byte)((n6 >>= 2) >> 8);
                    byArray[n2++] = (byte)n6;
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            byArray[n2++] = (byte)(n6 >> 16);
            byArray[n2++] = (byte)(n6 >> 8);
            byArray[n2++] = (byte)n6;
        }
        this._tokenIncomplete = false;
        if (n2 > 0) {
            n4 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n4;
    }

    @Override
    public final JsonToken nextToken() throws IOException {
        Object object;
        boolean bl2;
        int n2;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if ((n2 | 0x20) == 125) {
            this._closeScope(n2);
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            n2 = this._skipComma(n2);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 | 0x20) == 125) {
                this._closeScope(n2);
                return this._currToken;
            }
        }
        if (bl2 = this._parsingContext.inObject()) {
            this._updateNameLocation();
            object = n2 == 34 ? this._parseName() : this._handleOddName(n2);
            this._parsingContext.setCurrentName((String)object);
            this._currToken = JsonToken.FIELD_NAME;
            n2 = this._skipColon();
        }
        this._updateLocation();
        switch (n2) {
            case 34: {
                this._tokenIncomplete = true;
                object = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl2) {
                    this.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl2) {
                    this.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_OBJECT;
                break;
            }
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchTrue();
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchFalse();
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                object = this._parseSignedNumber(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    object = this._parseSignedNumber(false);
                    break;
                }
                object = this._handleOddValue(n2);
                break;
            }
            case 46: {
                object = this._parseFloatThatStartsWithPeriod(false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this._parseUnsignedNumber(n2);
                break;
            }
            default: {
                object = this._handleOddValue(n2);
            }
        }
        if (bl2) {
            this._nextToken = object;
            return this._currToken;
        }
        this._currToken = object;
        return object;
    }

    private final JsonToken _nextAfterName() throws IOException {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public String nextFieldName() throws IOException {
        JsonToken jsonToken;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if ((n2 | 0x20) == 125) {
            this._closeScope(n2);
            return null;
        }
        if (this._parsingContext.expectComma()) {
            n2 = this._skipComma(n2);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 | 0x20) == 125) {
                this._closeScope(n2);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n2);
            return null;
        }
        this._updateNameLocation();
        String string = n2 == 34 ? this._parseName() : this._handleOddName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipColon();
        this._updateLocation();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n2) {
            case 45: {
                jsonToken = this._parseSignedNumber(true);
                break;
            }
            case 43: {
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    jsonToken = this._parseSignedNumber(false);
                    break;
                }
                jsonToken = this._handleOddValue(n2);
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod(false);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parseUnsignedNumber(n2);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    private final JsonToken _nextTokenNotInObject(int n2) throws IOException {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                this.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseSignedNumber(true);
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod(false);
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parseUnsignedNumber(n2);
                return this._currToken;
            }
            case 44: {
                if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                --this._inputPtr;
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
        }
        this._currToken = this._handleOddValue(n2);
        return this._currToken;
    }

    @Override
    public final String nextTextValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public final int nextIntValue(int n2) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n2;
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod(boolean bl2) throws IOException {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleOddValue(46);
        }
        int n2 = this._inputPtr - 1;
        if (bl2) {
            --n2;
        }
        return this._parseFloat(46, n2, this._inputPtr, bl2, 0);
    }

    protected final JsonToken _parseUnsignedNumber(int n2) throws IOException {
        int n3 = this._inputPtr;
        int n4 = n3 - 1;
        int n5 = this._inputEnd;
        if (n2 == 48) {
            return this._parseNumber2(false, n4);
        }
        int n6 = 1;
        while (true) {
            if (n3 >= n5) {
                this._inputPtr = n4;
                return this._parseNumber2(false, n4);
            }
            if ((n2 = this._inputBuffer[n3++]) < 48 || n2 > 57) break;
            ++n6;
        }
        if (n2 == 46 || (n2 | 0x20) == 101) {
            this._inputPtr = n3;
            return this._parseFloat(n2, n4, n3, false, n6);
        }
        this._inputPtr = --n3;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n2);
        }
        int n7 = n3 - n4;
        this._textBuffer.resetWithShared(this._inputBuffer, n4, n7);
        return this.resetInt(false, n6);
    }

    private final JsonToken _parseFloat(int n2, int n3, int n4, boolean bl2, int n5) throws IOException {
        int n6 = this._inputEnd;
        int n7 = 0;
        if (n2 == 46) {
            while (true) {
                if (n4 >= n6) {
                    return this._parseNumber2(bl2, n3);
                }
                if ((n2 = this._inputBuffer[n4++]) < 48 || n2 > 57) break;
                ++n7;
            }
            if (n7 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n8 = 0;
        if ((n2 | 0x20) == 101) {
            if (n4 >= n6) {
                this._inputPtr = n3;
                return this._parseNumber2(bl2, n3);
            }
            if ((n2 = this._inputBuffer[n4++]) == 45 || n2 == 43) {
                if (n4 >= n6) {
                    this._inputPtr = n3;
                    return this._parseNumber2(bl2, n3);
                }
                n2 = this._inputBuffer[n4++];
            }
            while (n2 <= 57 && n2 >= 48) {
                ++n8;
                if (n4 >= n6) {
                    this._inputPtr = n3;
                    return this._parseNumber2(bl2, n3);
                }
                n2 = this._inputBuffer[n4++];
            }
            if (n8 == 0) {
                this._reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        this._inputPtr = --n4;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n2);
        }
        int n9 = n4 - n3;
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n9);
        return this.resetFloat(bl2, n5, n7, n8);
    }

    private final JsonToken _parseSignedNumber(boolean bl2) throws IOException {
        char c2;
        int n2 = this._inputPtr;
        int n3 = bl2 ? n2 - 1 : n2;
        int n4 = this._inputEnd;
        if (n2 >= n4) {
            return this._parseNumber2(bl2, n3);
        }
        if ((c2 = this._inputBuffer[n2++]) > '9' || c2 < '0') {
            this._inputPtr = n2;
            if (c2 == '.') {
                return this._parseFloatThatStartsWithPeriod(bl2);
            }
            return this._handleInvalidNumberStart(c2, bl2, true);
        }
        if (c2 == '0') {
            return this._parseNumber2(bl2, n3);
        }
        int n5 = 1;
        while (true) {
            if (n2 >= n4) {
                return this._parseNumber2(bl2, n3);
            }
            if ((c2 = this._inputBuffer[n2++]) < '0' || c2 > '9') break;
            ++n5;
        }
        if (c2 == '.' || (c2 | 0x20) == 101) {
            this._inputPtr = n2;
            return this._parseFloat(c2, n3, n2, bl2, n5);
        }
        this._inputPtr = --n2;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(c2);
        }
        int n6 = n2 - n3;
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n6);
        return this.resetInt(bl2, n5);
    }

    private final JsonToken _parseNumber2(boolean bl2, int n2) throws IOException {
        char c2;
        this._inputPtr = bl2 ? n2 + 1 : n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        if (bl2) {
            cArray[n3++] = 45;
        }
        int n4 = 0;
        char c3 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following sign", JsonToken.VALUE_NUMBER_INT);
        if (c2 == '0') {
            c2 = this._verifyNoLeadingZeroes();
        }
        boolean bl3 = false;
        while (c2 >= '0' && c2 <= '9') {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                c2 = '\u0000';
                bl3 = true;
                break;
            }
            c2 = this._inputBuffer[this._inputPtr++];
        }
        if (!(n4 != 0 || c2 == '.' && this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature()))) {
            return this._handleInvalidNumberStart(c2, bl2);
        }
        int n5 = -1;
        if (c2 == '.') {
            n5 = 0;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = c2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) < '0' || c2 > '9') break;
                ++n5;
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = c2;
            }
            if (n5 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(c2, "Decimal point not followed by a digit");
            }
        }
        int n6 = -1;
        if ((c2 | 0x20) == 101) {
            n6 = 0;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = c2;
            char c4 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent", JsonToken.VALUE_NUMBER_FLOAT);
            if (c2 == '-' || c2 == '+') {
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = c2;
                char c5 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent", JsonToken.VALUE_NUMBER_FLOAT);
            }
            while (c2 <= '9' && c2 >= '0') {
                ++n6;
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = c2;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl3 = true;
                    break;
                }
                c2 = this._inputBuffer[this._inputPtr++];
            }
            if (n6 == 0) {
                this._reportUnexpectedNumberChar(c2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl3) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(c2);
            }
        }
        this._textBuffer.setCurrentLength(n3);
        if (n5 < 0 && n6 < 0) {
            return this.resetInt(bl2, n4);
        }
        return this.resetFloat(bl2, n4, n5, n6);
    }

    private final char _verifyNoLeadingZeroes() throws IOException {
        char c2;
        if (this._inputPtr < this._inputEnd && ((c2 = this._inputBuffer[this._inputPtr]) < '0' || c2 > '9')) {
            return '0';
        }
        return this._verifyNLZ2();
    }

    private char _verifyNLZ2() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return '0';
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 < '0' || c2 > '9') {
            return '0';
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (c2 == '0') {
            while (this._inputPtr < this._inputEnd || this._loadMore()) {
                c2 = this._inputBuffer[this._inputPtr];
                if (c2 < '0' || c2 > '9') {
                    return '0';
                }
                ++this._inputPtr;
                if (c2 == '0') continue;
                break;
            }
        }
        return c2;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) throws IOException {
        return this._handleInvalidNumberStart(n2, bl2, false);
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2, boolean bl3) throws IOException {
        String string;
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 78) {
                string = bl2 ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
            } else if (n2 == 110) {
                string = bl2 ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
            }
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()) && bl3 && !bl2) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        string = bl2 ? "expected digit (0-9) to follow minus sign, for valid numeric value" : "expected digit (0-9) for valid numeric value";
        this._reportUnexpectedNumberChar(n2, string);
        return null;
    }

    private final void _verifyRootSpace(int n2) throws IOException {
        ++this._inputPtr;
        switch (n2) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                --this._inputPtr;
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n2);
    }

    protected final String _parseName() throws IOException {
        int n2;
        int n3;
        int n4 = this._hashSeed;
        int[] nArray = INPUT_CODES_LATIN1;
        for (n3 = this._inputPtr; n3 < this._inputEnd; ++n3) {
            n2 = this._inputBuffer[n3];
            if (n2 < nArray.length && nArray[n2] != 0) {
                if (n2 != 34) break;
                int n5 = this._inputPtr;
                this._inputPtr = n3 + 1;
                return this._symbols.findSymbol(this._inputBuffer, n5, n3 - n5, n4);
            }
            n4 = n4 * 33 + n2;
        }
        n2 = this._inputPtr;
        this._inputPtr = n3;
        return this._parseName2(n2, n4, 34);
    }

    private String _parseName2(int n2, int n3, int n4) throws IOException {
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n5 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            char c3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            if ((c3 = (c2 = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= n4) {
                    if (c3 == n4) break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "name");
                    }
                }
            }
            n3 = n3 * 33 + c2;
            cArray[n5++] = c2;
            if (n5 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n5 = 0;
        }
        this._textBuffer.setCurrentLength(n5);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n6 = textBuffer.getTextOffset();
        return this._symbols.findSymbol(cArray2, n6, textBuffer.size(), n3);
    }

    protected String _handleOddName(int n2) throws IOException {
        int n3;
        int[] nArray;
        int n4;
        boolean bl2;
        if (n2 == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            this._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        if (!(bl2 = n2 < (n4 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? nArray[n2] == 0 : Character.isJavaIdentifierPart((char)n2))) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int n5 = this._inputPtr;
        int n6 = this._hashSeed;
        int n7 = this._inputEnd;
        if (n5 < n7) {
            do {
                if ((n3 = this._inputBuffer[n5]) < n4) {
                    if (nArray[n3] != 0) {
                        int n8 = this._inputPtr - 1;
                        this._inputPtr = n5;
                        return this._symbols.findSymbol(this._inputBuffer, n8, n5 - n8, n6);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n3)) {
                    int n9 = this._inputPtr - 1;
                    this._inputPtr = n5;
                    return this._symbols.findSymbol(this._inputBuffer, n9, n5 - n9, n6);
                }
                n6 = n6 * 33 + n3;
            } while (++n5 < n7);
        }
        n3 = this._inputPtr - 1;
        this._inputPtr = n5;
        return this._handleOddName2(n3, n6, nArray);
    }

    protected String _parseAposName() throws IOException {
        int n2 = this._inputPtr;
        int n3 = this._hashSeed;
        int n4 = this._inputEnd;
        if (n2 < n4) {
            int[] nArray = INPUT_CODES_LATIN1;
            int n5 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) == '\'') {
                    int n6 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n6, n2 - n6, n3);
                }
                if (c2 < n5 && nArray[c2] != 0) break;
                n3 = n3 * 33 + c2;
            } while (++n2 < n4);
        }
        int n7 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseName2(n7, n3, 39);
    }

    protected JsonToken _handleOddValue(int n2) throws IOException {
        switch (n2) {
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                --this._inputPtr;
                return JsonToken.VALUE_NULL;
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false, true);
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            this._reportInvalidToken("" + (char)n2, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n2, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            char c3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            if ((c3 = (c2 = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\'') {
                    if (c3 == '\'') break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    private String _handleOddName2(int n2, int n3, int[] nArray) throws IOException {
        char c2;
        char c3;
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        int n5 = nArray.length;
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && !((c3 = (c2 = this._inputBuffer[this._inputPtr])) < n5 ? nArray[c3] != 0 : !Character.isJavaIdentifierPart(c2))) {
            ++this._inputPtr;
            n3 = n3 * 33 + c3;
            cArray[n4++] = c2;
            if (n4 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n4 = 0;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n6 = textBuffer.getTextOffset();
        return this._symbols.findSymbol(cArray2, n6, textBuffer.size(), n3);
    }

    @Override
    protected final void _finishString() throws IOException {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        if (n2 < n3) {
            int[] nArray = INPUT_CODES_LATIN1;
            int n4 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) >= n4 || nArray[c2] == 0) continue;
                if (c2 != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
                this._inputPtr = n2 + 1;
                return;
            } while (++n2 < n3);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
        this._inputPtr = n2;
        this._finishString2();
    }

    protected void _finishString2() throws IOException {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int[] nArray = INPUT_CODES_LATIN1;
        int n3 = nArray.length;
        while (true) {
            char c2;
            char c3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            if ((c3 = (c2 = this._inputBuffer[this._inputPtr++])) < n3 && nArray[c3] != 0) {
                if (c3 == '\"') break;
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 < ' ') {
                    this._throwUnquotedSpace(c3, "string value");
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected final void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c2;
            char c3;
            if (n2 >= n3) {
                this._inputPtr = n2;
                if (!this._loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
                }
                n2 = this._inputPtr;
                n3 = this._inputEnd;
            }
            if ((c3 = (c2 = cArray[n2++])) > '\\') continue;
            if (c3 == '\\') {
                this._inputPtr = n2;
                this._decodeEscaped();
                n2 = this._inputPtr;
                n3 = this._inputEnd;
                continue;
            }
            if (c3 > '\"') continue;
            if (c3 == '\"') break;
            if (c3 >= ' ') continue;
            this._inputPtr = n2;
            this._throwUnquotedSpace(c3, "string value");
        }
        this._inputPtr = n2;
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private final int _skipColon() throws IOException {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 == ':') {
            char c3;
            if ((c3 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c3 == '/' || c3 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c3;
            }
            if ((c3 == ' ' || c3 == '\t') && (c3 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c3 == '/' || c3 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c3;
            }
            return this._skipColon2(true);
        }
        if (c2 == ' ' || c2 == '\t') {
            c2 = this._inputBuffer[++this._inputPtr];
        }
        if (c2 == ':') {
            char c4;
            if ((c4 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c4 == '/' || c4 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c4;
            }
            if ((c4 == ' ' || c4 == '\t') && (c4 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c4 == '/' || c4 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c4;
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private final int _skipColon2(boolean bl2) throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                if (c2 == '#' && this._skipYAMLComment()) continue;
                if (bl2) {
                    return c2;
                }
                if (c2 != ':') {
                    this._reportUnexpectedChar(c2, "was expecting a colon to separate field name and value");
                }
                bl2 = true;
                continue;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private final int _skipComma(int n2) throws IOException {
        if (n2 != 44) {
            this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n2 = this._inputBuffer[this._inputPtr++]) > 32) {
                if (n2 == 47 || n2 == 35) {
                    --this._inputPtr;
                    return this._skipAfterComma2();
                }
                return n2;
            }
            if (n2 >= 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._skipAfterComma2();
    }

    private final int _skipAfterComma2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                if (c2 == '#' && this._skipYAMLComment()) continue;
                return c2;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException {
        char c2;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (c2 == '/' || c2 == '#') {
                --this._inputPtr;
                return this._skipWSOrEnd2();
            }
            return c2;
        }
        if (c2 != ' ') {
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (c2 == '\r') {
                this._skipCR();
            } else if (c2 != '\t') {
                this._throwInvalidSpace(c2);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    --this._inputPtr;
                    return this._skipWSOrEnd2();
                }
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this._skipWSOrEnd2();
    }

    private int _skipWSOrEnd2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                if (c2 == '#' && this._skipYAMLComment()) continue;
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this._eofAsNextChar();
    }

    private void _skipComment() throws IOException {
        char c2;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipLine();
        } else if (c2 == '*') {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c2, "was expecting either '*' or '/' for a comment");
        }
    }

    private void _skipCComment() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c2 == '*') {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private boolean _skipYAMLComment() throws IOException {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private void _skipLine() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (c2 == '\r') {
                this._skipCR();
                break;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        char c2 = this._inputBuffer[this._inputPtr++];
        switch (c2) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c2;
            }
            case 'u': {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape(c2);
            }
        }
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            char c3;
            int n3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((n3 = CharTypes.charToHex(c3 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c3, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n3;
        }
        return (char)n2;
    }

    private final void _matchTrue() throws IOException {
        char c2;
        char[] cArray;
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd && (cArray = this._inputBuffer)[n2] == 'r' && cArray[++n2] == 'u' && cArray[++n2] == 'e' && ((c2 = cArray[++n2]) < '0' || c2 == ']' || c2 == '}')) {
            this._inputPtr = n2;
            return;
        }
        this._matchToken("true", 1);
    }

    private final void _matchFalse() throws IOException {
        char c2;
        char[] cArray;
        int n2 = this._inputPtr;
        if (n2 + 4 < this._inputEnd && (cArray = this._inputBuffer)[n2] == 'a' && cArray[++n2] == 'l' && cArray[++n2] == 's' && cArray[++n2] == 'e' && ((c2 = cArray[++n2]) < '0' || c2 == ']' || c2 == '}')) {
            this._inputPtr = n2;
            return;
        }
        this._matchToken("false", 1);
    }

    private final void _matchNull() throws IOException {
        char c2;
        char[] cArray;
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd && (cArray = this._inputBuffer)[n2] == 'u' && cArray[++n2] == 'l' && cArray[++n2] == 'l' && ((c2 = cArray[++n2]) < '0' || c2 == ']' || c2 == '}')) {
            this._inputPtr = n2;
            return;
        }
        this._matchToken("null", 1);
    }

    protected final void _matchToken(String string, int n2) throws IOException {
        int n3 = string.length();
        if (this._inputPtr + n3 >= this._inputEnd) {
            this._matchToken2(string, n2);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 >= '0' && c2 != ']' && c2 != '}') {
            this._checkMatchEnd(string, n2, c2);
        }
    }

    private final void _matchToken2(String string, int n2) throws IOException {
        int n3 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return;
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 >= '0' && c2 != ']' && c2 != '}') {
            this._checkMatchEnd(string, n2, c2);
        }
    }

    private final void _checkMatchEnd(String string, int n2, int n3) throws IOException {
        char c2 = (char)n3;
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(string.substring(0, n2));
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n2 = base64Variant.decodeBase64Char(c2);
            if (n2 < 0) {
                if (c2 == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n2 != -2) {
                    if (c2 == '\"') {
                        byteArrayBuilder.append(n3 >>= 4);
                        if (base64Variant.requiresPaddingOnRead()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(base64Variant, c2, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n2 != -2) {
                    if (c2 == '\"') {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        if (base64Variant.requiresPaddingOnRead()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }

    @Override
    public JsonLocation currentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    protected JsonLocation _currentLocationMinusOne() {
        int n2 = this._inputPtr - 1;
        int n3 = n2 - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), -1L, this._currInputProcessed + (long)n2, this._currInputRow, n3);
    }

    @Override
    public JsonLocation currentTokenLocation() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            long l2 = this._currInputProcessed + (this._nameStartOffset - 1L);
            return new JsonLocation(this._contentReference(), -1L, l2, this._nameStartRow, this._nameStartCol);
        }
        return new JsonLocation(this._contentReference(), -1L, this._tokenInputTotal - 1L, this._tokenInputRow, this._tokenInputCol);
    }

    private final void _updateLocation() {
        int n2 = this._inputPtr;
        this._tokenInputTotal = this._currInputProcessed + (long)n2;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = n2 - this._currInputRowStart;
    }

    private final void _updateNameLocation() {
        int n2 = this._inputPtr;
        this._nameStartOffset = n2;
        this._nameStartRow = this._currInputRow;
        this._nameStartCol = n2 - this._currInputRowStart;
    }

    protected void _reportInvalidToken(String string) throws IOException {
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c2 = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            stringBuilder.append(c2);
            if (stringBuilder.length() < this._ioContext.errorReportConfiguration().getMaxErrorTokenLength()) continue;
            stringBuilder.append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", stringBuilder, string2);
    }

    private void _closeScope(int n2) throws JsonParseException {
        if (n2 == 93) {
            this._updateLocation();
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n2 == 125) {
            this._updateLocation();
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }
}

