/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.common;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.Sensors;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import java.util.Arrays;
import java.util.function.Supplier;

public abstract class AbstractSensors
implements Sensors {
    private final Supplier<Double> cpuTemperature = Memoizer.memoize(this::queryCpuTemperature, Memoizer.defaultExpiration());
    private final Supplier<int[]> fanSpeeds = Memoizer.memoize(this::queryFanSpeeds, Memoizer.defaultExpiration());
    private final Supplier<Double> cpuVoltage = Memoizer.memoize(this::queryCpuVoltage, Memoizer.defaultExpiration());

    public double getCpuTemperature() {
        return this.cpuTemperature.get();
    }

    protected abstract double queryCpuTemperature();

    public int[] getFanSpeeds() {
        return this.fanSpeeds.get();
    }

    protected abstract int[] queryFanSpeeds();

    public double getCpuVoltage() {
        return this.cpuVoltage.get();
    }

    protected abstract double queryCpuVoltage();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CPU Temperature=").append(this.getCpuTemperature()).append("C, ");
        stringBuilder.append("Fan Speeds=").append(Arrays.toString(this.getFanSpeeds())).append(", ");
        stringBuilder.append("CPU Voltage=").append(this.getCpuVoltage());
        return stringBuilder.toString();
    }
}

