/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.concurrent;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.concurrent.ConcurrentException;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.function.FailableConsumer;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.function.FailableSupplier;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicInitializer<T>
extends AbstractConcurrentInitializer<T, ConcurrentException> {
    private static final Object NO_INIT = new Object();
    private final AtomicReference<T> reference = new AtomicReference<T>(this.getNoInit());

    public static <T> Builder<AtomicInitializer<T>, T> builder() {
        return new Builder();
    }

    public AtomicInitializer() {
    }

    private AtomicInitializer(FailableSupplier<T, ConcurrentException> failableSupplier, FailableConsumer<T, ConcurrentException> failableConsumer) {
        super(failableSupplier, failableConsumer);
    }

    @Override
    public T get() throws ConcurrentException {
        T t2 = this.reference.get();
        if (t2 == this.getNoInit()) {
            t2 = this.initialize();
            if (!this.reference.compareAndSet(this.getNoInit(), t2)) {
                t2 = this.reference.get();
            }
        }
        return t2;
    }

    private T getNoInit() {
        return (T)NO_INIT;
    }

    @Override
    protected ConcurrentException getTypedException(Exception exception) {
        return new ConcurrentException(exception);
    }

    public static class Builder<I extends AtomicInitializer<T>, T>
    extends AbstractConcurrentInitializer.AbstractBuilder<I, T, Builder<I, T>, ConcurrentException> {
        @Override
        public I get() {
            return (I)new AtomicInitializer(this.getInitializer(), this.getCloser());
        }
    }
}

