/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.DuplicatedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.SlicedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    ReadOnlyByteBufferBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBuffer.remaining());
        if (!byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName(byteBuffer));
        }
        this.allocator = byteBufAllocator;
        this.buffer = byteBuffer.slice().order(ByteOrder.BIG_ENDIAN);
        this.writerIndex(this.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n2) {
        return false;
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        return 1;
    }

    @Override
    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return this.buffer.get(n2);
    }

    @Override
    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    @Override
    protected short _getShort(int n2) {
        return this.buffer.getShort(n2);
    }

    @Override
    public short getShortLE(int n2) {
        this.ensureAccessible();
        return this._getShortLE(n2);
    }

    @Override
    protected short _getShortLE(int n2) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n2));
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return (this.getByte(n2) & 0xFF) << 16 | (this.getByte(n2 + 1) & 0xFF) << 8 | this.getByte(n2 + 2) & 0xFF;
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(n2);
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return this.getByte(n2) & 0xFF | (this.getByte(n2 + 1) & 0xFF) << 8 | (this.getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    @Override
    protected int _getInt(int n2) {
        return this.buffer.getInt(n2);
    }

    @Override
    public int getIntLE(int n2) {
        this.ensureAccessible();
        return this._getIntLE(n2);
    }

    @Override
    protected int _getIntLE(int n2) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n2));
    }

    @Override
    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    @Override
    protected long _getLong(int n2) {
        return this.buffer.getLong(n2);
    }

    @Override
    public long getLongLE(int n2) {
        this.ensureAccessible();
        return this._getLongLE(n2);
    }

    @Override
    protected long _getLongLE(int n2) {
        return ByteBufUtil.swapLong(this.buffer.getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.getBytes(n2, byteBuf, n3, n4, false);
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byteBuf, n2, n3, true);
        this.readerIndex += n3;
        return this;
    }

    protected ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4, boolean bl2) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.getBytes(n2, byteBuffer, bl2);
                n2 += n5;
            }
        } else {
            byteBuf.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.getBytes(n2, byArray, n3, n4, false);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byArray, n2, n3, true);
        this.readerIndex += n3;
        return this;
    }

    protected ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = this.nioBuffer(bl2);
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.get(byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        return this.getBytes(n2, byteBuffer, false);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer, true);
        this.readerIndex += n2;
        return this;
    }

    private ByteBuf getBytes(int n2, ByteBuffer byteBuffer, boolean bl2) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = this.nioBuffer(bl2);
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl2) throws IOException {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.nioBuffer(bl2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        throw new ReadOnlyBufferException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    private ByteBuffer nioBuffer(boolean bl2) {
        return bl2 ? this.internalNioBuffer() : this.buffer.duplicate();
    }

    @Override
    public ByteBuf duplicate() {
        return new ReadOnlyDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        return new ReadOnlySlicedByteBuf(this, n2, n3);
    }

    @Override
    public ByteBuf asReadOnly() {
        return this;
    }

    private static final class ReadOnlyDuplicatedByteBuf
    extends DuplicatedByteBuf {
        ReadOnlyDuplicatedByteBuf(ByteBuf byteBuf) {
            super(byteBuf);
        }

        @Override
        public ByteBuf asReadOnly() {
            return this;
        }

        @Override
        public ByteBuf slice(int n2, int n3) {
            return new ReadOnlySlicedByteBuf(this, n2, n3);
        }

        @Override
        public ByteBuf duplicate() {
            return new ReadOnlyDuplicatedByteBuf(this);
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isWritable(int n2) {
            return false;
        }

        @Override
        public int ensureWritable(int n2, boolean bl2) {
            return 1;
        }
    }

    private static final class ReadOnlySlicedByteBuf
    extends SlicedByteBuf {
        ReadOnlySlicedByteBuf(ByteBuf byteBuf, int n2, int n3) {
            super(byteBuf, n2, n3);
        }

        @Override
        public ByteBuf asReadOnly() {
            return this;
        }

        @Override
        public ByteBuf slice(int n2, int n3) {
            return new ReadOnlySlicedByteBuf(this, n2, n3);
        }

        @Override
        public ByteBuf duplicate() {
            return this.slice(0, this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isWritable(int n2) {
            return false;
        }

        @Override
        public int ensureWritable(int n2, boolean bl2) {
            return 1;
        }
    }
}

