/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.util.GradleVersion;

final class Utils {
    private static final Pattern GIT_REPO_URI_PATTERN = Pattern.compile("^(?:(?:https://|git://)(?:.+:.+@)?|(?:ssh)?.*?@)(.*?(?:github|gitlab).*?)(?:/|:[0-9]*?/|:)(.*?)(?:\\.git)?$");

    static Optional<String> sysPropertyOrEnvVariable(String sysPropertyName, String envVarName, ProviderFactory providers) {
        Optional<String> sysProperty = Utils.sysProperty(sysPropertyName, providers);
        return sysProperty.isPresent() ? sysProperty : Utils.envVariable(envVarName, providers);
    }

    static Optional<Boolean> booleanSysPropertyOrEnvVariable(String sysPropertyName, String envVarName, ProviderFactory providers) {
        Optional<Boolean> sysProperty = Utils.booleanSysProperty(sysPropertyName, providers);
        return sysProperty.isPresent() ? sysProperty : Utils.booleanEnvVariable(envVarName, providers);
    }

    static Optional<Duration> durationSysPropertyOrEnvVariable(String sysPropertyName, String envVarName, ProviderFactory providers) {
        Optional<Duration> sysProperty = Utils.durationSysProperty(sysPropertyName, providers);
        return sysProperty.isPresent() ? sysProperty : Utils.durationEnvVariable(envVarName, providers);
    }

    static Optional<String> envVariable(String name, ProviderFactory providers) {
        if (Utils.isGradle65OrNewer() && !Utils.isGradle74OrNewer()) {
            Provider variable = providers.environmentVariable(name).forUseAtConfigurationTime();
            return Optional.ofNullable(variable.getOrNull());
        }
        return Optional.ofNullable(System.getenv(name));
    }

    static Optional<Boolean> booleanEnvVariable(String name, ProviderFactory providers) {
        return Utils.envVariable(name, providers).map(Boolean::parseBoolean);
    }

    static Optional<Duration> durationEnvVariable(String name, ProviderFactory providers) {
        return Utils.envVariable(name, providers).map(Duration::parse);
    }

    static Optional<String> sysProperty(String name, ProviderFactory providers) {
        if (Utils.isGradle65OrNewer() && !Utils.isGradle74OrNewer()) {
            Provider property = providers.systemProperty(name).forUseAtConfigurationTime();
            return Optional.ofNullable(property.getOrNull());
        }
        return Optional.ofNullable(System.getProperty(name));
    }

    static Optional<Boolean> booleanSysProperty(String name, ProviderFactory providers) {
        return Utils.sysProperty(name, providers).map(Boolean::parseBoolean);
    }

    static Optional<Duration> durationSysProperty(String name, ProviderFactory providers) {
        return Utils.sysProperty(name, providers).map(Duration::parse);
    }

    static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    static String appendIfMissing(String string, char suffix) {
        return string.length() > 0 && string.charAt(string.length() - 1) == suffix ? string : string + suffix;
    }

    static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static String redactUserInfo(String url) {
        try {
            String userInfo = new URI(url).getUserInfo();
            return userInfo == null ? url : url.replace(userInfo + '@', "******@");
        }
        catch (URISyntaxException e) {
            return url;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties readPropertiesFile(String name, ProviderFactory providers, Directory projectDirectory) {
        try (InputStream input = Utils.readFile(name, providers, projectDirectory);){
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static InputStream readFile(String name, ProviderFactory providers, Directory projectDirectory) throws FileNotFoundException {
        if (Utils.isGradle65OrNewer()) {
            RegularFile file = projectDirectory.file(name);
            Provider fileContent = providers.fileContents(file).getAsBytes();
            return new ByteArrayInputStream((byte[])fileContent.getOrElse((Object)new byte[0]));
        }
        return new FileInputStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execAndCheckSuccess(String ... args) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(args);
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            boolean bl = finished && process.exitValue() == 0;
            return bl;
        }
        catch (IOException | InterruptedException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    /*
     * Exception decompiling
     */
    static String execAndGetStdOut(String ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readFully(Reader reader) throws IOException {
        int nRead;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((nRead = reader.read(buf)) != -1) {
            sb.append(buf, 0, nRead);
        }
        return sb.toString();
    }

    private static String trimAtEnd(String str) {
        return ('x' + str).trim().substring(1);
    }

    static boolean isGradle4OrNewer() {
        return Utils.isGradleNewerThan("4.0");
    }

    public static boolean isGradle43rNewer() {
        return Utils.isGradleNewerThan("4.3");
    }

    static boolean isGradle5OrNewer() {
        return Utils.isGradleNewerThan("5.0");
    }

    static boolean isGradle56OrNewer() {
        return Utils.isGradleNewerThan("5.6");
    }

    static boolean isGradle6OrNewer() {
        return Utils.isGradleNewerThan("6.0");
    }

    static boolean isGradle61OrNewer() {
        return Utils.isGradleNewerThan("6.1");
    }

    static boolean isGradle62OrNewer() {
        return Utils.isGradleNewerThan("6.2");
    }

    static boolean isGradle65OrNewer() {
        return Utils.isGradleNewerThan("6.5");
    }

    static boolean isGradle74OrNewer() {
        return Utils.isGradleNewerThan("7.4");
    }

    private static boolean isGradleNewerThan(String version) {
        return GradleVersion.current().compareTo(GradleVersion.version((String)version)) >= 0;
    }

    static Optional<URI> toWebRepoUri(String gitRepoUri) {
        Matcher matcher = GIT_REPO_URI_PATTERN.matcher(gitRepoUri);
        if (matcher.matches()) {
            String scheme = "https";
            String host = matcher.group(1);
            String path = matcher.group(2).startsWith("/") ? matcher.group(2) : "/" + matcher.group(2);
            return Utils.toUri(scheme, host, path);
        }
        return Optional.empty();
    }

    private static Optional<URI> toUri(String scheme, String host, String path) {
        try {
            return Optional.of(new URI(scheme, host, path, null));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private Utils() {
    }
}

