/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.lib;

import gradlegitproperties.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import gradlegitproperties.org.eclipse.jgit.errors.MissingObjectException;
import gradlegitproperties.org.eclipse.jgit.lib.AnyObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectInserter;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectLoader;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectReader;
import java.io.IOException;

public abstract class ObjectDatabase {
    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public abstract void close();

    public boolean has(AnyObjectId objectId) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectReader or = this.newReader();){
            return or.has(objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws IOException {
        return this.open(objectId, -1);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectReader or = this.newReader();){
            return or.open(objectId, typeHint);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }
}

