/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.internal.storage.file;

import gradlegitproperties.org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import gradlegitproperties.org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import gradlegitproperties.org.eclipse.jgit.internal.storage.file.Pack;
import gradlegitproperties.org.eclipse.jgit.internal.storage.file.WindowCursor;
import gradlegitproperties.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import gradlegitproperties.org.eclipse.jgit.internal.storage.pack.PackWriter;
import gradlegitproperties.org.eclipse.jgit.lib.AbbreviatedObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.AnyObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.Config;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectDatabase;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectLoader;
import gradlegitproperties.org.eclipse.jgit.util.FS;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class CachedObjectDirectory
extends FileObjectDatabase {
    private ObjectIdOwnerMap<UnpackedObjectId> unpackedObjects;
    private final ObjectDirectory wrapped;
    private CachedObjectDirectory[] alts;

    CachedObjectDirectory(ObjectDirectory wrapped) {
        this.wrapped = wrapped;
        this.unpackedObjects = this.scanLoose();
    }

    private ObjectIdOwnerMap<UnpackedObjectId> scanLoose() {
        ObjectIdOwnerMap<UnpackedObjectId> m = new ObjectIdOwnerMap<UnpackedObjectId>();
        File objects = this.wrapped.getDirectory();
        String[] fanout = objects.list();
        if (fanout == null) {
            return m;
        }
        String[] stringArray = fanout;
        int n = fanout.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entries;
            String d = stringArray[n2];
            if (d.length() == 2 && (entries = new File(objects, d).list()) != null) {
                String[] stringArray2 = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    String e = stringArray2[n4];
                    if (e.length() == 38) {
                        try {
                            ObjectId id = ObjectId.fromString(String.valueOf(d) + e);
                            m.add(new UnpackedObjectId(id));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return m;
    }

    @Override
    public void close() {
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this;
    }

    @Override
    File getDirectory() {
        return this.wrapped.getDirectory();
    }

    @Override
    File fileFor(AnyObjectId id) {
        return this.wrapped.fileFor(id);
    }

    @Override
    Config getConfig() {
        return this.wrapped.getConfig();
    }

    @Override
    FS getFS() {
        return this.wrapped.getFS();
    }

    @Override
    Set<ObjectId> getShallowCommits() throws IOException {
        return this.wrapped.getShallowCommits();
    }

    private CachedObjectDirectory[] myAlternates() {
        if (this.alts == null) {
            ObjectDirectory.AlternateHandle[] src = this.wrapped.myAlternates();
            this.alts = new CachedObjectDirectory[src.length];
            int i = 0;
            while (i < this.alts.length) {
                this.alts[i] = src[i].db.newCachedFileObjectDatabase();
                ++i;
            }
        }
        return this.alts;
    }

    private Set<ObjectDirectory.AlternateHandle.Id> skipMe(Set<ObjectDirectory.AlternateHandle.Id> skips) {
        HashSet<ObjectDirectory.AlternateHandle.Id> withMe = new HashSet<ObjectDirectory.AlternateHandle.Id>();
        if (skips != null) {
            withMe.addAll(skips);
        }
        withMe.add(this.getAlternateId());
        return withMe;
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        this.wrapped.resolve(matches, id);
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        return this.has(objectId, null);
    }

    private boolean has(AnyObjectId objectId, Set<ObjectDirectory.AlternateHandle.Id> skips) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return true;
        }
        if (this.wrapped.hasPackedObject(objectId)) {
            return true;
        }
        skips = this.skipMe(skips);
        CachedObjectDirectory[] cachedObjectDirectoryArray = this.myAlternates();
        int n = cachedObjectDirectoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CachedObjectDirectory alt = cachedObjectDirectoryArray[n2];
            if (!skips.contains(alt.getAlternateId()) && alt.has(objectId, skips)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        return this.openObject(curs, objectId, null);
    }

    private ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId, Set<ObjectDirectory.AlternateHandle.Id> skips) throws IOException {
        ObjectLoader ldr = this.openLooseObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        ldr = this.wrapped.openPackedObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.skipMe(skips);
        CachedObjectDirectory[] cachedObjectDirectoryArray = this.myAlternates();
        int n = cachedObjectDirectoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CachedObjectDirectory alt = cachedObjectDirectoryArray[n2];
            if (!skips.contains(alt.getAlternateId()) && (ldr = alt.openObject(curs, objectId, skips)) != null) {
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    @Override
    long getObjectSize(WindowCursor curs, AnyObjectId objectId) throws IOException {
        return this.wrapped.getObjectSize(curs, objectId);
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor curs, AnyObjectId id) throws IOException {
        if (this.unpackedObjects.contains(id)) {
            ObjectLoader ldr = this.wrapped.openLooseObject(curs, id);
            if (ldr != null) {
                return ldr;
            }
            this.unpackedObjects = this.scanLoose();
        }
        return null;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId objectId, boolean createDuplicate) throws IOException {
        FileObjectDatabase.InsertLooseObjectResult result = this.wrapped.insertUnpackedObject(tmp, objectId, createDuplicate);
        switch (result) {
            case INSERTED: 
            case EXISTS_LOOSE: {
                this.unpackedObjects.addIfAbsent(new UnpackedObjectId(objectId));
                break;
            }
        }
        return result;
    }

    @Override
    Pack openPack(File pack) throws IOException {
        return this.wrapped.openPack(pack);
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.wrapped.selectObjectRepresentation(packer, otp, curs);
    }

    @Override
    Collection<Pack> getPacks() {
        return this.wrapped.getPacks();
    }

    private ObjectDirectory.AlternateHandle.Id getAlternateId() {
        return this.wrapped.getAlternateId();
    }

    private static class UnpackedObjectId
    extends ObjectIdOwnerMap.Entry {
        UnpackedObjectId(AnyObjectId id) {
            super(id);
        }
    }
}

