/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Android;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.CanIgnoreReturnValue;
import com.google.protobuf.CheckReturnValue;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.CompileTimeConstant;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.RopeByteString;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

@CheckReturnValue
public abstract class ByteString
implements Iterable<Byte>,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    public static final ByteString EMPTY = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new SystemByteArrayCopier() : new ArraysByteArrayCopier();
    private int hash = 0;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final Comparator<ByteString> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new Comparator<ByteString>(){

        @Override
        public int compare(ByteString former, ByteString latter) {
            ByteIterator formerBytes = former.iterator();
            ByteIterator latterBytes = latter.iterator();
            while (formerBytes.hasNext() && latterBytes.hasNext()) {
                int result = Integer.compare(ByteString.toInt(formerBytes.nextByte()), ByteString.toInt(latterBytes.nextByte()));
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(former.size(), latter.size());
        }
    };

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public ByteIterator iterator() {
        return new AbstractByteIterator(){
            private int position = 0;
            private final int limit = ByteString.this.size();

            @Override
            public boolean hasNext() {
                return this.position < this.limit;
            }

            @Override
            public byte nextByte() {
                int currentPos = this.position;
                if (currentPos >= this.limit) {
                    throw new NoSuchElementException();
                }
                this.position = currentPos + 1;
                return ByteString.this.internalByteAt(currentPos);
            }
        };
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public static final ByteString empty() {
        return EMPTY;
    }

    private static int toInt(byte value) {
        return value & 0xFF;
    }

    private static int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private static int extractHexDigit(String hexString, int index) {
        int digit = ByteString.hexDigit(hexString.charAt(index));
        if (digit == -1) {
            throw new NumberFormatException("Invalid hexString " + hexString + " must only contain [0-9a-fA-F] but contained " + hexString.charAt(index) + " at index " + index);
        }
        return digit;
    }

    public static Comparator<ByteString> unsignedLexicographicalComparator() {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR;
    }

    public final ByteString substring(int beginIndex) {
        return this.substring(beginIndex, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    public final boolean startsWith(ByteString prefix) {
        return this.size() >= prefix.size() && this.substring(0, prefix.size()).equals(prefix);
    }

    public final boolean endsWith(ByteString suffix) {
        return this.size() >= suffix.size() && this.substring(this.size() - suffix.size()).equals(suffix);
    }

    public static ByteString fromHex(@CompileTimeConstant String hexString) {
        if (hexString.length() % 2 != 0) {
            throw new NumberFormatException("Invalid hexString " + hexString + " of length " + hexString.length() + " must be even.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int d1 = ByteString.extractHexDigit(hexString, 2 * i);
            int d2 = ByteString.extractHexDigit(hexString, 2 * i + 1);
            bytes[i] = (byte)(d1 << 4 | d2);
        }
        return new LiteralByteString(bytes);
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        try {
            return ByteString.copyFrom(bytes, offset, size, false);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError("Expected no InvalidProtocolBufferException as data UTF8 validity is not checked.", e);
        }
    }

    static ByteString copyFrom(byte[] bytes, int offset, int size, boolean requireUtf8) throws InvalidProtocolBufferException {
        if (size == 0) {
            return EMPTY;
        }
        ByteString.checkRange(offset, offset + size, bytes.length);
        if (requireUtf8 && !Utf8.isValidUtf8(bytes, offset, offset + size)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        return new LiteralByteString(byteArrayCopier.copyFrom(bytes, offset, size));
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    static ByteString wrap(ByteBuffer buffer) {
        try {
            return ByteString.wrap(buffer, false);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError("Expected no InvalidProtocolBufferException as data UTF8 validity is not checked.", e);
        }
    }

    static ByteString wrap(ByteBuffer buffer, boolean requireUtf8) throws InvalidProtocolBufferException {
        if (buffer.remaining() == 0) {
            return EMPTY;
        }
        if (requireUtf8 && !Utf8.isValidUtf8(buffer)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset();
            return ByteString.wrap(buffer.array(), offset + buffer.position(), buffer.remaining());
        }
        ByteBuffer slice = buffer.slice();
        byte[] bytes = new byte[slice.remaining()];
        slice.get(bytes);
        return new LiteralByteString(bytes);
    }

    static ByteString wrap(byte[] bytes) {
        try {
            return ByteString.wrap(bytes, false);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError("Expected no InvalidProtocolBufferException as data UTF8 validity is not checked.", e);
        }
    }

    static ByteString wrap(byte[] bytes, boolean requireUtf8) throws InvalidProtocolBufferException {
        if (bytes.length == 0) {
            return EMPTY;
        }
        if (requireUtf8 && !Utf8.isValidUtf8(bytes)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        return new LiteralByteString(bytes);
    }

    static ByteString wrap(byte[] bytes, int offset, int length) {
        try {
            return ByteString.wrap(bytes, offset, length, false);
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError("Expected no InvalidProtocolBufferException as data UTF8 validity is not checked.", e);
        }
    }

    static ByteString wrap(byte[] bytes, int offset, int length, boolean requireUtf8) throws InvalidProtocolBufferException {
        if (requireUtf8 && !Utf8.isValidUtf8(bytes, offset, offset + length)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        return new BoundedByteString(bytes, offset, length);
    }

    public static ByteString copyFrom(ByteBuffer bytes, int size) {
        if (size == 0) {
            return EMPTY;
        }
        ByteString.checkRange(0, size, bytes.remaining());
        byte[] copy = new byte[size];
        bytes.get(copy);
        return new LiteralByteString(copy);
    }

    public static ByteString copyFrom(ByteBuffer bytes) {
        return ByteString.copyFrom(bytes, bytes.remaining());
    }

    @Deprecated
    public static ByteString copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        return text.isEmpty() ? EMPTY : new LiteralByteString(text.getBytes(charsetName));
    }

    public static ByteString copyFrom(String text, Charset charset) {
        return text.isEmpty() ? EMPTY : new LiteralByteString(text.getBytes(charset));
    }

    public static ByteString copyFromUtf8(String text) {
        return text.isEmpty() ? EMPTY : new LiteralByteString(text.getBytes(Internal.UTF_8));
    }

    public static ByteString readFrom(InputStream streamToDrain) throws IOException {
        return ByteString.readFrom(streamToDrain, 256, 8192);
    }

    public static ByteString readFrom(InputStream streamToDrain, int chunkSize) throws IOException {
        return ByteString.readFrom(streamToDrain, chunkSize, chunkSize);
    }

    public static ByteString readFrom(InputStream streamToDrain, int minChunkSize, int maxChunkSize) throws IOException {
        ByteString chunk;
        ArrayList<ByteString> results = new ArrayList<ByteString>();
        int chunkSize = minChunkSize;
        while ((chunk = ByteString.readChunk(streamToDrain, chunkSize)) != null) {
            results.add(chunk);
            chunkSize = Math.min(chunkSize * 2, maxChunkSize);
        }
        return ByteString.copyFrom(results);
    }

    private static ByteString readChunk(InputStream in, int chunkSize) throws IOException {
        int bytesRead;
        int count;
        byte[] buf = new byte[chunkSize];
        for (bytesRead = 0; bytesRead < chunkSize && (count = in.read(buf, bytesRead, chunkSize - bytesRead)) != -1; bytesRead += count) {
        }
        if (bytesRead == 0) {
            return null;
        }
        return ByteString.copyFrom(buf, 0, bytesRead);
    }

    public final ByteString concat(ByteString other) {
        if (Integer.MAX_VALUE - this.size() < other.size()) {
            throw new IllegalArgumentException("ByteString would be too long: " + this.size() + "+" + other.size());
        }
        return RopeByteString.concatenate(this, other);
    }

    public static ByteString copyFrom(Iterable<ByteString> byteStrings) {
        int size;
        if (!(byteStrings instanceof Collection)) {
            int tempSize = 0;
            Iterator<ByteString> iter = byteStrings.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++tempSize;
            }
            size = tempSize;
        } else {
            size = ((Collection)byteStrings).size();
        }
        if (size == 0) {
            return EMPTY;
        }
        return ByteString.balancedConcat(byteStrings.iterator(), size);
    }

    private static ByteString balancedConcat(Iterator<ByteString> iterator, int length) {
        ByteString result;
        if (length < 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "length (%s) must be >= 1", length));
        }
        if (length == 1) {
            result = iterator.next();
        } else {
            int halfLength = length >>> 1;
            ByteString left = ByteString.balancedConcat(iterator, halfLength);
            ByteString right = ByteString.balancedConcat(iterator, length - halfLength);
            result = left.concat(right);
        }
        return result;
    }

    public void copyTo(byte[] target, int offset) {
        this.copyTo(target, 0, offset, this.size());
    }

    @Deprecated
    public final void copyTo(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        ByteString.checkRange(sourceOffset, sourceOffset + numberToCopy, this.size());
        ByteString.checkRange(targetOffset, targetOffset + numberToCopy, target.length);
        if (numberToCopy > 0) {
            this.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    public final byte[] toByteArray() {
        int size = this.size();
        if (size == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        this.copyToInternal(result, 0, 0, size);
        return result;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    final void writeTo(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        ByteString.checkRange(sourceOffset, sourceOffset + numberToWrite, this.size());
        if (numberToWrite > 0) {
            this.writeToInternal(out, sourceOffset, numberToWrite);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3) throws IOException;

    abstract void writeTo(ByteOutput var1) throws IOException;

    abstract void writeToReverse(ByteOutput var1) throws IOException;

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    @Deprecated
    public final String toString(String charsetName) throws UnsupportedEncodingException {
        try {
            return this.toString(Charset.forName(charsetName));
        }
        catch (UnsupportedCharsetException e) {
            UnsupportedEncodingException exception = new UnsupportedEncodingException(charsetName);
            exception.initCause(e);
            throw exception;
        }
    }

    public final String toString(Charset charset) {
        return this.isEmpty() ? "" : this.toStringInternal(charset);
    }

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        return this.toString(Internal.UTF_8);
    }

    public abstract boolean isValidUtf8();

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)o;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        int thisPeekHash = this.peekCachedHashCode();
        int otherPeekHash = other.peekCachedHashCode();
        if (thisPeekHash != 0 && otherPeekHash != 0 && thisPeekHash != otherPeekHash) {
            return false;
        }
        return this.equalsInternal(other);
    }

    protected abstract boolean equalsInternal(ByteString var1);

    public final int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int size = this.size();
            h = this.partialHash(size, 0, size);
            if (h == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput(int initialCapacity) {
        return new Output(initialCapacity);
    }

    public static Output newOutput() {
        return new Output(128);
    }

    static CodedBuilder newCodedBuilder(int size) {
        return new CodedBuilder(size);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    static void checkIndex(int index, int size) {
        if ((index | size - (index + 1)) < 0) {
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException("Index < 0: " + index);
            }
            throw new ArrayIndexOutOfBoundsException("Index > length: " + index + ", " + size);
        }
    }

    @CanIgnoreReturnValue
    static int checkRange(int startIndex, int endIndex, int size) {
        int length = endIndex - startIndex;
        if ((startIndex | endIndex | length | size - endIndex) < 0) {
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + startIndex + " < 0");
            }
            if (endIndex < startIndex) {
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + startIndex + ", " + endIndex);
            }
            throw new IndexOutOfBoundsException("End index: " + endIndex + " >= " + size);
        }
        return length;
    }

    public final String toString() {
        return String.format(Locale.ROOT, "<ByteString@%s size=%d contents=\"%s\">", Integer.toHexString(System.identityHashCode(this)), this.size(), this.truncateAndEscapeForDisplay());
    }

    private String truncateAndEscapeForDisplay() {
        int limit = 50;
        return this.size() <= 50 ? TextFormatEscaper.escapeBytes(this) : TextFormatEscaper.escapeBytes(this.substring(0, 47)) + "...";
    }

    private static boolean subArrayEquals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        ByteString.checkRange(aOffset, aOffset + length, a.length);
        ByteString.checkRange(bOffset, bOffset + length, b.length);
        int aIndex = aOffset;
        int bIndex = bOffset;
        while (aIndex < aOffset + length) {
            if (a[aIndex] != b[bIndex]) {
                return false;
            }
            ++aIndex;
            ++bIndex;
        }
        return true;
    }

    private static final class LiteralByteString
    extends LeafByteString {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        LiteralByteString(byte[] bytes) {
            if (bytes == null) {
                throw new NullPointerException();
            }
            this.bytes = bytes;
        }

        @Override
        public byte byteAt(int index) {
            return this.bytes[index];
        }

        @Override
        byte internalByteAt(int index) {
            return this.bytes[index];
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        @Override
        public ByteString substring(int beginIndex, int endIndex) {
            int length = LiteralByteString.checkRange(beginIndex, endIndex, this.size());
            if (length == 0) {
                return EMPTY;
            }
            return new BoundedByteString(this.bytes, beginIndex, length);
        }

        @Override
        protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            System.arraycopy(this.bytes, sourceOffset, target, targetOffset, numberToCopy);
        }

        @Override
        public void copyTo(ByteBuffer target) {
            target.put(this.bytes);
        }

        @Override
        public ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes).asReadOnlyBuffer();
        }

        @Override
        public List<ByteBuffer> asReadOnlyByteBufferList() {
            return Collections.singletonList(this.asReadOnlyByteBuffer());
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.toByteArray());
        }

        @Override
        void writeTo(ByteOutput output) throws IOException {
            output.writeLazy(this.bytes, 0, this.size());
        }

        @Override
        void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
            outputStream.write(this.bytes, sourceOffset, numberToWrite);
        }

        @Override
        protected String toStringInternal(Charset charset) {
            return new String(this.bytes, charset);
        }

        @Override
        public boolean isValidUtf8() {
            return Utf8.isValidUtf8(this.bytes);
        }

        @Override
        protected final boolean equalsInternal(ByteString other) {
            if (other instanceof LiteralByteString) {
                return Arrays.equals(this.bytes, ((LiteralByteString)other).bytes);
            }
            if (other instanceof BoundedByteString) {
                return this.equalsRange(other, 0, this.size());
            }
            return other.equalsInternal(this);
        }

        @Override
        boolean equalsRange(ByteString other, int offset, int length) {
            if (length > other.size()) {
                throw new IllegalArgumentException("Length too large: " + length + this.size());
            }
            if (offset + length > other.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
            }
            if (other instanceof LiteralByteString) {
                LiteralByteString lbsOther = (LiteralByteString)other;
                return ByteString.subArrayEquals(this.bytes, 0, lbsOther.bytes, offset, length);
            }
            if (other instanceof BoundedByteString) {
                BoundedByteString bbsOther = (BoundedByteString)other;
                return ByteString.subArrayEquals(this.bytes, 0, bbsOther.bytes, bbsOther.offset + offset, length);
            }
            return other.substring(offset, offset + length).equals(this.substring(0, length));
        }

        @Override
        protected int partialHash(int h, int offset, int length) {
            return Internal.partialHash(h, this.bytes, offset, length);
        }

        @Override
        public InputStream newInput() {
            return new ByteArrayInputStream(this.bytes, 0, this.size());
        }

        @Override
        public CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, 0, this.size(), true);
        }
    }

    private static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }

    private static final class BoundedByteString
    extends LeafByteString {
        private final byte[] bytes;
        private final int offset;
        private final int length;
        private static final long serialVersionUID = 1L;

        BoundedByteString(byte[] bytes, int offset, int length) {
            BoundedByteString.checkRange(offset, offset + length, bytes.length);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public byte byteAt(int index) {
            BoundedByteString.checkIndex(index, this.size());
            return this.bytes[this.offset + index];
        }

        @Override
        byte internalByteAt(int index) {
            return this.bytes[this.offset + index];
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public ByteString substring(int beginIndex, int endIndex) {
            int substringLength = BoundedByteString.checkRange(beginIndex, endIndex, this.length);
            if (substringLength == 0) {
                return EMPTY;
            }
            return new BoundedByteString(this.bytes, this.offset + beginIndex, substringLength);
        }

        @Override
        protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            System.arraycopy(this.bytes, this.offset + sourceOffset, target, targetOffset, numberToCopy);
        }

        @Override
        public void copyTo(ByteBuffer target) {
            target.put(this.bytes, this.offset, this.length);
        }

        @Override
        public ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.offset, this.length).asReadOnlyBuffer();
        }

        @Override
        public List<ByteBuffer> asReadOnlyByteBufferList() {
            return Collections.singletonList(this.asReadOnlyByteBuffer());
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.toByteArray());
        }

        @Override
        void writeTo(ByteOutput out) throws IOException {
            out.writeLazy(this.bytes, this.offset, this.length);
        }

        @Override
        void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
            out.write(this.bytes, this.offset + sourceOffset, numberToWrite);
        }

        @Override
        protected String toStringInternal(Charset charset) {
            return new String(this.bytes, this.offset, this.length, charset);
        }

        @Override
        public boolean isValidUtf8() {
            return Utf8.isValidUtf8(this.bytes, this.offset, this.offset + this.length);
        }

        @Override
        protected boolean equalsInternal(ByteString other) {
            if (other instanceof LiteralByteString || other instanceof BoundedByteString) {
                return this.equalsRange(other, 0, this.size());
            }
            return other.equalsInternal(this);
        }

        @Override
        boolean equalsRange(ByteString other, int offset, int length) {
            if (length > other.size()) {
                throw new IllegalArgumentException("Length too large: " + length + this.size());
            }
            if (offset + length > other.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
            }
            if (other instanceof LiteralByteString) {
                LiteralByteString lbsOther = (LiteralByteString)other;
                return ByteString.subArrayEquals(this.bytes, this.offset, lbsOther.bytes, offset, length);
            }
            if (other instanceof BoundedByteString) {
                BoundedByteString lbsOther = (BoundedByteString)other;
                return ByteString.subArrayEquals(this.bytes, this.offset, lbsOther.bytes, lbsOther.offset + offset, length);
            }
            return other.substring(offset, offset + length).equals(this.substring(this.offset, this.offset + length));
        }

        @Override
        protected int partialHash(int h, int offset, int length) {
            return Internal.partialHash(h, this.bytes, this.offset + offset, length);
        }

        @Override
        public InputStream newInput() {
            return new ByteArrayInputStream(this.bytes, this.offset, this.length);
        }

        @Override
        public CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, this.offset, this.length, true);
        }

        Object writeReplace() {
            return ByteString.wrap(this.toByteArray());
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
        }
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        Output(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = initialCapacity;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[initialCapacity];
        }

        @Override
        public synchronized void write(int b) {
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)b;
        }

        @Override
        public synchronized void write(byte[] b, int offset, int length) {
            if (length <= this.buffer.length - this.bufferPos) {
                System.arraycopy(b, offset, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
            } else {
                int copySize = this.buffer.length - this.bufferPos;
                System.arraycopy(b, offset, this.buffer, this.bufferPos, copySize);
                this.flushFullBuffer(length -= copySize);
                System.arraycopy(b, offset += copySize, this.buffer, 0, length);
                this.bufferPos = length;
            }
        }

        public synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream out) throws IOException {
            ByteString[] byteStringArray = this;
            synchronized (this) {
                ByteString[] cachedFlushBuffers = this.flushedBuffers.toArray(new ByteString[0]);
                byte[] cachedBuffer = this.buffer;
                int cachedBufferPos = this.bufferPos;
                // ** MonitorExit[var5_2] (shouldn't be in output)
                for (ByteString byteString : cachedFlushBuffers) {
                    byteString.writeTo(out);
                }
                out.write(Arrays.copyOf(cachedBuffer, cachedBufferPos));
                return;
            }
        }

        public synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public synchronized void reset() {
            this.flushedBuffers.clear();
            this.flushedBuffersTotalBytes = 0;
            this.bufferPos = 0;
        }

        public String toString() {
            return String.format(Locale.ROOT, "<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        private void flushFullBuffer(int minSize) {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int newSize = Math.max(this.initialCapacity, Math.max(minSize, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[newSize];
            this.bufferPos = 0;
        }

        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    byte[] bufferCopy = Arrays.copyOf(this.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString(bufferCopy));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int size) {
            this.buffer = new byte[size];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            return new LiteralByteString(this.buffer);
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }

    private static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        @Override
        public byte[] copyFrom(byte[] bytes, int offset, int size) {
            byte[] copy = new byte[size];
            System.arraycopy(bytes, offset, copy, 0, size);
            return copy;
        }
    }

    private static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        @Override
        public byte[] copyFrom(byte[] bytes, int offset, int size) {
            return Arrays.copyOfRange(bytes, offset, offset + size);
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        private static final long serialVersionUID = 1L;

        @Override
        protected final int getTreeDepth() {
            return 0;
        }

        @Override
        protected final boolean isBalanced() {
            return true;
        }

        @Override
        void writeToReverse(ByteOutput byteOutput) throws IOException {
            this.writeTo(byteOutput);
        }

        abstract boolean equalsRange(ByteString var1, int var2, int var3);

        private LeafByteString() {
        }
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        AbstractByteIterator() {
        }

        @Override
        public final Byte next() {
            return this.nextByte();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

