/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
public final class GcFinalization {
    private GcFinalization() {
    }

    private static long timeoutSeconds() {
        return Math.max(10L, Runtime.getRuntime().totalMemory() / 0x2000000L);
    }

    public static void awaitDone(Future<?> future) {
        if (future.isDone()) {
            return;
        }
        long timeoutSeconds = GcFinalization.timeoutSeconds();
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(timeoutSeconds);
        while (true) {
            System.runFinalization();
            if (future.isDone()) {
                return;
            }
            System.gc();
            try {
                future.get(1L, TimeUnit.SECONDS);
                return;
            }
            catch (CancellationException ok) {
                return;
            }
            catch (ExecutionException ok) {
                return;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Unexpected interrupt while waiting for future", ie);
            }
            catch (TimeoutException tryHarder) {
                if (System.nanoTime() - deadline < 0L) continue;
                throw GcFinalization.formatRuntimeException("Future not done within %d second timeout", timeoutSeconds);
            }
            break;
        }
    }

    public static void await(CountDownLatch latch) {
        if (latch.getCount() == 0L) {
            return;
        }
        long timeoutSeconds = GcFinalization.timeoutSeconds();
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(timeoutSeconds);
        do {
            System.runFinalization();
            if (latch.getCount() == 0L) {
                return;
            }
            System.gc();
            try {
                if (latch.await(1L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Unexpected interrupt while waiting for latch", ie);
            }
        } while (System.nanoTime() - deadline < 0L);
        throw GcFinalization.formatRuntimeException("Latch failed to count down within %d second timeout", timeoutSeconds);
    }

    private static void createUnreachableLatchFinalizer(final CountDownLatch latch) {
        new Object(){

            protected void finalize() {
                latch.countDown();
            }
        };
    }

    public static void awaitDone(FinalizationPredicate predicate) {
        if (predicate.isDone()) {
            return;
        }
        long timeoutSeconds = GcFinalization.timeoutSeconds();
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(timeoutSeconds);
        do {
            System.runFinalization();
            if (predicate.isDone()) {
                return;
            }
            CountDownLatch done = new CountDownLatch(1);
            GcFinalization.createUnreachableLatchFinalizer(done);
            GcFinalization.await(done);
            if (!predicate.isDone()) continue;
            return;
        } while (System.nanoTime() - deadline < 0L);
        throw GcFinalization.formatRuntimeException("Predicate did not become true within %d second timeout", timeoutSeconds);
    }

    public static void awaitClear(final WeakReference<?> ref) {
        GcFinalization.awaitDone(new FinalizationPredicate(){

            @Override
            public boolean isDone() {
                return ref.get() == null;
            }
        });
    }

    public static void awaitFullGc() {
        final CountDownLatch finalizerRan = new CountDownLatch(1);
        WeakReference<3> ref = new WeakReference<3>(new Object(){

            protected void finalize() {
                finalizerRan.countDown();
            }
        });
        GcFinalization.await(finalizerRan);
        GcFinalization.awaitClear(ref);
        System.runFinalization();
    }

    private static RuntimeException formatRuntimeException(String format, Object ... args) {
        return new RuntimeException(String.format(Locale.ROOT, format, args));
    }

    public static interface FinalizationPredicate {
        public boolean isDone();
    }
}

