package com.atlassian.bridge;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * Simple Wrapper class to write class file bytecode to disk.
 */
public class CacheBuilderWriter implements Opcodes {

    private static final String packageName = "com/google/common/cache";
    private static final String className = "CacheBuilder.class";

    public static void main(String[] args) {
        if (args.length != 1)
        {
            System.out.print(""+args.length);
            throw new IllegalArgumentException("Must provide target path");
        }
        final String outDir = args[0];
        File path = new File(outDir, packageName);
        path.mkdirs();
        File targetClass = new File(path, className);
        DataOutputStream dout = null;
        try {
            dout=new DataOutputStream(new FileOutputStream(targetClass));
            dout.write(dump());
            dout.flush();
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            if (dout != null) {
                try {
                    dout.close();
                } catch (IOException ignore) {
                }
            }
        }
    }

    public static byte[] dump() throws Exception {

        ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_FRAMES + ClassWriter.COMPUTE_MAXS);
        FieldVisitor fv;
        MethodVisitor mv;
        AnnotationVisitor av0;

        cw.visit(V1_5, ACC_PUBLIC + ACC_FINAL + ACC_SUPER, "com/google/common/cache/CacheBuilder", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/lang/Object;", "java/lang/Object", null);

        {
            av0 = cw.visitAnnotation("Lcom/google/common/annotations/Beta;", false);
            av0.visitEnd();
        }
        {
            av0 = cw.visitAnnotation("Lcom/google/common/annotations/GwtCompatible;", false);
            av0.visit("emulated", Boolean.TRUE);
            av0.visitEnd();
        }
        cw.visitInnerClass("com/google/common/cache/CacheBuilder$OneWeigher", "com/google/common/cache/CacheBuilder", "OneWeigher", ACC_FINAL + ACC_STATIC + ACC_ENUM);

        cw.visitInnerClass("com/google/common/cache/CacheBuilder$NullListener", "com/google/common/cache/CacheBuilder", "NullListener", ACC_FINAL + ACC_STATIC + ACC_ENUM);

        cw.visitInnerClass("com/google/common/cache/CacheBuilder$3", null, null, ACC_STATIC);

        cw.visitInnerClass("com/google/common/cache/CacheBuilder$2", null, null, ACC_STATIC);

        cw.visitInnerClass("com/google/common/cache/CacheBuilder$1", null, null, ACC_STATIC);

        cw.visitInnerClass("com/google/common/cache/AbstractCache$StatsCounter", "com/google/common/cache/AbstractCache", "StatsCounter", ACC_PUBLIC + ACC_STATIC + ACC_ABSTRACT + ACC_INTERFACE);

        cw.visitInnerClass("com/google/common/cache/AbstractCache$SimpleStatsCounter", "com/google/common/cache/AbstractCache", "SimpleStatsCounter", ACC_PUBLIC + ACC_STATIC);

        cw.visitInnerClass("com/google/common/cache/LocalCache$Strength", "com/google/common/cache/LocalCache", "Strength", ACC_STATIC + ACC_ENUM + ACC_ABSTRACT);

        cw.visitInnerClass("com/google/common/base/Objects$ToStringHelper", "com/google/common/base/Objects", "ToStringHelper", ACC_PUBLIC + ACC_FINAL + ACC_STATIC);

        cw.visitInnerClass("com/google/common/cache/LocalCache$LocalLoadingCache", "com/google/common/cache/LocalCache", "LocalLoadingCache", ACC_STATIC);

        cw.visitInnerClass("com/google/common/cache/LocalCache$LocalManualCache", "com/google/common/cache/LocalCache", "LocalManualCache", ACC_STATIC);

        {
            fv = cw.visitField(ACC_PRIVATE + ACC_FINAL + ACC_STATIC, "DEFAULT_INITIAL_CAPACITY", "I", null, new Integer(16));
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_PRIVATE + ACC_FINAL + ACC_STATIC, "DEFAULT_CONCURRENCY_LEVEL", "I", null, new Integer(4));
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_PRIVATE + ACC_FINAL + ACC_STATIC, "DEFAULT_EXPIRATION_NANOS", "I", null, new Integer(0));
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_PRIVATE + ACC_FINAL + ACC_STATIC, "DEFAULT_REFRESH_NANOS", "I", null, new Integer(0));
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_FINAL + ACC_STATIC, "NULL_STATS_COUNTER", "Lcom/google/common/base/Supplier;", "Lcom/google/common/base/Supplier<+Lcom/google/common/cache/AbstractCache$StatsCounter;>;", null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_FINAL + ACC_STATIC, "EMPTY_STATS", "Lcom/google/common/cache/CacheStats;", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_FINAL + ACC_STATIC, "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;", "Lcom/google/common/base/Supplier<Lcom/google/common/cache/AbstractCache$SimpleStatsCounter;>;", null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_FINAL + ACC_STATIC, "NULL_TICKER", "Lcom/google/common/base/Ticker;", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_PRIVATE + ACC_FINAL + ACC_STATIC, "logger", "Ljava/util/logging/Logger;", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(ACC_FINAL + ACC_STATIC, "UNSET_INT", "I", null, new Integer(-1));
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "strictParsing", "Z", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "initialCapacity", "I", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "concurrencyLevel", "I", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "maximumSize", "J", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "maximumWeight", "J", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "weigher", "Lcom/google/common/cache/Weigher;", "Lcom/google/common/cache/Weigher<-TK;-TV;>;", null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "expireAfterWriteNanos", "J", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "expireAfterAccessNanos", "J", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "refreshNanos", "J", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "keyEquivalence", "Lcom/google/common/base/Equivalence;", "Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "valueEquivalence", "Lcom/google/common/base/Equivalence;", "Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "removalListener", "Lcom/google/common/cache/RemovalListener;", "Lcom/google/common/cache/RemovalListener<-TK;-TV;>;", null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "ticker", "Lcom/google/common/base/Ticker;", null, null);
            fv.visitEnd();
        }
        {
            fv = cw.visitField(0, "statsCounterSupplier", "Lcom/google/common/base/Supplier;", "Lcom/google/common/base/Supplier<+Lcom/google/common/cache/AbstractCache$StatsCounter;>;", null);
            fv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESPECIAL, "java/lang/Object", "<init>", "()V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ICONST_1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ICONST_M1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ICONST_M1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitLdcInsn(new Long(-1L));
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitLdcInsn(new Long(-1L));
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitLdcInsn(new Long(-1L));
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitLdcInsn(new Long(-1L));
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitLdcInsn(new Long(-1L));
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder", "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
            mv.visitInsn(RETURN);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC + ACC_STATIC, "newBuilder", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<Ljava/lang/Object;Ljava/lang/Object;>;", null);
            mv.visitCode();
            mv.visitTypeInsn(NEW, "com/google/common/cache/CacheBuilder");
            mv.visitInsn(DUP);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder", "<init>", "()V");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 0);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "lenientParsing", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ICONST_0);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "keyEquivalence", "(Lcom/google/common/base/Equivalence;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("key equivalence was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/base/Equivalence");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(6, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getKeyEquivalence", "()Lcom/google/common/base/Equivalence;", "()Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "getKeyStrength", "()Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/LocalCache$Strength", "defaultEquivalence", "()Lcom/google/common/base/Equivalence;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/base/Equivalence");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "valueEquivalence", "(Lcom/google/common/base/Equivalence;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("value equivalence was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/base/Equivalence");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(6, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getValueEquivalence", "()Lcom/google/common/base/Equivalence;", "()Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "getValueStrength", "()Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/LocalCache$Strength", "defaultEquivalence", "()Lcom/google/common/base/Equivalence;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/base/Equivalence");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "initialCapacity", "(I)Lcom/google/common/cache/CacheBuilder;", "(I)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitInsn(ICONST_M1);
            Label l0 = new Label();
            mv.visitJumpInsn(IF_ICMPNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("initial capacity was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ILOAD, 1);
            Label l2 = new Label();
            mv.visitJumpInsn(IFLT, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(Z)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ILOAD, 1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(6, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getInitialCapacity", "()I", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitInsn(ICONST_M1);
            Label l0 = new Label();
            mv.visitJumpInsn(IF_ICMPNE, l0);
            mv.visitIntInsn(BIPUSH, 16);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitLabel(l1);
            mv.visitInsn(IRETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "concurrencyLevel", "(I)Lcom/google/common/cache/CacheBuilder;", "(I)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitInsn(ICONST_M1);
            Label l0 = new Label();
            mv.visitJumpInsn(IF_ICMPNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("concurrency level was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ILOAD, 1);
            Label l2 = new Label();
            mv.visitJumpInsn(IFLE, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(Z)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ILOAD, 1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(6, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getConcurrencyLevel", "()I", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitInsn(ICONST_M1);
            Label l0 = new Label();
            mv.visitJumpInsn(IF_ICMPNE, l0);
            mv.visitInsn(ICONST_4);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitLabel(l1);
            mv.visitInsn(IRETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "maximumSize", "(J)Lcom/google/common/cache/CacheBuilder;", "(J)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("maximum size was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l2 = new Label();
            mv.visitJumpInsn(IFNE, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitLdcInsn("maximum weight was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            Label l4 = new Label();
            mv.visitJumpInsn(IFNONNULL, l4);
            mv.visitInsn(ICONST_1);
            Label l5 = new Label();
            mv.visitJumpInsn(GOTO, l5);
            mv.visitLabel(l4);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l5);
            mv.visitLdcInsn("maximum size can not be combined with weigher");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
            mv.visitVarInsn(LLOAD, 1);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l6 = new Label();
            mv.visitJumpInsn(IFLT, l6);
            mv.visitInsn(ICONST_1);
            Label l7 = new Label();
            mv.visitJumpInsn(GOTO, l7);
            mv.visitLabel(l6);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l7);
            mv.visitLdcInsn("maximum size must not be negative");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(7, 3);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC + ACC_DEPRECATED, "maximumSize", "(I)Lcom/google/common/cache/CacheBuilder;", "(I)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ILOAD, 1);
            mv.visitInsn(I2L);
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "maximumSize", "(J)Lcom/google/common/cache/CacheBuilder;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "maximumWeight", "(J)Lcom/google/common/cache/CacheBuilder;", "(J)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("maximum weight was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l2 = new Label();
            mv.visitJumpInsn(IFNE, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitLdcInsn("maximum size was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitVarInsn(LLOAD, 1);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l4 = new Label();
            mv.visitJumpInsn(IFLT, l4);
            mv.visitInsn(ICONST_1);
            Label l5 = new Label();
            mv.visitJumpInsn(GOTO, l5);
            mv.visitLabel(l4);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l5);
            mv.visitLdcInsn("maximum weight must not be negative");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(7, 3);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "weigher", "(Lcom/google/common/cache/Weigher;)Lcom/google/common/cache/CacheBuilder;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/Weigher<-TK1;-TV1;>;)Lcom/google/common/cache/CacheBuilder<TK1;TV1;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(Z)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
            Label l2 = new Label();
            mv.visitJumpInsn(IFEQ, l2);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l3 = new Label();
            mv.visitJumpInsn(IFNE, l3);
            mv.visitInsn(ICONST_1);
            Label l4 = new Label();
            mv.visitJumpInsn(GOTO, l4);
            mv.visitLabel(l3);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l4);
            mv.visitLdcInsn("weigher can not be combined with maximum size");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitLabel(l2);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ASTORE, 2);
            mv.visitVarInsn(ALOAD, 2);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/Weigher");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            mv.visitVarInsn(ALOAD, 2);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(7, 3);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getMaximumWeight", "()J", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFEQ, l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l1 = new Label();
            mv.visitJumpInsn(IFNE, l1);
            mv.visitLabel(l0);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LRETURN);
            mv.visitLabel(l1);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            Label l2 = new Label();
            mv.visitJumpInsn(IFNONNULL, l2);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLabel(l3);
            mv.visitInsn(LRETURN);
            mv.visitMaxs(4, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getWeigher", "()Lcom/google/common/cache/Weigher;", "<K1:TK;V1:TV;>()Lcom/google/common/cache/Weigher<TK1;TV1;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder$OneWeigher", "INSTANCE", "Lcom/google/common/cache/CacheBuilder$OneWeigher;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/Weigher");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "strongKeys", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "setKeyStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "weakKeys", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            {
                av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
                av0.visit("value", "java.lang.ref.WeakReference");
                av0.visitEnd();
            }
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "WEAK", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "setKeyStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "setKeyStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("Key strength was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/LocalCache$Strength");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(6, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getKeyStrength", "()Lcom/google/common/cache/LocalCache$Strength;", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/LocalCache$Strength");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "strongValues", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "weakValues", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            {
                av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
                av0.visit("value", "java.lang.ref.WeakReference");
                av0.visitEnd();
            }
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "WEAK", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "softValues", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            {
                av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
                av0.visit("value", "java.lang.ref.SoftReference");
                av0.visitEnd();
            }
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "SOFT", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/CacheBuilder", "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("Value strength was already set to %s");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/LocalCache$Strength");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(6, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getValueStrength", "()Lcom/google/common/cache/LocalCache$Strength;", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/LocalCache$Strength");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "expireAfterWrite", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder;", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("expireAfterWrite was already set to %s ns");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(LLOAD, 1);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l2 = new Label();
            mv.visitJumpInsn(IFLT, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitLdcInsn("duration cannot be negative: %s %s");
            mv.visitInsn(ICONST_2);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_1);
            mv.visitVarInsn(ALOAD, 3);
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 3);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/util/concurrent/TimeUnit", "toNanos", "(J)J");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(7, 4);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getExpireAfterWriteNanos", "()J", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(LCONST_0);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitLabel(l1);
            mv.visitInsn(LRETURN);
            mv.visitMaxs(4, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "expireAfterAccess", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder;", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("expireAfterAccess was already set to %s ns");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(LLOAD, 1);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l2 = new Label();
            mv.visitJumpInsn(IFLT, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitLdcInsn("duration cannot be negative: %s %s");
            mv.visitInsn(ICONST_2);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_1);
            mv.visitVarInsn(ALOAD, 3);
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 3);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/util/concurrent/TimeUnit", "toNanos", "(J)J");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(7, 4);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getExpireAfterAccessNanos", "()J", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(LCONST_0);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitLabel(l1);
            mv.visitInsn(LRETURN);
            mv.visitMaxs(4, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "refreshAfterWrite", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder;", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            {
                av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
                av0.visit("value", "To be supported");
                av0.visitEnd();
            }
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 3);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(POP);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("refresh was already set to %s ns");
            mv.visitInsn(ICONST_1);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(LLOAD, 1);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCMP);
            Label l2 = new Label();
            mv.visitJumpInsn(IFLE, l2);
            mv.visitInsn(ICONST_1);
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l2);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l3);
            mv.visitLdcInsn("duration must be positive: %s %s");
            mv.visitInsn(ICONST_2);
            mv.visitTypeInsn(ANEWARRAY, "java/lang/Object");
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_0);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mv.visitInsn(AASTORE);
            mv.visitInsn(DUP);
            mv.visitInsn(ICONST_1);
            mv.visitVarInsn(ALOAD, 3);
            mv.visitInsn(AASTORE);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 3);
            mv.visitVarInsn(LLOAD, 1);
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/util/concurrent/TimeUnit", "toNanos", "(J)J");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(7, 4);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getRefreshNanos", "()J", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(LCONST_0);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitLabel(l1);
            mv.visitInsn(LRETURN);
            mv.visitMaxs(4, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "ticker", "(Lcom/google/common/base/Ticker;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/base/Ticker;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            {
                av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
                av0.visit("value", "To be supported");
                av0.visitEnd();
            }
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(Z)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/base/Ticker");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getTicker", "(Z)Lcom/google/common/base/Ticker;", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNULL, l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
            mv.visitInsn(ARETURN);
            mv.visitLabel(l0);
            mv.visitVarInsn(ILOAD, 1);
            Label l1 = new Label();
            mv.visitJumpInsn(IFEQ, l1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Ticker", "systemTicker", "()Lcom/google/common/base/Ticker;");
            Label l2 = new Label();
            mv.visitJumpInsn(GOTO, l2);
            mv.visitLabel(l1);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder", "NULL_TICKER", "Lcom/google/common/base/Ticker;");
            mv.visitLabel(l2);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "removalListener", "(Lcom/google/common/cache/RemovalListener;)Lcom/google/common/cache/CacheBuilder;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/RemovalListener<-TK1;-TV1;>;)Lcom/google/common/cache/CacheBuilder<TK1;TV1;>;", null);
            {
                av0 = mv.visitAnnotation("Ljavax/annotation/CheckReturnValue;", true);
                av0.visitEnd();
            }
            {
                av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
                av0.visit("value", "To be supported");
                av0.visitEnd();
            }
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(Z)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ASTORE, 2);
            mv.visitVarInsn(ALOAD, 2);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/RemovalListener");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
            mv.visitVarInsn(ALOAD, 2);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getRemovalListener", "()Lcom/google/common/cache/RemovalListener;", "<K1:TK;V1:TV;>()Lcom/google/common/cache/RemovalListener<TK1;TV1;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder$NullListener", "INSTANCE", "Lcom/google/common/cache/CacheBuilder$NullListener;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitTypeInsn(CHECKCAST, "com/google/common/cache/RemovalListener");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "disableStats", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder", "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
            Label l0 = new Label();
            mv.visitJumpInsn(IF_ACMPNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(Z)V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder", "NULL_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
            mv.visitFieldInsn(PUTFIELD, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitInsn(ARETURN);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(0, "getStatsCounterSupplier", "()Lcom/google/common/base/Supplier;", "()Lcom/google/common/base/Supplier<+Lcom/google/common/cache/AbstractCache$StatsCounter;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "build", "(Lcom/google/common/cache/CacheLoader;)Lcom/google/common/cache/LoadingCache;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/CacheLoader<-TK1;TV1;>;)Lcom/google/common/cache/LoadingCache<TK1;TV1;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder", "checkWeightWithWeigher", "()V");
            mv.visitTypeInsn(NEW, "com/google/common/cache/LocalCache$LocalLoadingCache");
            mv.visitInsn(DUP);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/LocalCache$LocalLoadingCache", "<init>", "(Lcom/google/common/cache/CacheBuilder;Lcom/google/common/cache/CacheLoader;)V");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(4, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC + ACC_DEPRECATED, "build", "(Lcom/google/common/cache/CacheLoader;)Lcom/google/common/cache/Cache;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/CacheLoader<-TK1;TV1;>;)Lcom/google/common/cache/Cache<TK1;TV1;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder", "checkWeightWithWeigher", "()V");
            mv.visitTypeInsn(NEW, "com/google/common/cache/LocalCache$LocalLoadingCache");
            mv.visitInsn(DUP);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/LocalCache$LocalLoadingCache", "<init>", "(Lcom/google/common/cache/CacheBuilder;Lcom/google/common/cache/CacheLoader;)V");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(4, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "build", "()Lcom/google/common/cache/Cache;", "<K1:TK;V1:TV;>()Lcom/google/common/cache/Cache<TK1;TV1;>;", null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder", "checkWeightWithWeigher", "()V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder", "checkNonLoadingCache", "()V");
            mv.visitTypeInsn(NEW, "com/google/common/cache/LocalCache$LocalManualCache");
            mv.visitInsn(DUP);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/LocalCache$LocalManualCache", "<init>", "(Lcom/google/common/cache/CacheBuilder;)V");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(3, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PRIVATE, "checkNonLoadingCache", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l0 = new Label();
            mv.visitJumpInsn(IFNE, l0);
            mv.visitInsn(ICONST_1);
            Label l1 = new Label();
            mv.visitJumpInsn(GOTO, l1);
            mv.visitLabel(l0);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l1);
            mv.visitLdcInsn("refreshAfterWrite requires a LoadingCache");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
            mv.visitInsn(RETURN);
            mv.visitMaxs(4, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PRIVATE, "checkWeightWithWeigher", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            Label l0 = new Label();
            mv.visitJumpInsn(IFNONNULL, l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l1 = new Label();
            mv.visitJumpInsn(IFNE, l1);
            mv.visitInsn(ICONST_1);
            Label l2 = new Label();
            mv.visitJumpInsn(GOTO, l2);
            mv.visitLabel(l1);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l2);
            mv.visitLdcInsn("maximumWeight requires weigher");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
            Label l3 = new Label();
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
            Label l4 = new Label();
            mv.visitJumpInsn(IFEQ, l4);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l5 = new Label();
            mv.visitJumpInsn(IFEQ, l5);
            mv.visitInsn(ICONST_1);
            Label l6 = new Label();
            mv.visitJumpInsn(GOTO, l6);
            mv.visitLabel(l5);
            mv.visitInsn(ICONST_0);
            mv.visitLabel(l6);
            mv.visitLdcInsn("weigher requires maximumWeight");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
            mv.visitJumpInsn(GOTO, l3);
            mv.visitLabel(l4);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            mv.visitJumpInsn(IFNE, l3);
            mv.visitFieldInsn(GETSTATIC, "com/google/common/cache/CacheBuilder", "logger", "Ljava/util/logging/Logger;");
            mv.visitFieldInsn(GETSTATIC, "java/util/logging/Level", "WARNING", "Ljava/util/logging/Level;");
            mv.visitLdcInsn("ignoring weigher specified without maximumWeight");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/util/logging/Logger", "log", "(Ljava/util/logging/Level;Ljava/lang/String;)V");
            mv.visitLabel(l3);
            mv.visitInsn(RETURN);
            mv.visitMaxs(4, 1);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_PUBLIC, "toString", "()Ljava/lang/String;", null, null);
            mv.visitCode();
            mv.visitVarInsn(ALOAD, 0);
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Objects", "toStringHelper", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitVarInsn(ASTORE, 1);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitInsn(ICONST_M1);
            Label l0 = new Label();
            mv.visitJumpInsn(IF_ICMPEQ, l0);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("initialCapacity");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;I)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l0);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitInsn(ICONST_M1);
            Label l1 = new Label();
            mv.visitJumpInsn(IF_ICMPEQ, l1);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("concurrencyLevel");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;I)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l1);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l2 = new Label();
            mv.visitJumpInsn(IFEQ, l2);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
            Label l3 = new Label();
            mv.visitJumpInsn(IFNONNULL, l3);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("maximumSize");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;J)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitJumpInsn(GOTO, l2);
            mv.visitLabel(l3);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("maximumWeight");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;J)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l2);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l4 = new Label();
            mv.visitJumpInsn(IFEQ, l4);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("expireAfterWrite");
            mv.visitTypeInsn(NEW, "java/lang/StringBuilder");
            mv.visitInsn(DUP);
            mv.visitMethodInsn(INVOKESPECIAL, "java/lang/StringBuilder", "<init>", "()V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "append", "(J)Ljava/lang/StringBuilder;");
            mv.visitLdcInsn("ns");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l4);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitLdcInsn(new Long(-1L));
            mv.visitInsn(LCMP);
            Label l5 = new Label();
            mv.visitJumpInsn(IFEQ, l5);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("expireAfterAccess");
            mv.visitTypeInsn(NEW, "java/lang/StringBuilder");
            mv.visitInsn(DUP);
            mv.visitMethodInsn(INVOKESPECIAL, "java/lang/StringBuilder", "<init>", "()V");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "append", "(J)Ljava/lang/StringBuilder;");
            mv.visitLdcInsn("ns");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l5);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            Label l6 = new Label();
            mv.visitJumpInsn(IFNULL, l6);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("keyStrength");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/LocalCache$Strength", "toString", "()Ljava/lang/String;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Ascii", "toLowerCase", "(Ljava/lang/String;)Ljava/lang/String;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l6);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            Label l7 = new Label();
            mv.visitJumpInsn(IFNULL, l7);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("valueStrength");
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/cache/LocalCache$Strength", "toString", "()Ljava/lang/String;");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Ascii", "toLowerCase", "(Ljava/lang/String;)Ljava/lang/String;");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l7);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
            Label l8 = new Label();
            mv.visitJumpInsn(IFNULL, l8);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("keyEquivalence");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "addValue", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l8);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
            Label l9 = new Label();
            mv.visitJumpInsn(IFNULL, l9);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("valueEquivalence");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "addValue", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l9);
            mv.visitVarInsn(ALOAD, 0);
            mv.visitFieldInsn(GETFIELD, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
            Label l10 = new Label();
            mv.visitJumpInsn(IFNULL, l10);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitLdcInsn("removalListener");
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "addValue", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
            mv.visitInsn(POP);
            mv.visitLabel(l10);
            mv.visitVarInsn(ALOAD, 1);
            mv.visitMethodInsn(INVOKEVIRTUAL, "com/google/common/base/Objects$ToStringHelper", "toString", "()Ljava/lang/String;");
            mv.visitInsn(ARETURN);
            mv.visitMaxs(5, 2);
            mv.visitEnd();
        }
        {
            mv = cw.visitMethod(ACC_STATIC, "<clinit>", "()V", null, null);
            mv.visitCode();
            mv.visitTypeInsn(NEW, "com/google/common/cache/CacheBuilder$1");
            mv.visitInsn(DUP);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder$1", "<init>", "()V");
            mv.visitMethodInsn(INVOKESTATIC, "com/google/common/base/Suppliers", "ofInstance", "(Ljava/lang/Object;)Lcom/google/common/base/Supplier;");
            mv.visitFieldInsn(PUTSTATIC, "com/google/common/cache/CacheBuilder", "NULL_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
            mv.visitTypeInsn(NEW, "com/google/common/cache/CacheStats");
            mv.visitInsn(DUP);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCONST_0);
            mv.visitInsn(LCONST_0);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheStats", "<init>", "(JJJJJJ)V");
            mv.visitFieldInsn(PUTSTATIC, "com/google/common/cache/CacheBuilder", "EMPTY_STATS", "Lcom/google/common/cache/CacheStats;");
            mv.visitTypeInsn(NEW, "com/google/common/cache/CacheBuilder$2");
            mv.visitInsn(DUP);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder$2", "<init>", "()V");
            mv.visitFieldInsn(PUTSTATIC, "com/google/common/cache/CacheBuilder", "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
            mv.visitTypeInsn(NEW, "com/google/common/cache/CacheBuilder$3");
            mv.visitInsn(DUP);
            mv.visitMethodInsn(INVOKESPECIAL, "com/google/common/cache/CacheBuilder$3", "<init>", "()V");
            mv.visitFieldInsn(PUTSTATIC, "com/google/common/cache/CacheBuilder", "NULL_TICKER", "Lcom/google/common/base/Ticker;");
            mv.visitLdcInsn(Type.getType("Lcom/google/common/cache/CacheBuilder;"));
            mv.visitMethodInsn(INVOKEVIRTUAL, "java/lang/Class", "getName", "()Ljava/lang/String;");
            mv.visitMethodInsn(INVOKESTATIC, "java/util/logging/Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;");
            mv.visitFieldInsn(PUTSTATIC, "com/google/common/cache/CacheBuilder", "logger", "Ljava/util/logging/Logger;");
            mv.visitInsn(RETURN);
            mv.visitMaxs(14, 0);
            mv.visitEnd();
        }
        cw.visitEnd();

        return cw.toByteArray();
    }
}
