/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.c;

import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.b.zzx;
import com.google.firebase.firestore.c.zza;
import com.google.firebase.firestore.c.zze;
import com.google.firebase.firestore.c.zzy;
import com.google.firebase.firestore.d.a.zzd;
import com.google.firebase.firestore.d.zzl;
import com.google.firebase.firestore.f.zzw;
import com.google.firebase.firestore.g.zzs;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class zzu
implements zzy {
    private final List<com.google.firebase.firestore.d.a.zze> zza = new ArrayList<com.google.firebase.firestore.d.a.zze>();
    private ImmutableSortedSet<zza> zzb = new ImmutableSortedSet(Collections.emptyList(), com.google.firebase.firestore.c.zza.zza);
    private int zzc = 1;
    private int zzd = -1;
    private ByteString zze = zzw.zzc;
    @Nullable
    private zze zzf;

    zzu() {
    }

    @Override
    public final void zza() {
        zzu zzu2 = this;
        if (zzu2.zza.isEmpty()) {
            this.zzc = 1;
            this.zzd = -1;
        }
        com.google.a.a.a.a.zza.zza(this.zzd < this.zzc, "highestAcknowledgedBatchId must be less than the nextBatchId", new Object[0]);
    }

    @Override
    public final int zzb() {
        return this.zzd;
    }

    @Override
    public final void zza(com.google.firebase.firestore.d.a.zze zze2, ByteString byteString) {
        int n = zze2.zzb();
        com.google.a.a.a.a.zza.zza(n > this.zzd, "Mutation batchIds must be acknowledged in order", new Object[0]);
        int n2 = this.zza(n, "acknowledged");
        com.google.firebase.firestore.d.a.zze zze3 = this.zza.get(n2);
        com.google.a.a.a.a.zza.zza(n == zze3.zzb(), "Queue ordering failure: expected batch %d, got batch %d", n, zze3.zzb());
        com.google.a.a.a.a.zza.zza(!zze3.zzd(), "Can't acknowledge a previously removed batch", new Object[0]);
        this.zzd = n;
        this.zze = (ByteString)Preconditions.checkNotNull((Object)byteString);
    }

    @Override
    public final ByteString zzc() {
        return this.zze;
    }

    @Override
    public final void zza(ByteString byteString) {
        this.zze = (ByteString)Preconditions.checkNotNull((Object)byteString);
    }

    @Override
    public final com.google.firebase.firestore.d.a.zze zza(Timestamp object, List<zzd> object2) {
        com.google.a.a.a.a.zza.zza(!object2.isEmpty(), "Mutation batches should not be empty", new Object[0]);
        int n = this.zzc++;
        int n2 = this.zza.size();
        if (n2 > 0) {
            com.google.firebase.firestore.d.a.zze zze2 = this.zza.get(n2 - 1);
            com.google.a.a.a.a.zza.zza(zze2.zzb() < n, "Mutation batchIds must be monotonically increasing order", new Object[0]);
        }
        com.google.firebase.firestore.d.a.zze zze3 = new com.google.firebase.firestore.d.a.zze(n, (Timestamp)object, (List<zzd>)object2);
        this.zza.add(zze3);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (zzd)object.next();
            this.zzb = this.zzb.insert((Object)new zza(((zzd)object2).zza(), n));
        }
        return zze3;
    }

    @Override
    @Nullable
    public final com.google.firebase.firestore.d.a.zze zza(int n) {
        int n2 = this.zze(n);
        if (n2 < 0 || n2 >= this.zza.size()) {
            return null;
        }
        com.google.firebase.firestore.d.a.zze zze2 = this.zza.get(n2);
        com.google.a.a.a.a.zza.zza(zze2.zzb() == n, "If found batch must match", new Object[0]);
        if (zze2.zzd()) {
            return null;
        }
        return zze2;
    }

    @Override
    @Nullable
    public final com.google.firebase.firestore.d.a.zze zzb(int n) {
        int n2 = this.zza.size();
        n = Math.max(n, this.zzd) + 1;
        int n3 = n = (n = this.zze(n)) < 0 ? 0 : n;
        while (n < n2) {
            com.google.firebase.firestore.d.a.zze zze2 = this.zza.get(n);
            if (!zze2.zzd()) {
                return zze2;
            }
            ++n;
        }
        return null;
    }

    @Override
    public final List<com.google.firebase.firestore.d.a.zze> zzd() {
        zzu zzu2 = this;
        return zzu2.zzd(zzu2.zza.size());
    }

    @Override
    public final List<com.google.firebase.firestore.d.a.zze> zzc(int n) {
        int n2 = this.zza.size();
        n = (n = this.zze(n)) < 0 ? 0 : (n >= n2 ? n2 : ++n);
        return this.zzd(n);
    }

    @Override
    public final List<com.google.firebase.firestore.d.a.zze> zzb(com.google.firebase.firestore.d.zze zze2) {
        Object object;
        Object object2 = new zza(zze2, 0);
        ArrayList<com.google.firebase.firestore.d.a.zze> arrayList = new ArrayList<com.google.firebase.firestore.d.a.zze>();
        object2 = this.zzb.iteratorFrom(object2);
        while (object2.hasNext() && zze2.equals(((zza)(object = (zza)object2.next())).zza())) {
            com.google.a.a.a.a.zza.zza((object = this.zza(((zza)object).zzb())) != null, "Batches in the index must exist in the main table", new Object[0]);
            arrayList.add((com.google.firebase.firestore.d.a.zze)object);
        }
        return arrayList;
    }

    @Override
    public final List<com.google.firebase.firestore.d.a.zze> zza(zzx object5) {
        Object object2;
        Object object3;
        object5 = ((zzx)object5).zza();
        int n = ((com.google.firebase.firestore.d.zza)object5).zzg() + 1;
        Object object4 = object5;
        if (!com.google.firebase.firestore.d.zze.zzb((zzl)object4)) {
            object4 = (zzl)((Object)((com.google.firebase.firestore.d.zza)object4).zza(""));
        }
        object4 = new zza(com.google.firebase.firestore.d.zze.zza((zzl)object4), 0);
        ImmutableSortedSet immutableSortedSet = new ImmutableSortedSet(Collections.emptyList(), zzs.zzb());
        object4 = this.zzb.iteratorFrom(object4);
        while (object4.hasNext() && ((com.google.firebase.firestore.d.zza)object5).zzc(object3 = ((zza)(object2 = (zza)object4.next())).zza().zzd())) {
            if (((com.google.firebase.firestore.d.zza)object3).zzg() != n) continue;
            immutableSortedSet = immutableSortedSet.insert((Object)((zza)object2).zzb());
        }
        object2 = new ArrayList();
        for (Object object5 : immutableSortedSet) {
            if ((object5 = this.zza((Integer)object5)) == null) continue;
            object2.add(object5);
        }
        return object2;
    }

    @Override
    public final void zza(List<com.google.firebase.firestore.d.a.zze> object) {
        com.google.firebase.firestore.d.a.zze immutableSortedSet;
        int n = object.size();
        com.google.a.a.a.a.zza.zza(n > 0, "Should not remove mutations when none exist.", new Object[0]);
        int n2 = ((com.google.firebase.firestore.d.a.zze)object.get(0)).zzb();
        int n3 = this.zza.size();
        int n4 = this.zza(n2, "removed");
        com.google.a.a.a.a.zza.zza(this.zza.get(n4).zzb() == n2, "Removed batches must exist in the queue", new Object[0]);
        n2 = 1;
        int n5 = n4 + 1;
        while (n2 < n && n5 < n3) {
            immutableSortedSet = this.zza.get(n5);
            if (immutableSortedSet.zzd()) {
                ++n5;
                continue;
            }
            com.google.a.a.a.a.zza.zza(immutableSortedSet.zzb() == ((com.google.firebase.firestore.d.a.zze)object.get(n2)).zzb(), "Removed batches must be contiguous in the queue", new Object[0]);
            ++n2;
            ++n5;
        }
        if (n4 == 0) {
            while (n5 < n3 && (immutableSortedSet = this.zza.get(n5)).zzd()) {
                ++n5;
            }
            this.zza.subList(n4, n5).clear();
        } else {
            for (int i = n4; i < n5; ++i) {
                List<com.google.firebase.firestore.d.a.zze> list = this.zza;
                list.set(i, list.get(i).zze());
            }
        }
        ImmutableSortedSet immutableSortedSet2 = this.zzb;
        object = object.iterator();
        while (object.hasNext()) {
            com.google.firebase.firestore.d.a.zze zze3 = (com.google.firebase.firestore.d.a.zze)object.next();
            n2 = zze3.zzb();
            for (zzd object2 : zze3.zzf()) {
                com.google.firebase.firestore.d.zze zze2 = object2.zza();
                if (this.zzf != null) {
                    this.zzf.zza(zze2);
                }
                zza zza2 = new zza(zze2, n2);
                immutableSortedSet2 = immutableSortedSet2.remove((Object)zza2);
            }
        }
        this.zzb = immutableSortedSet2;
    }

    @Override
    public final void zze() {
        if (this.zza.isEmpty()) {
            com.google.a.a.a.a.zza.zza(this.zzb.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty.", new Object[0]);
        }
    }

    @Override
    public final void zza(@Nullable zze zze2) {
        this.zzf = zze2;
    }

    @Override
    public final boolean zza(com.google.firebase.firestore.d.zze zze2) {
        Object object = new zza(zze2, 0);
        if (!(object = this.zzb.iteratorFrom(object)).hasNext()) {
            return false;
        }
        object = ((zza)object.next()).zza();
        return ((com.google.firebase.firestore.d.zze)object).equals(zze2);
    }

    private List<com.google.firebase.firestore.d.a.zze> zzd(int n) {
        ArrayList<com.google.firebase.firestore.d.a.zze> arrayList = new ArrayList<com.google.firebase.firestore.d.a.zze>(n);
        for (int i = 0; i < n; ++i) {
            com.google.firebase.firestore.d.a.zze zze2 = this.zza.get(i);
            if (zze2.zzd()) continue;
            arrayList.add(zze2);
        }
        return arrayList;
    }

    private int zze(int n) {
        if (this.zza.isEmpty()) {
            return 0;
        }
        com.google.firebase.firestore.d.a.zze zze2 = this.zza.get(0);
        int n2 = zze2.zzb();
        return n - n2;
    }

    private int zza(int n, String string) {
        com.google.a.a.a.a.zza.zza((n = this.zze(n)) >= 0 && n < this.zza.size(), "Batches must exist to be %s", string);
        return n;
    }
}

