/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.UserDataConverter;
import com.google.firebase.firestore.d.a.zza;
import com.google.firebase.firestore.d.a.zzd;
import com.google.firebase.firestore.d.a.zzi;
import com.google.firebase.firestore.g.zzs;
import java.util.ArrayList;
import java.util.Map;

public class WriteBatch {
    private final FirebaseFirestore zza;
    private final ArrayList<zzd> zzb = new ArrayList();
    private boolean zzc = false;

    /*
     * WARNING - void declaration
     */
    WriteBatch(FirebaseFirestore firestore) {
        void var1_1;
        this.zza = (FirebaseFirestore)Preconditions.checkNotNull((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, (Map<String, Object>)var2_2, SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data, @NonNull SetOptions options) {
        void var1_1;
        UserDataConverter.ParsedDocumentData parsedDocumentData;
        void var3_3;
        this.zza.zza(documentRef);
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        this.zza();
        parsedDocumentData = options.isMerge() ? this.zza.zzc().parseMergeData(data, var3_3.getFieldMask()) : this.zza.zzc().parseSetData((Map<String, Object>)((Object)parsedDocumentData));
        this.zzb.addAll(parsedDocumentData.toMutationList(var1_1.zza(), zzi.zza));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch set(@NonNull DocumentReference documentRef, @NonNull Object pojo) {
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, this.zza.zzc().convertPOJO(var2_2), SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch set(@NonNull DocumentReference documentRef, @NonNull Object pojo, @NonNull SetOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, this.zza.zzc().convertPOJO(var2_2), (SetOptions)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch update(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        void var1_1;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zza.zzc().parseUpdateData((Map<String, Object>)((Object)parsedUpdateData));
        return this.zza((DocumentReference)var1_1, parsedUpdateData);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch update(@NonNull DocumentReference documentRef, @NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var1_1;
        void var3_3;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zza.zzc().parseUpdateData(zzs.zza(1, parsedUpdateData, var3_3, moreFieldsAndValues));
        return this.zza((DocumentReference)var1_1, parsedUpdateData);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch update(@NonNull DocumentReference documentRef, @NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var1_1;
        void var3_3;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zza.zzc().parseUpdateData(zzs.zza(1, parsedUpdateData, var3_3, moreFieldsAndValues));
        return this.zza((DocumentReference)var1_1, parsedUpdateData);
    }

    private WriteBatch zza(@NonNull DocumentReference documentReference, @NonNull UserDataConverter.ParsedUpdateData parsedUpdateData) {
        this.zza.zza(documentReference);
        this.zza();
        this.zzb.addAll(parsedUpdateData.toMutationList(documentReference.zza(), zzi.zza(true)));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WriteBatch delete(@NonNull DocumentReference documentRef) {
        void var1_1;
        this.zza.zza(documentRef);
        this.zza();
        this.zzb.add(new zza(var1_1.zza(), zzi.zza));
        return this;
    }

    @NonNull
    public Task<Void> commit() {
        this.zza();
        this.zzc = true;
        if (this.zzb.size() > 0) {
            return this.zza.zza().zza(this.zzb);
        }
        return Tasks.forResult(null);
    }

    private void zza() {
        if (this.zzc) {
            throw new IllegalStateException("A write batch can no longer be used after commit() has been called.");
        }
    }
}

