/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.b.zza;
import com.google.firebase.firestore.b.zzaa;
import com.google.firebase.firestore.b.zzak;
import com.google.firebase.firestore.b.zzd;
import com.google.firebase.firestore.b.zze;
import com.google.firebase.firestore.b.zzw;
import com.google.firebase.firestore.b.zzx;
import com.google.firebase.firestore.b.zzy;
import com.google.firebase.firestore.d.b.zzl;
import com.google.firebase.firestore.d.zzc;
import com.google.firebase.firestore.g.zzj;
import com.google.firebase.firestore.g.zzp;
import com.google.firebase.firestore.g.zzs;
import com.google.firebase.firestore.zzg;
import com.google.firebase.firestore.zzh;
import com.google.firebase.firestore.zzi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class Query {
    final zzx zza;
    final FirebaseFirestore zzb;

    /*
     * WARNING - void declaration
     */
    Query(zzx query, FirebaseFirestore firestore) {
        void var2_2;
        void var1_1;
        this.zza = (zzx)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (FirebaseFirestore)Preconditions.checkNotNull((Object)var2_2);
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zzb;
    }

    private static void zza(com.google.firebase.firestore.d.zzi zzi2, com.google.firebase.firestore.d.zzi object) {
        if (!zzi2.equals(object)) {
            object = ((com.google.firebase.firestore.d.zzi)object).zzf();
            throw new IllegalArgumentException(String.format("Invalid query. You have an inequality where filter (whereLessThan(), whereGreaterThan(), etc.) on field '%s' and so you must also have '%s' as your first orderBy() field, but your first orderBy() is currently on field '%s' instead.", object, object, zzi2.zzf()));
        }
    }

    private void zza(zze object) {
        if (object instanceof zzaa && ((zzaa)object).zze()) {
            com.google.firebase.firestore.d.zzi zzi2 = this.zza.zzi();
            object = object.zza();
            if (zzi2 != null && !zzi2.equals(object)) {
                throw new IllegalArgumentException(String.format("All where filters other than whereEqualTo() must be on the same field. But you have filters on '%s' and '%s'", zzi2.zzf(), ((com.google.firebase.firestore.d.zzi)object).zzf()));
            }
            zzi2 = this.zza.zzh();
            if (zzi2 != null) {
                Query.zza(zzi2, (com.google.firebase.firestore.d.zzi)object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereEqualTo(@NonNull String field, @Nullable Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzaa.zza.zzc, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzaa.zza.zzc, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereLessThan(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzaa.zza.zza, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzaa.zza.zza, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzaa.zza.zzb, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzaa.zza.zzb, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereGreaterThan(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzaa.zza.zzd, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzaa.zza.zzd, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzaa.zza.zze, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzaa.zza.zze, var2_2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Query zza(@NonNull FieldPath fieldPath, zzaa.zza zza2, Object object) {
        com.google.firebase.firestore.d.zzi zzi2;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)zza2), (Object)"Provided op must not be null.");
        com.google.firebase.firestore.d.zzi zzi3 = fieldPath.zza();
        zzi3 = zzi3;
        if (zzi2.equals(com.google.firebase.firestore.d.zzi.zzb)) {
            if (object instanceof String) {
                if (((String)(object = (String)object)).contains("/")) {
                    throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but '" + (String)object + "' contains a '/' character.");
                }
                if (((String)object).isEmpty()) {
                    throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
                }
                object = (com.google.firebase.firestore.d.zzl)this.zza.zza().zza(object);
                com.google.a.a.a.a.zza.zza(((com.google.firebase.firestore.d.zza)object).zzg() % 2 == 0, "Path should be a document key", new Object[0]);
                object = zzl.zza(this.getFirestore().zzb(), com.google.firebase.firestore.d.zze.zza((com.google.firebase.firestore.d.zzl)object));
            } else {
                if (!(object instanceof DocumentReference)) throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: " + zzs.zza(object));
                object = (DocumentReference)object;
                object = zzl.zza(this.getFirestore().zzb(), ((DocumentReference)object).zza());
            }
        } else {
            object = this.zzb.zzc().parseQueryValue(object);
        }
        object = zzaa.zza(fieldPath.zza(), zza2, (com.google.firebase.firestore.d.b.zze)object);
        this.zza((zze)object);
        return new Query(this.zza.zza((zze)object), this.zzb);
    }

    private void zza(com.google.firebase.firestore.d.zzi zzi2) {
        com.google.firebase.firestore.d.zzi zzi3 = this.zza.zzi();
        if (this.zza.zzh() == null && zzi3 != null) {
            Query.zza(zzi2, zzi3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query orderBy(@NonNull String field) {
        void var1_1;
        return this.orderBy(FieldPath.zza((String)var1_1), Direction.ASCENDING);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(var1_1.zza(), Direction.ASCENDING);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query orderBy(@NonNull String field, @NonNull Direction direction) {
        void var2_2;
        void var1_1;
        return this.orderBy(FieldPath.zza((String)var1_1), (Direction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(var1_1.zza(), (Direction)var2_2);
    }

    private Query zza(@NonNull com.google.firebase.firestore.d.zzi zzi2, @NonNull Direction enum_) {
        Preconditions.checkNotNull((Object)enum_, (Object)"Provided direction must not be null.");
        if (this.zza.zzf() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.zza.zzg() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endAfter() before calling Query.orderBy().");
        }
        this.zza(zzi2);
        enum_ = enum_ == Direction.ASCENDING ? zzw.zza.zza : zzw.zza.zzb;
        return new Query(this.zza.zza(zzw.zza((zzw.zza)enum_, zzi2)), this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Query limit(long limit) {
        void var1_1;
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid Query. Query limit (" + limit + ") is invalid. Limit must be positive.");
        }
        return new Query(this.zza.zza((long)var1_1), this.zzb);
    }

    @NonNull
    public Query startAt(@NonNull DocumentSnapshot snapshot) {
        zza zza2;
        zza2 = this.zza("startAt", (DocumentSnapshot)((Object)zza2), true);
        return new Query(this.zza.zza(zza2), this.zzb);
    }

    @NonNull
    public Query startAt(Object ... fieldValues) {
        zza zza2;
        zza2 = this.zza("startAt", (Object[])zza2, true);
        return new Query(this.zza.zza(zza2), this.zzb);
    }

    @NonNull
    public Query startAfter(@NonNull DocumentSnapshot snapshot) {
        zza zza2;
        zza2 = this.zza("startAfter", (DocumentSnapshot)((Object)zza2), false);
        return new Query(this.zza.zza(zza2), this.zzb);
    }

    @NonNull
    public Query startAfter(Object ... fieldValues) {
        zza zza2;
        zza2 = this.zza("startAfter", (Object[])zza2, false);
        return new Query(this.zza.zza(zza2), this.zzb);
    }

    @NonNull
    public Query endBefore(@NonNull DocumentSnapshot snapshot) {
        zza zza2;
        zza2 = this.zza("endBefore", (DocumentSnapshot)((Object)zza2), true);
        return new Query(this.zza.zzb(zza2), this.zzb);
    }

    @NonNull
    public Query endBefore(Object ... fieldValues) {
        zza zza2;
        zza2 = this.zza("endBefore", (Object[])zza2, true);
        return new Query(this.zza.zzb(zza2), this.zzb);
    }

    @NonNull
    public Query endAt(@NonNull DocumentSnapshot snapshot) {
        zza zza2;
        zza2 = this.zza("endAt", (DocumentSnapshot)((Object)zza2), false);
        return new Query(this.zza.zzb(zza2), this.zzb);
    }

    @NonNull
    public Query endAt(Object ... fieldValues) {
        zza zza2;
        zza2 = this.zza("endAt", (Object[])zza2, false);
        return new Query(this.zza.zzb(zza2), this.zzb);
    }

    private zza zza(String object, DocumentSnapshot object2, boolean bl) {
        Preconditions.checkNotNull((Object)object2, (Object)"Provided snapshot must not be null.");
        if (!((DocumentSnapshot)object2).exists()) {
            throw new IllegalArgumentException("Can't use a DocumentSnapshot for a document that doesn't exist for " + (String)object + "().");
        }
        object = ((DocumentSnapshot)object2).zza();
        object2 = new ArrayList();
        for (zzw zzw2 : this.zza.zzk()) {
            if (zzw2.zzb().equals(com.google.firebase.firestore.d.zzi.zzb)) {
                object2.add(zzl.zza(this.zzb.zzb(), ((com.google.firebase.firestore.d.zzj)object).zzd()));
                continue;
            }
            com.google.firebase.firestore.d.b.zze zze2 = ((zzc)object).zza(zzw2.zzb());
            if (zze2 != null) {
                object2.add(zze2);
                continue;
            }
            throw new IllegalArgumentException("Invalid query. You are trying to start or end a query using a document for which the field '" + zzw2.zzb() + "' (used as the orderBy) does not exist.");
        }
        return new zza((List<com.google.firebase.firestore.d.b.zze>)object2, bl);
    }

    private zza zza(String string, Object[] objectArray, boolean bl) {
        List<zzw> list = this.zza.zzj();
        if (objectArray.length > list.size()) {
            throw new IllegalArgumentException("Too many arguments provided to " + string + "(). The number of arguments must be less than or equal to the number of orderBy() clauses.");
        }
        ArrayList<com.google.firebase.firestore.d.b.zze> arrayList = new ArrayList<com.google.firebase.firestore.d.b.zze>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            zzw zzw2 = list.get(i);
            if (zzw2.zzb().equals(com.google.firebase.firestore.d.zzi.zzb)) {
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException("Invalid query. Expected a string for document ID in " + string + "(), but got " + object + ".");
                }
                if (((String)(object = (String)object)).contains("/")) {
                    throw new IllegalArgumentException("Invalid query. Document ID '" + (String)object + "' contains a slash in " + string + "().");
                }
                object = com.google.firebase.firestore.d.zze.zza((com.google.firebase.firestore.d.zzl)this.zza.zza().zza(object));
                arrayList.add(zzl.zza(this.zzb.zzb(), (com.google.firebase.firestore.d.zze)object));
                continue;
            }
            object = this.zzb.zzc().parseQueryValue(object);
            arrayList.add((com.google.firebase.firestore.d.b.zze)object);
        }
        return new zza(arrayList, bl);
    }

    @NonNull
    public Task<QuerySnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    public Task<QuerySnapshot> get(Source source) {
        Object object;
        if (source == Source.CACHE) {
            return this.zzb.zza().zza(this.zza).continueWith(zzj.zzb, (Continuation)new zzg(this));
        }
        void var2_2 = object;
        object = this;
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzd.zza zza2 = new zzd.zza();
        new zzd.zza().zza = true;
        zza2.zzb = true;
        zza2.zzc = true;
        object = ((Query)object).zza(zzj.zzb, zza2, null, new zzh(taskCompletionSource, taskCompletionSource2, (Source)var2_2));
        taskCompletionSource2.setResult(object);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> listener) {
        void var1_1;
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, (EventListener<QuerySnapshot>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Executor)var1_1, MetadataChanges.EXCLUDE, (EventListener<QuerySnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Activity)var1_1, MetadataChanges.EXCLUDE, (EventListener<QuerySnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener(zzj.zza, (MetadataChanges)var1_1, (EventListener<QuerySnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza((Executor)var1_1, Query.zza((MetadataChanges)var2_2), null, (EventListener<QuerySnapshot>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzj.zza, Query.zza((MetadataChanges)var2_2), (Activity)var1_1, (EventListener<QuerySnapshot>)var3_3);
    }

    private ListenerRegistration zza(Executor object, zzd.zza object2, @Nullable Activity activity, EventListener<QuerySnapshot> eventListener) {
        object = new com.google.firebase.firestore.g.zzh((Executor)object, new zzi(this, eventListener));
        object2 = this.zzb.zza().zza(this.zza, (zzd.zza)object2, (EventListener<zzak>)object);
        return new zzp(this.zzb.zza(), (zzy)object2, activity, (com.google.firebase.firestore.g.zzh<zzak>)object);
    }

    public boolean equals(Object o) {
        Query query;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        query = query;
        return this.zza.equals(query.zza) && this.zzb.equals(query.zzb);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        return n;
    }

    private static zzd.zza zza(MetadataChanges metadataChanges) {
        zzd.zza zza2 = new zzd.zza();
        new zzd.zza().zza = metadataChanges == MetadataChanges.INCLUDE;
        zza2.zzb = metadataChanges == MetadataChanges.INCLUDE;
        zza2.zzc = false;
        return zza2;
    }

    static final /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, TaskCompletionSource object, Source source, QuerySnapshot querySnapshot, FirebaseFirestoreException firebaseFirestoreException) {
        if (firebaseFirestoreException != null) {
            taskCompletionSource.setException((Exception)((Object)firebaseFirestoreException));
            return;
        }
        try {
            object = (ListenerRegistration)Tasks.await((Task)object.getTask());
            object.remove();
            if (!querySnapshot.getMetadata().isFromCache() || source != Source.SERVER) {
                taskCompletionSource.setResult((Object)querySnapshot);
                return;
            }
            taskCompletionSource.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to SERVER to retrieve the cached documents.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
        }
        catch (ExecutionException executionException) {
            object = executionException;
            com.google.a.a.a.a.zza.zza(executionException, "Failed to register a listener for a query result", new Object[0]);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            com.google.a.a.a.a.zza.zza(interruptedException, "Failed to register a listener for a query result", new Object[0]);
        }
    }

    @Keep
    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

