/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class FirebaseFirestoreSettings {
    private final String zza;
    private final boolean zzb;
    private final boolean zzc;
    private final boolean zzd;

    /*
     * WARNING - void declaration
     */
    private FirebaseFirestoreSettings(Builder builder) {
        void var1_1;
        this.zza = builder.zza;
        this.zzb = builder.zzb;
        this.zzc = builder.zzc;
        this.zzd = ((Builder)var1_1).zzd;
    }

    public final boolean equals(@Nullable Object o) {
        FirebaseFirestoreSettings firebaseFirestoreSettings;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        firebaseFirestoreSettings = firebaseFirestoreSettings;
        return this.zza.equals(firebaseFirestoreSettings.zza) && this.zzb == firebaseFirestoreSettings.zzb && this.zzc == firebaseFirestoreSettings.zzc && this.zzd == firebaseFirestoreSettings.zzd;
    }

    public final int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + (this.zzb ? 1 : 0);
        n = n * 31 + (this.zzc ? 1 : 0);
        n = n * 31 + (this.zzd ? 1 : 0);
        return n;
    }

    @NonNull
    public final String toString() {
        return Objects.toStringHelper((Object)this).add("host", (Object)this.zza).add("sslEnabled", this.zzb).add("persistenceEnabled", this.zzc).add("timestampsInSnapshotsEnabled", this.zzd).toString();
    }

    @NonNull
    public final String getHost() {
        return this.zza;
    }

    public final boolean isSslEnabled() {
        return this.zzb;
    }

    public final boolean isPersistenceEnabled() {
        return this.zzc;
    }

    public final boolean areTimestampsInSnapshotsEnabled() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ FirebaseFirestoreSettings(Builder x0, byte by) {
        this((Builder)var1_1);
        void var1_1;
    }

    public static final class Builder {
        private String zza;
        private boolean zzb;
        private boolean zzc;
        private boolean zzd;

        public Builder() {
            this.zza = "firestore.googleapis.com";
            this.zzb = true;
            this.zzc = true;
            this.zzd = false;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull FirebaseFirestoreSettings settings) {
            void var1_1;
            Preconditions.checkNotNull((Object)settings, (Object)"Provided settings must not be null.");
            this.zza = settings.zza;
            this.zzb = settings.zzb;
            this.zzc = settings.zzc;
            this.zzd = ((FirebaseFirestoreSettings)var1_1).zzd;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public final Builder setHost(@NonNull String host) {
            void var1_1;
            this.zza = (String)Preconditions.checkNotNull((Object)var1_1, (Object)"Provided host must not be null.");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public final Builder setSslEnabled(boolean value) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public final Builder setPersistenceEnabled(boolean value) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public final Builder setTimestampsInSnapshotsEnabled(boolean value) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        @NonNull
        public final FirebaseFirestoreSettings build() {
            if (!this.zzb && this.zza.equals("firestore.googleapis.com")) {
                throw new IllegalStateException("You can't set the 'sslEnabled' setting unless you also set a non-default 'host'.");
            }
            return new FirebaseFirestoreSettings(this, 0);
        }
    }
}

