/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdpq;
import com.google.android.gms.internal.zzdpx;
import io.grpc.internal.zzcp;
import io.grpc.internal.zzez;
import io.grpc.internal.zzfb;
import io.grpc.internal.zzfc;
import io.grpc.internal.zzfd;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class zzfa
implements zzez {
    private static final Logger zza = Logger.getLogger(zzfa.class.getName());
    private static final zza zzb = new zzfb();
    private static final zzdpx<ProxySelector> zzc = new zzfc();
    private final zzdpx<ProxySelector> zzd;
    private final zza zze;
    private final zzfd zzf;

    public zzfa() {
        this(zzc, zzb, System.getenv("GRPC_PROXY_EXP"));
    }

    private zzfa(zzdpx<ProxySelector> zzdpx2, zza zza2, String string) {
        this.zzd = zzdpq.zza(zzdpx2);
        this.zze = zzdpq.zza(zza2);
        if (string != null) {
            InetSocketAddress inetSocketAddress;
            String string2 = string;
            if (string2 == null) {
                inetSocketAddress = null;
            } else {
                String[] stringArray = string2.split(":", 2);
                int n = 80;
                if (stringArray.length > 1) {
                    n = Integer.parseInt(stringArray[1]);
                }
                zza.logp(Level.WARNING, "io.grpc.internal.ProxyDetectorImpl", "overrideProxy", "Detected GRPC_PROXY_EXP and will honor it, but this feature will be removed in a future release. Use the JVM flags \"-Dhttps.proxyHost=HOST -Dhttps.proxyPort=PORT\" to set the https proxy for this JVM.");
                inetSocketAddress = InetSocketAddress.createUnresolved(stringArray[0], n);
            }
            this.zzf = new zzfd(inetSocketAddress, null, null);
            return;
        }
        this.zzf = null;
    }

    @Override
    public final zzfd zza(SocketAddress socketAddress) {
        if (this.zzf != null) {
            return this.zzf;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return null;
        }
        return this.zza((InetSocketAddress)socketAddress);
    }

    private final zzfd zza(InetSocketAddress inetSocketAddress) {
        Proxy proxy;
        URI uRI;
        try {
            uRI = new URI("https", null, inetSocketAddress.getHostName(), inetSocketAddress.getPort(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            zza.logp(Level.WARNING, "io.grpc.internal.ProxyDetectorImpl", "detectProxy", "Failed to construct URI for proxy lookup, proceeding without proxy", uRISyntaxException);
            return null;
        }
        List<Proxy> list = this.zzd.zza().select(uRI);
        if (list.size() > 1) {
            zza.logp(Level.WARNING, "io.grpc.internal.ProxyDetectorImpl", "detectProxy", "More than 1 proxy detected, gRPC will select the first one");
        }
        if ((proxy = list.get(0)).type() == Proxy.Type.DIRECT) {
            return null;
        }
        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)proxy.address();
        String string = "";
        PasswordAuthentication passwordAuthentication = this.zze.zza(zzcp.zza(inetSocketAddress2), inetSocketAddress2.getAddress(), inetSocketAddress2.getPort(), "https", string, null);
        if (passwordAuthentication == null) {
            return new zzfd(inetSocketAddress2, null, null);
        }
        return new zzfd(inetSocketAddress2, passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
    }

    static /* synthetic */ Logger zza() {
        return zza;
    }

    static interface zza {
        public PasswordAuthentication zza(String var1, InetAddress var2, int var3, String var4, String var5, String var6);
    }
}

