/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzerr;
import com.google.android.gms.internal.zzeut;
import com.google.android.gms.internal.zzevb;
import com.google.android.gms.internal.zzevc;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyp;
import com.google.android.gms.internal.zzezd;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.zzj;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzn;
import com.google.firebase.firestore.zzo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class Transaction {
    private final zzerr zza;
    private final FirebaseFirestore zzb;

    Transaction(zzerr zzerr2, FirebaseFirestore firebaseFirestore) {
        this.zza = (zzerr)zzbq.zza((Object)zzerr2);
        this.zzb = (FirebaseFirestore)zzbq.zza((Object)firebaseFirestore);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map) {
        return this.set(documentReference, map, SetOptions.zza);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map, @NonNull SetOptions setOptions) {
        this.zzb.zza(documentReference);
        zzbq.zza(map, (Object)"Provided data must not be null.");
        zzbq.zza((Object)setOptions, (Object)"Provided options must not be null.");
        zzn zzn2 = setOptions.zza() ? this.zzb.zzc().zza(map, setOptions.zzb()) : this.zzb.zzc().zza(map);
        this.zza.zza(documentReference.zza(), zzn2);
        return this;
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Object object) {
        this.zzb.zzc();
        return this.set(documentReference, zzk.zzb(object), SetOptions.zza);
    }

    @NonNull
    public Transaction set(@NonNull DocumentReference documentReference, @NonNull Object object, @NonNull SetOptions setOptions) {
        this.zzb.zzc();
        return this.set(documentReference, zzk.zzb(object), setOptions);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull Map<String, Object> map) {
        zzo zzo2 = this.zzb.zzc().zzb(map);
        return this.zza(documentReference, zzo2);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull String string, @Nullable Object object, Object ... objectArray) {
        zzo zzo2 = this.zzb.zzc().zza(zzezd.zza(1, string, object, objectArray));
        return this.zza(documentReference, zzo2);
    }

    @NonNull
    public Transaction update(@NonNull DocumentReference documentReference, @NonNull FieldPath fieldPath, @Nullable Object object, Object ... objectArray) {
        zzo zzo2 = this.zzb.zzc().zza(zzezd.zza(1, fieldPath, object, objectArray));
        return this.zza(documentReference, zzo2);
    }

    private final Transaction zza(@NonNull DocumentReference documentReference, @NonNull zzo zzo2) {
        this.zzb.zza(documentReference);
        this.zza.zza(documentReference.zza(), zzo2);
        return this;
    }

    @NonNull
    public Transaction delete(@NonNull DocumentReference documentReference) {
        this.zzb.zza(documentReference);
        this.zza.zza(documentReference.zza());
        return this;
    }

    @NonNull
    public DocumentSnapshot get(@NonNull DocumentReference documentReference) throws FirebaseFirestoreException {
        this.zzb.zza(documentReference);
        try {
            DocumentReference documentReference2 = documentReference;
            Transaction transaction = this;
            return (DocumentSnapshot)Tasks.await((Task)transaction.zza.zza(Collections.singletonList(documentReference2.zza())).continueWith(zzeyp.zzb, (Continuation)new zzj(transaction)));
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            if (executionException.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)executionException2.getCause());
            }
            throw new RuntimeException(executionException2.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    final /* synthetic */ DocumentSnapshot zza(Task task) throws Exception {
        if (!task.isSuccessful()) {
            throw task.getException();
        }
        List list = (List)task.getResult();
        if (list.size() != 1) {
            throw zzeye.zza("Mismatch in docs returned from document lookup.", new Object[0]);
        }
        zzevb zzevb2 = (zzevb)list.get(0);
        if (zzevb2 instanceof zzevc) {
            return DocumentSnapshot.zza(this.zzb, zzevb2.zzd(), false);
        }
        return DocumentSnapshot.zza(this.zzb, (zzeut)zzevb2, false);
    }

    public static interface Function<TResult> {
        @Nullable
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

