/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeqg;
import com.google.android.gms.internal.zzeqm;
import com.google.android.gms.internal.zzeqo;
import com.google.android.gms.internal.zzerd;
import com.google.android.gms.internal.zzere;
import com.google.android.gms.internal.zzerf;
import com.google.android.gms.internal.zzerh;
import com.google.android.gms.internal.zzerj;
import com.google.android.gms.internal.zzerl;
import com.google.android.gms.internal.zzerz;
import com.google.android.gms.internal.zzeur;
import com.google.android.gms.internal.zzeut;
import com.google.android.gms.internal.zzeuw;
import com.google.android.gms.internal.zzeva;
import com.google.android.gms.internal.zzevd;
import com.google.android.gms.internal.zzevw;
import com.google.android.gms.internal.zzewc;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyn;
import com.google.android.gms.internal.zzeyp;
import com.google.android.gms.internal.zzeyy;
import com.google.android.gms.internal.zzezd;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.QueryListenOptions;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.zzh;
import com.google.firebase.firestore.zzi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class Query {
    final zzerf zza;
    final FirebaseFirestore zzb;

    Query(zzerf zzerf2, FirebaseFirestore firebaseFirestore) {
        this.zza = (zzerf)zzbq.zza((Object)zzerf2);
        this.zzb = (FirebaseFirestore)zzbq.zza((Object)firebaseFirestore);
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zzb;
    }

    private static void zza(zzeva zzeva2, zzeva zzeva3) {
        if (!zzeva2.equals(zzeva3)) {
            String string = ((zzeur)zzeva3).zzf();
            throw new IllegalArgumentException(String.format("Invalid query. You have an inequality where filter (whereLessThan(), whereGreaterThan(), etc.) on field '%s' and so you must also have '%s' as your first orderBy() field, but your first orderBy() is currently on field '%s' instead.", string, string, ((zzeur)zzeva2).zzf()));
        }
    }

    @NonNull
    public Query whereEqualTo(@NonNull String string, Object object) {
        return this.zza(FieldPath.zza(string), zzerl.zzc, object);
    }

    @NonNull
    public Query whereEqualTo(@NonNull FieldPath fieldPath, Object object) {
        return this.zza(fieldPath, zzerl.zzc, object);
    }

    @NonNull
    public Query whereLessThan(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zza(string), zzerl.zza, object);
    }

    @NonNull
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzerl.zza, object);
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zza(string), zzerl.zzb, object);
    }

    @NonNull
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzerl.zzb, object);
    }

    @NonNull
    public Query whereGreaterThan(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zza(string), zzerl.zzd, object);
    }

    @NonNull
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzerl.zzd, object);
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull String string, @NonNull Object object) {
        return this.zza(FieldPath.zza(string), zzerl.zze, object);
    }

    @NonNull
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object object) {
        return this.zza(fieldPath, zzerl.zze, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Query zza(@NonNull FieldPath fieldPath, zzerl zzerl2, Object object) {
        zzevw zzevw2;
        Object object2;
        block8: {
            block9: {
                zzbq.zza((Object)fieldPath, (Object)"Provided field path must not be null.");
                zzbq.zza((Object)((Object)zzerl2), (Object)"Provided op must not be null.");
                if (!fieldPath.zza().equals(zzeva.zzb)) break block9;
                if (object instanceof String) {
                    object2 = (String)object;
                    if (((String)object2).contains("/")) {
                        throw new IllegalArgumentException(new StringBuilder(127 + String.valueOf(object2).length()).append("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but '").append((String)object2).append("' contains a '/' character.").toString());
                    }
                    if (((String)object2).isEmpty()) {
                        throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
                    }
                    zzevd zzevd2 = (zzevd)this.zza.zza().zza(object2);
                    zzeye.zza(zzevd2.zzg() % 2 == 0, "Path should be a document key", new Object[0]);
                    zzevw2 = zzewc.zza(this.getFirestore().zzb(), zzeuw.zza(zzevd2));
                    break block8;
                } else if (object instanceof DocumentReference) {
                    object2 = (DocumentReference)object;
                    zzevw2 = zzewc.zza(this.getFirestore().zzb(), ((DocumentReference)object2).zza());
                    break block8;
                } else {
                    String string;
                    String string2 = String.valueOf(zzezd.zza(object));
                    if (string2.length() != 0) {
                        string = "Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: ".concat(string2);
                        throw new IllegalArgumentException(string);
                    }
                    string = new String("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: ");
                    throw new IllegalArgumentException(string);
                }
            }
            zzevw2 = this.zzb.zzc().zza(object);
        }
        Object object3 = object2 = zzerj.zza(fieldPath.zza(), zzerl2, zzevw2);
        Query query = this;
        if (!(object3 instanceof zzerj)) return new Query(this.zza.zza((zzeqo)object2), this.zzb);
        if (!((zzerj)object3).zze()) return new Query(this.zza.zza((zzeqo)object2), this.zzb);
        zzeva zzeva2 = query.zza.zzi();
        zzeva zzeva3 = object3.zza();
        if (zzeva2 != null && !zzeva2.equals(zzeva3)) {
            throw new IllegalArgumentException(String.format("All where filters other than whereEqualTo() must be on the same field. But you have filters on '%s' and '%s'", ((zzeur)zzeva2).zzf(), ((zzeur)zzeva3).zzf()));
        }
        zzeva zzeva4 = query.zza.zzh();
        if (zzeva4 == null) return new Query(this.zza.zza((zzeqo)object2), this.zzb);
        Query.zza(zzeva4, zzeva3);
        return new Query(this.zza.zza((zzeqo)object2), this.zzb);
    }

    @NonNull
    public Query orderBy(@NonNull String string) {
        return this.orderBy(FieldPath.zza(string), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath) {
        zzbq.zza((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(fieldPath.zza(), Direction.ASCENDING);
    }

    @NonNull
    public Query orderBy(@NonNull String string, @NonNull Direction direction) {
        return this.orderBy(FieldPath.zza(string), direction);
    }

    @NonNull
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        zzbq.zza((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(fieldPath.zza(), direction);
    }

    private final Query zza(@NonNull zzeva zzeva2, @NonNull Direction direction) {
        zzbq.zza((Object)((Object)direction), (Object)"Provided direction must not be null.");
        if (this.zza.zzf() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.zza.zzg() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endAfter() before calling Query.orderBy().");
        }
        zzeva zzeva3 = zzeva2;
        Query query = this;
        zzeva zzeva4 = query.zza.zzi();
        if (query.zza.zzh() == null && zzeva4 != null) {
            Query.zza(zzeva3, zzeva4);
        }
        zzere zzere2 = direction == Direction.ASCENDING ? zzere.zza : zzere.zzb;
        return new Query(this.zza.zza(zzerd.zza(zzere2, zzeva2)), this.zzb);
    }

    @NonNull
    public Query limit(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(85).append("Invalid Query. Query limit (").append(l).append(") is invalid. Limit must be positive.").toString());
        }
        return new Query(this.zza.zza(l), this.zzb);
    }

    @NonNull
    public Query startAt(@NonNull DocumentSnapshot documentSnapshot) {
        zzeqg zzeqg2 = this.zza("startAt", documentSnapshot, true);
        return new Query(this.zza.zza(zzeqg2), this.zzb);
    }

    @NonNull
    public Query startAt(Object ... objectArray) {
        zzeqg zzeqg2 = this.zza("startAt", objectArray, true);
        return new Query(this.zza.zza(zzeqg2), this.zzb);
    }

    @NonNull
    public Query startAfter(@NonNull DocumentSnapshot documentSnapshot) {
        zzeqg zzeqg2 = this.zza("startAfter", documentSnapshot, false);
        return new Query(this.zza.zza(zzeqg2), this.zzb);
    }

    @NonNull
    public Query startAfter(Object ... objectArray) {
        zzeqg zzeqg2 = this.zza("startAfter", objectArray, false);
        return new Query(this.zza.zza(zzeqg2), this.zzb);
    }

    @NonNull
    public Query endBefore(@NonNull DocumentSnapshot documentSnapshot) {
        zzeqg zzeqg2 = this.zza("endBefore", documentSnapshot, true);
        return new Query(this.zza.zzb(zzeqg2), this.zzb);
    }

    @NonNull
    public Query endBefore(Object ... objectArray) {
        zzeqg zzeqg2 = this.zza("endBefore", objectArray, true);
        return new Query(this.zza.zzb(zzeqg2), this.zzb);
    }

    @NonNull
    public Query endAt(@NonNull DocumentSnapshot documentSnapshot) {
        zzeqg zzeqg2 = this.zza("endAt", documentSnapshot, false);
        return new Query(this.zza.zzb(zzeqg2), this.zzb);
    }

    @NonNull
    public Query endAt(Object ... objectArray) {
        zzeqg zzeqg2 = this.zza("endAt", objectArray, false);
        return new Query(this.zza.zzb(zzeqg2), this.zzb);
    }

    private final zzeqg zza(String string, DocumentSnapshot documentSnapshot, boolean bl) {
        zzbq.zza((Object)documentSnapshot, (Object)"Provided snapshot must not be null.");
        if (!documentSnapshot.exists()) {
            throw new IllegalArgumentException(new StringBuilder(70 + String.valueOf(string).length()).append("Can't use a DocumentSnapshot for a document that doesn't exist for ").append(string).append("().").toString());
        }
        zzeut zzeut2 = documentSnapshot.zza();
        ArrayList<zzevw> arrayList = new ArrayList<zzevw>();
        for (zzerd zzerd2 : this.zza.zzk()) {
            if (zzerd2.zzb().equals(zzeva.zzb)) {
                arrayList.add(zzewc.zza(this.zzb.zzb(), zzeut2.zzd()));
                continue;
            }
            zzevw zzevw2 = zzeut2.zza(zzerd2.zzb());
            if (zzevw2 != null) {
                arrayList.add(zzevw2);
                continue;
            }
            String string2 = String.valueOf(zzerd2.zzb());
            throw new IllegalArgumentException(new StringBuilder(131 + String.valueOf(string2).length()).append("Invalid query. You are trying to start or end a query using a document for which the field '").append(string2).append("' (used as the orderBy) does not exist.").toString());
        }
        return new zzeqg(arrayList, bl);
    }

    private final zzeqg zza(String string, Object[] objectArray, boolean bl) {
        List<zzerd> list = this.zza.zzj();
        if (objectArray.length > list.size()) {
            throw new IllegalArgumentException(new StringBuilder(121 + String.valueOf(string).length()).append("Too many arguments provided to ").append(string).append("(). The number of arguments must be less than or equal to the number of orderBy() clauses.").toString());
        }
        ArrayList<zzevw> arrayList = new ArrayList<zzevw>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (list.get(i).zzb().equals(zzeva.zzb)) {
                if (!(object2 instanceof String)) {
                    object = String.valueOf(object2);
                    throw new IllegalArgumentException(new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(object).length()).append("Invalid query. Expected a string for document ID in ").append(string).append("(), but got ").append((String)object).append(".").toString());
                }
                object = (String)object2;
                if (((String)object).contains("/")) {
                    throw new IllegalArgumentException(new StringBuilder(53 + String.valueOf(object).length() + String.valueOf(string).length()).append("Invalid query. Document ID '").append((String)object).append("' contains a slash in ").append(string).append("().").toString());
                }
                zzeuw zzeuw2 = zzeuw.zza((zzevd)this.zza.zza().zza(object));
                arrayList.add(zzewc.zza(this.zzb.zzb(), zzeuw2));
                continue;
            }
            object = this.zzb.zzc().zza(object2);
            arrayList.add((zzevw)object);
        }
        return new zzeqg(arrayList, bl);
    }

    @NonNull
    public Task<QuerySnapshot> get() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzeqm zzeqm2 = new zzeqm();
        new zzeqm().zza = true;
        zzeqm2.zzb = true;
        zzeqm2.zzc = true;
        ListenerRegistration listenerRegistration = this.zza(zzeyp.zzb, zzeqm2, null, new zzh(taskCompletionSource, taskCompletionSource2));
        taskCompletionSource2.setResult((Object)listenerRegistration);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(executor, new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(activity, new QueryListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        return this.addSnapshotListener(zzeyp.zza, queryListenOptions, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        zzbq.zza((Object)executor, (Object)"Provided executor must not be null.");
        zzbq.zza((Object)queryListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.zza(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(executor, Query.zza(queryListenOptions), null, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull QueryListenOptions queryListenOptions, @NonNull EventListener<QuerySnapshot> eventListener) {
        zzbq.zza((Object)activity, (Object)"Provided activity must not be null.");
        zzbq.zza((Object)queryListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.zza(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzeyp.zza, Query.zza(queryListenOptions), activity, eventListener);
    }

    private final ListenerRegistration zza(Executor executor, zzeqm zzeqm2, Activity activity, EventListener<QuerySnapshot> eventListener) {
        zzeyn<zzerz> zzeyn2 = new zzeyn<zzerz>(executor, new zzi(this, eventListener));
        zzerh zzerh2 = this.zzb.zza().zza(this.zza, zzeqm2, zzeyn2);
        return new zzeyy(this.zzb.zza(), zzerh2, activity, zzeyn2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Query query = (Query)object;
        return this.zza.equals(query.zza) && this.zzb.equals(query.zzb);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        return n * 31 + this.zzb.hashCode();
    }

    private static zzeqm zza(QueryListenOptions queryListenOptions) {
        zzeqm zzeqm2 = new zzeqm();
        new zzeqm().zza = queryListenOptions.zzb;
        zzeqm2.zzb = queryListenOptions.zza;
        zzeqm2.zzc = false;
        return zzeqm2;
    }

    @Keep
    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

