/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzezd;

public class GeoPoint
implements Comparable<GeoPoint> {
    private final double zza;
    private final double zzb;

    public GeoPoint(double d, double d2) {
        if (Double.isNaN(d) || d < -90.0 || d > 90.0) {
            throw new IllegalArgumentException("Latitude must be in the range of [-90, 90]");
        }
        if (Double.isNaN(d2) || d2 < -180.0 || d2 > 180.0) {
            throw new IllegalArgumentException("Longitude must be in the range of [-180, 180]");
        }
        this.zza = d;
        this.zzb = d2;
    }

    public double getLatitude() {
        return this.zza;
    }

    public double getLongitude() {
        return this.zzb;
    }

    @Override
    public int compareTo(@NonNull GeoPoint geoPoint) {
        int n = zzezd.zza(this.zza, geoPoint.zza);
        if (n == 0) {
            return zzezd.zza(this.zzb, geoPoint.zzb);
        }
        return n;
    }

    @NonNull
    public String toString() {
        double d = this.zza;
        double d2 = this.zzb;
        return new StringBuilder(82).append("GeoPoint { latitude=").append(d).append(", longitude=").append(d2).append(" }").toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof GeoPoint)) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)object;
        return this.zza == geoPoint.zza && this.zzb == geoPoint.zzb;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.zza);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzb);
        return n * 31 + (int)(l ^ l >>> 32);
    }
}

