/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeqb;
import com.google.android.gms.internal.zzeqc;
import com.google.android.gms.internal.zzeqh;
import com.google.android.gms.internal.zzeqp;
import com.google.android.gms.internal.zzerr;
import com.google.android.gms.internal.zzeus;
import com.google.android.gms.internal.zzevd;
import com.google.android.gms.internal.zzeyf;
import com.google.android.gms.internal.zzeyz;
import com.google.android.gms.internal.zzezb;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.zze;
import com.google.firebase.firestore.zzk;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class FirebaseFirestore {
    private static final Map<String, FirebaseFirestore> zza = new HashMap<String, FirebaseFirestore>();
    private final Context zzb;
    private final zzeus zzc;
    private final String zzd;
    private final zzeqb zze;
    private final zzeyf zzf;
    private final FirebaseApp zzg;
    private FirebaseFirestoreSettings zzh;
    private zzeqp zzi;
    private zzk zzj;

    @NonNull
    public static FirebaseFirestore getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.zza(firebaseApp, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseFirestore.zza(firebaseApp, "(default)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static FirebaseFirestore zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        zzbq.zza((Object)firebaseApp, (Object)"Provided FirebaseApp must not be null.");
        zzbq.zza((Object)string, (Object)"Provided database must not be null.");
        Object object = firebaseApp.getName();
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append("|").append(string).toString();
        object = zza;
        synchronized (object) {
            FirebaseFirestore firebaseFirestore = zza.get(string2);
            if (firebaseFirestore == null) {
                String string3 = firebaseApp.getOptions().getProjectId();
                if (string3 == null) {
                    throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
                }
                zzeus zzeus2 = zzeus.zza(string3, string);
                zzeyf zzeyf2 = new zzeyf();
                zzeqc zzeqc2 = new zzeqc(firebaseApp);
                try {
                    ProviderInstaller.installIfNeeded((Context)firebaseApp.getApplicationContext());
                }
                catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException throwable) {
                    zzeyz.zza("Firestore", "Failed to update ssl context", new Object[0]);
                }
                String string4 = firebaseApp.getName();
                firebaseFirestore = new FirebaseFirestore(firebaseApp.getApplicationContext(), zzeus2, string4, zzeqc2, zzeyf2, firebaseApp);
                zza.put(string2, firebaseFirestore);
            }
            return firebaseFirestore;
        }
    }

    @VisibleForTesting
    private FirebaseFirestore(Context context, zzeus zzeus2, String string, zzeqb zzeqb2, zzeyf zzeyf2, @Nullable FirebaseApp firebaseApp) {
        this.zzb = (Context)zzbq.zza((Object)context);
        this.zzc = (zzeus)zzbq.zza((Object)((zzeus)zzbq.zza((Object)zzeus2)));
        this.zzj = new zzk(zzeus2);
        this.zzd = (String)zzbq.zza((Object)string);
        this.zze = (zzeqb)zzbq.zza((Object)zzeqb2);
        this.zzf = (zzeyf)zzbq.zza((Object)zzeyf2);
        this.zzg = firebaseApp;
        this.zzh = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.zzh;
    }

    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings firebaseFirestoreSettings) {
        zzbq.zza((Object)firebaseFirestoreSettings, (Object)"Provided settings must not be null.");
        if (this.zzi != null && !this.zzh.equals(firebaseFirestoreSettings)) {
            throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
        }
        this.zzh = firebaseFirestoreSettings;
    }

    private final void zzd() {
        if (this.zzi == null) {
            zzeqh zzeqh2 = new zzeqh(this.zzc, this.zzd, this.zzh.getHost(), this.zzh.isSslEnabled());
            this.zzi = new zzeqp(this.zzb, zzeqh2, this.zzh.isPersistenceEnabled(), this.zze, this.zzf);
        }
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzg;
    }

    @NonNull
    public CollectionReference collection(@NonNull String string) {
        zzbq.zza((Object)string, (Object)"Provided collection path must not be null.");
        this.zzd();
        return new CollectionReference(zzevd.zzb(string), this);
    }

    @NonNull
    public DocumentReference document(@NonNull String string) {
        zzbq.zza((Object)string, (Object)"Provided document path must not be null.");
        this.zzd();
        return DocumentReference.zza(zzevd.zzb(string), this);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> function) {
        zzbq.zza(function, (Object)"Provided transaction update function must not be null.");
        Executor executor = zzerr.zzb();
        Transaction.Function<TResult> function2 = function;
        FirebaseFirestore firebaseFirestore = this;
        firebaseFirestore.zzd();
        zze zze2 = new zze(firebaseFirestore, executor, function2);
        return firebaseFirestore.zzi.zza(zze2, 5);
    }

    @NonNull
    public WriteBatch batch() {
        this.zzd();
        return new WriteBatch(this);
    }

    public Task<Void> enableNetwork() {
        this.zzd();
        return this.zzi.zzb();
    }

    public Task<Void> disableNetwork() {
        this.zzd();
        return this.zzi.zza();
    }

    public static void setLoggingEnabled(boolean bl) {
        if (bl) {
            zzeyz.zza(zzezb.zza);
            return;
        }
        zzeyz.zza(zzezb.zzb);
    }

    final zzeqp zza() {
        return this.zzi;
    }

    final zzeus zzb() {
        return this.zzc;
    }

    final zzk zzc() {
        return this.zzj;
    }

    final void zza(DocumentReference documentReference) {
        zzbq.zza((Object)documentReference, (Object)"Provided DocumentReference must not be null.");
        if (documentReference.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Firestore instance.");
        }
    }
}

