/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeus;
import com.google.android.gms.internal.zzeut;
import com.google.android.gms.internal.zzeuw;
import com.google.android.gms.internal.zzevs;
import com.google.android.gms.internal.zzevw;
import com.google.android.gms.internal.zzewb;
import com.google.android.gms.internal.zzewc;
import com.google.android.gms.internal.zzeym;
import com.google.android.gms.internal.zzeyz;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DocumentSnapshot {
    private final FirebaseFirestore zza;
    private final zzeuw zzb;
    private final zzeut zzc;
    private final SnapshotMetadata zzd;

    DocumentSnapshot(FirebaseFirestore firebaseFirestore, zzeuw zzeuw2, zzeut zzeut2, boolean bl) {
        this.zza = (FirebaseFirestore)zzbq.zza((Object)firebaseFirestore);
        this.zzb = (zzeuw)zzbq.zza((Object)zzeuw2);
        this.zzc = zzeut2;
        boolean bl2 = this.zzc != null && this.zzc.zzc();
        this.zzd = new SnapshotMetadata(bl2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzeut zzeut2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzeut2.zzd(), zzeut2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzeuw zzeuw2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzeuw2, null, bl);
    }

    @NonNull
    public String getId() {
        return this.zzb.zzd().zzc();
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.zzd;
    }

    public boolean exists() {
        return this.zzc != null;
    }

    final zzeut zza() {
        return this.zzc;
    }

    public Map<String, Object> getData() {
        if (this.zzc == null) {
            return null;
        }
        return this.zza(this.zzc.zzb());
    }

    public <T> T toObject(@NonNull Class<T> clazz) {
        zzbq.zza(clazz, (Object)"Provided POJO type must not be null.");
        Map<String, Object> map = this.getData();
        if (map == null) {
            return null;
        }
        return zzeym.zza(map, clazz);
    }

    public boolean contains(@NonNull String string) {
        return this.contains(FieldPath.zza(string));
    }

    public boolean contains(@NonNull FieldPath fieldPath) {
        zzbq.zza((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zzc != null && this.zzc.zza(fieldPath.zza()) != null;
    }

    public Object get(@NonNull String string) {
        return this.get(FieldPath.zza(string));
    }

    public Object get(@NonNull FieldPath fieldPath) {
        zzevw zzevw2;
        zzbq.zza((Object)fieldPath, (Object)"Provided field path must not be null.");
        if (this.zzc != null && (zzevw2 = this.zzc.zza(fieldPath.zza())) != null) {
            return this.zza(zzevw2);
        }
        return null;
    }

    public Boolean getBoolean(@NonNull String string) {
        return this.zza(string, Boolean.class);
    }

    public Double getDouble(@NonNull String string) {
        Number number = this.zza(string, Number.class);
        if (number != null) {
            return number.doubleValue();
        }
        return null;
    }

    public String getString(@NonNull String string) {
        return this.zza(string, String.class);
    }

    public Long getLong(@NonNull String string) {
        Number number = this.zza(string, Number.class);
        if (number != null) {
            return number.longValue();
        }
        return null;
    }

    public Date getDate(@NonNull String string) {
        return this.zza(string, Date.class);
    }

    public Blob getBlob(@NonNull String string) {
        return this.zza(string, Blob.class);
    }

    public GeoPoint getGeoPoint(@NonNull String string) {
        return this.zza(string, GeoPoint.class);
    }

    public DocumentReference getDocumentReference(@NonNull String string) {
        return this.zza(string, DocumentReference.class);
    }

    @NonNull
    public DocumentReference getReference() {
        return new DocumentReference(this.zzb, this.zza);
    }

    private final <T> T zza(String string, Class<T> clazz) {
        zzbq.zza((Object)string, (Object)"Provided field must not be null.");
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            String string2 = clazz.getName();
            throw new RuntimeException(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Field '").append(string).append("' is not a ").append(string2).toString());
        }
        return clazz.cast(object);
    }

    private final Object zza(zzevw zzevw2) {
        if (zzevw2 instanceof zzewb) {
            return this.zza((zzewb)zzevw2);
        }
        if (zzevw2 instanceof zzevs) {
            zzevs zzevs2 = (zzevs)zzevw2;
            DocumentSnapshot documentSnapshot = this;
            ArrayList<Object> arrayList = new ArrayList<Object>(zzevs2.zzb().size());
            for (zzevw zzevw3 : zzevs2.zzb()) {
                arrayList.add(documentSnapshot.zza(zzevw3));
            }
            return arrayList;
        }
        if (zzevw2 instanceof zzewc) {
            zzeus zzeus2;
            zzeuw zzeuw2 = (zzeuw)((zzevw)((zzewc)zzevw2)).zzc();
            zzeus zzeus3 = ((zzewc)zzevw2).zzb();
            if (!zzeus3.equals(zzeus2 = this.zza.zzb())) {
                zzeyz.zza("DocumentSnapshot", String.format("Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", zzeuw2.zzd(), zzeus3.zza(), zzeus3.zzb(), zzeus2.zza(), zzeus2.zzb()), new Object[0]);
            }
            return new DocumentReference(zzeuw2, this.zza);
        }
        return zzevw2.zzc();
    }

    private final Map<String, Object> zza(zzewb zzewb2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : zzewb2.zzd()) {
            hashMap.put((String)entry.getKey(), this.zza((zzevw)entry.getValue()));
        }
        return hashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DocumentSnapshot)) {
            return false;
        }
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)object;
        return this.zza.equals(documentSnapshot.zza) && this.zzb.equals(documentSnapshot.zzb) && (this.zzc == null ? documentSnapshot.zzc == null : this.zzc.equals(documentSnapshot.zzc)) && this.zzd.equals(documentSnapshot.zzd);
    }

    public int hashCode() {
        return ((this.zza.hashCode() * 31 + this.zzb.hashCode()) * 31 + (this.zzc != null ? this.zzc.hashCode() : 0)) * 31 + this.zzd.hashCode();
    }
}

