/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeqm;
import com.google.android.gms.internal.zzerf;
import com.google.android.gms.internal.zzerh;
import com.google.android.gms.internal.zzerz;
import com.google.android.gms.internal.zzeur;
import com.google.android.gms.internal.zzeut;
import com.google.android.gms.internal.zzeuw;
import com.google.android.gms.internal.zzevd;
import com.google.android.gms.internal.zzevf;
import com.google.android.gms.internal.zzevp;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyn;
import com.google.android.gms.internal.zzeyp;
import com.google.android.gms.internal.zzeyy;
import com.google.android.gms.internal.zzezd;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentListenOptions;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.zzc;
import com.google.firebase.firestore.zzd;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzn;
import com.google.firebase.firestore.zzo;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;

public class DocumentReference {
    private final zzeuw zza;
    private final FirebaseFirestore zzb;

    DocumentReference(zzeuw zzeuw2, FirebaseFirestore firebaseFirestore) {
        this.zza = (zzeuw)zzbq.zza((Object)zzeuw2);
        this.zzb = firebaseFirestore;
    }

    @Hide
    public static DocumentReference zza(zzevd zzevd2, FirebaseFirestore firebaseFirestore) {
        if (zzevd2.zzg() % 2 != 0) {
            String string = ((zzeur)zzevd2).zzf();
            int n = zzevd2.zzg();
            throw new IllegalArgumentException(new StringBuilder(106 + String.valueOf(string).length()).append("Invalid document reference. Document references must have an even number of segments, but ").append(string).append(" has ").append(n).toString());
        }
        return new DocumentReference(zzeuw.zza(zzevd2), firebaseFirestore);
    }

    final zzeuw zza() {
        return this.zza;
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zzb;
    }

    @NonNull
    public String getId() {
        return this.zza.zzd().zzc();
    }

    @NonNull
    public CollectionReference getParent() {
        return new CollectionReference((zzevd)this.zza.zzd().zzb(), this.zzb);
    }

    @NonNull
    public String getPath() {
        return ((zzeur)this.zza.zzd()).zzf();
    }

    @NonNull
    public CollectionReference collection(@NonNull String string) {
        zzbq.zza((Object)string, (Object)"Provided collection path must not be null.");
        return new CollectionReference(this.zza.zzd().zza(zzevd.zzb(string)), this.zzb);
    }

    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> map) {
        return this.set(map, SetOptions.zza);
    }

    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> map, @NonNull SetOptions setOptions) {
        zzbq.zza(map, (Object)"Provided data must not be null.");
        zzbq.zza((Object)setOptions, (Object)"Provided options must not be null.");
        zzn zzn2 = setOptions.zza() ? this.zzb.zzc().zza(map, setOptions.zzb()) : this.zzb.zzc().zza(map);
        return this.zzb.zza().zza(zzn2.zza(this.zza, zzevp.zza)).continueWith(zzeyp.zzb, zzezd.zzc());
    }

    @NonNull
    public Task<Void> set(@NonNull Object object) {
        this.zzb.zzc();
        return this.set(zzk.zzb(object), SetOptions.zza);
    }

    @NonNull
    public Task<Void> set(@NonNull Object object, @NonNull SetOptions setOptions) {
        this.zzb.zzc();
        return this.set(zzk.zzb(object), setOptions);
    }

    @NonNull
    public Task<Void> update(@NonNull Map<String, Object> map) {
        zzo zzo2 = this.zzb.zzc().zzb(map);
        return this.zza(zzo2);
    }

    @NonNull
    public Task<Void> update(@NonNull String string, Object object, Object ... objectArray) {
        zzo zzo2 = this.zzb.zzc().zza(zzezd.zza(1, string, object, objectArray));
        return this.zza(zzo2);
    }

    @NonNull
    public Task<Void> update(@NonNull FieldPath fieldPath, Object object, Object ... objectArray) {
        zzo zzo2 = this.zzb.zzc().zza(zzezd.zza(1, fieldPath, object, objectArray));
        return this.zza(zzo2);
    }

    private final Task<Void> zza(@NonNull zzo zzo2) {
        return this.zzb.zza().zza(zzo2.zza(this.zza, zzevp.zza(true))).continueWith(zzeyp.zzb, zzezd.zzc());
    }

    @NonNull
    public Task<Void> delete() {
        return this.zzb.zza().zza(Collections.singletonList(new zzevf(this.zza, zzevp.zza))).continueWith(zzeyp.zzb, zzezd.zzc());
    }

    @NonNull
    public Task<DocumentSnapshot> get() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzeqm zzeqm2 = new zzeqm();
        new zzeqm().zza = true;
        zzeqm2.zzb = true;
        zzeqm2.zzc = true;
        ListenerRegistration listenerRegistration = this.zza(zzeyp.zzb, zzeqm2, null, new zzc(taskCompletionSource, taskCompletionSource2));
        taskCompletionSource2.setResult((Object)listenerRegistration);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(executor, new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(activity, new DocumentListenOptions(), eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        return this.addSnapshotListener(zzeyp.zza, documentListenOptions, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        zzbq.zza((Object)executor, (Object)"Provided executor must not be null.");
        zzbq.zza((Object)documentListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.zza(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(executor, DocumentReference.zza(documentListenOptions), null, eventListener);
    }

    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull DocumentListenOptions documentListenOptions, @NonNull EventListener<DocumentSnapshot> eventListener) {
        zzbq.zza((Object)activity, (Object)"Provided activity must not be null.");
        zzbq.zza((Object)documentListenOptions, (Object)"Provided listen options must not be null.");
        zzbq.zza(eventListener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzeyp.zza, DocumentReference.zza(documentListenOptions), activity, eventListener);
    }

    private final ListenerRegistration zza(Executor executor, zzeqm zzeqm2, Activity activity, EventListener<DocumentSnapshot> eventListener) {
        zzeyn<zzerz> zzeyn2 = new zzeyn<zzerz>(executor, new zzd(this, eventListener));
        zzerf zzerf2 = zzerf.zza(this.zza.zzd());
        zzerh zzerh2 = this.zzb.zza().zza(zzerf2, zzeqm2, zzeyn2);
        return new zzeyy(this.zzb.zza(), zzerh2, activity, zzeyn2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DocumentReference documentReference = (DocumentReference)object;
        return this.zza.equals(documentReference.zza) && this.zzb.equals(documentReference.zzb);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        return n * 31 + this.zzb.hashCode();
    }

    private static zzeqm zza(DocumentListenOptions documentListenOptions) {
        zzeqm zzeqm2 = new zzeqm();
        new zzeqm().zza = documentListenOptions.zza;
        zzeqm2.zzb = documentListenOptions.zza;
        zzeqm2.zzc = false;
        return zzeqm2;
    }

    final /* synthetic */ void zza(EventListener eventListener, zzerz zzerz2, FirebaseFirestoreException firebaseFirestoreException) {
        if (zzerz2 != null) {
            zzeye.zza(zzerz2.zzb().zza() <= 1, "Too many documents returned on a document query", new Object[0]);
            zzeut zzeut2 = zzerz2.zzb().zzb(this.zza);
            DocumentSnapshot documentSnapshot = zzeut2 != null ? DocumentSnapshot.zza(this.zzb, zzeut2, zzerz2.zze()) : DocumentSnapshot.zza(this.zzb, this.zza, zzerz2.zze());
            eventListener.onEvent(documentSnapshot, null);
            return;
        }
        zzeye.zza(firebaseFirestoreException != null, "Got event without value or error set", new Object[0]);
        eventListener.onEvent(null, firebaseFirestoreException);
    }
}

