/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.android.gms.common.internal.zzbq;
import java.util.Date;

public final class Timestamp
implements Comparable<Timestamp> {
    private final long zza;
    private final int zzb;

    public Timestamp(long l, int n) {
        Timestamp.zza(l, n);
        this.zza = l;
        this.zzb = n;
    }

    public Timestamp(Date date) {
        long l = date.getTime();
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if (n < 0) {
            --l2;
            n += 1000000000;
        }
        Timestamp.zza(l2, n);
        this.zza = l2;
        this.zzb = n;
    }

    public static Timestamp now() {
        return new Timestamp(new Date());
    }

    public final long getSeconds() {
        return this.zza;
    }

    public final int getNanoseconds() {
        return this.zzb;
    }

    public final Date getApproximateDate() {
        return new Date(this.zza * 1000L + (long)(this.zzb / 1000000));
    }

    @Override
    public final int compareTo(Timestamp timestamp) {
        if (this.zza == timestamp.zza) {
            return Integer.signum(this.zzb - timestamp.zzb);
        }
        return Long.signum(this.zza - timestamp.zza);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Timestamp)) {
            return false;
        }
        return this.compareTo((Timestamp)object) == 0;
    }

    public final int hashCode() {
        int n = 37 * (int)this.zza;
        n = n * 37 + (int)(this.zza >> 32);
        return n * 37 + this.zzb;
    }

    public final String toString() {
        long l = this.zza;
        int n = this.zzb;
        return new StringBuilder(64).append("Timestamp(seconds=").append(l).append(", nanoseconds=").append(n).append(")").toString();
    }

    private static void zza(long l, int n) {
        zzbq.zzb((n >= 0 ? 1 : 0) != 0, (String)"Timestamp nanoseconds out of range: %d", (Object[])new Object[]{n});
        zzbq.zzb(((double)n < 1.0E9 ? 1 : 0) != 0, (String)"Timestamp nanoseconds out of range: %d", (Object[])new Object[]{n});
        zzbq.zzb((l >= -62135596800L ? 1 : 0) != 0, (String)"Timestamp seconds out of range: %d", (Object[])new Object[]{l});
        zzbq.zzb((l < 253402300800L ? 1 : 0) != 0, (String)"Timestamp seconds out of range: %d", (Object[])new Object[]{l});
    }
}

