/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzeyz;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.Exclude;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.IgnoreExtraProperties;
import com.google.firebase.firestore.PropertyName;
import com.google.firebase.firestore.ServerTimestamp;
import com.google.firebase.firestore.ThrowOnExtraProperties;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class zzeym {
    private static final ConcurrentMap<Class<?>, zza<?>> zza = new ConcurrentHashMap();

    private static void zzb(boolean bl, String string) {
        if (!bl) {
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Hard assert failed: ".concat(string2) : new String("Hard assert failed: "));
        }
    }

    public static Object zza(Object object) {
        return zzeym.zzb(object, zzb.zza);
    }

    public static <T> T zza(Object object, Class<T> clazz) {
        return zzeym.zza(object, clazz, zzb.zza);
    }

    private static <T> Object zzb(T t, zzb zzb2) {
        if (zzb2.zza() > 500) {
            throw zzeym.zzb(zzb2, "Exceeded maximum depth of 500, which likely indicates there's an object cycle");
        }
        if (t == null) {
            return null;
        }
        if (t instanceof Number) {
            if (t instanceof Float) {
                return ((Float)t).doubleValue();
            }
            if (t instanceof Short) {
                throw zzeym.zzb(zzb2, "Shorts are not supported, please use int or long");
            }
            if (t instanceof Byte) {
                throw zzeym.zzb(zzb2, "Bytes are not supported, please use int or long");
            }
            return t;
        }
        if (t instanceof String) {
            return t;
        }
        if (t instanceof Boolean) {
            return t;
        }
        if (t instanceof Character) {
            throw zzeym.zzb(zzb2, "Characters are not supported, please use Strings.");
        }
        if (t instanceof Map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)t).entrySet()) {
                Object k = entry.getKey();
                if (k instanceof String) {
                    String string = (String)k;
                    hashMap.put(string, zzeym.zzb(entry.getValue(), zzb2.zza(string)));
                    continue;
                }
                throw zzeym.zzb(zzb2, "Maps with non-string keys are not supported");
            }
            return hashMap;
        }
        if (t instanceof Collection) {
            if (t instanceof List) {
                List list = (List)t;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    int n = i;
                    arrayList.add(zzeym.zzb(list.get(i), zzb2.zza(new StringBuilder(13).append("[").append(n).append("]").toString())));
                }
                return arrayList;
            }
            throw zzeym.zzb(zzb2, "Serializing Collections is not supported, please use Lists instead");
        }
        if (t.getClass().isArray()) {
            throw zzeym.zzb(zzb2, "Serializing Arrays is not supported, please use Lists instead");
        }
        if (t instanceof Enum) {
            return ((Enum)t).name();
        }
        if (t instanceof Date || t instanceof GeoPoint || t instanceof Blob || t instanceof DocumentReference) {
            return t;
        }
        return zzeym.zza(t.getClass()).zza(t, zzb2);
    }

    private static <T> T zzb(Object object, Type type, zzb zzb2) {
        Object object2;
        while (true) {
            Object object3;
            if (object == null) {
                return null;
            }
            if (type instanceof ParameterizedType) {
                zzb zzb3 = zzb2;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Object object4 = object;
                Class clazz = (Class)parameterizedType.getRawType();
                if (List.class.isAssignableFrom(clazz)) {
                    Type type2 = parameterizedType.getActualTypeArguments()[0];
                    if (object4 instanceof List) {
                        List list = (List)object4;
                        ArrayList<T> arrayList = new ArrayList<T>(list.size());
                        for (int i = 0; i < list.size(); ++i) {
                            int n = i;
                            arrayList.add(zzeym.zzb(list.get(i), type2, zzb3.zza(new StringBuilder(13).append("[").append(n).append("]").toString())));
                        }
                        return (T)arrayList;
                    }
                    String string = String.valueOf(object4.getClass());
                    throw zzeym.zzc(zzb3, new StringBuilder(27 + String.valueOf(string).length()).append("Expected a List, but got a ").append(string).toString());
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    Type type3 = parameterizedType.getActualTypeArguments()[0];
                    Type type4 = parameterizedType.getActualTypeArguments()[1];
                    if (!type3.equals(String.class)) {
                        String string = String.valueOf(type3);
                        throw zzeym.zzc(zzb3, new StringBuilder(70 + String.valueOf(string).length()).append("Only Maps with string keys are supported, but found Map with key type ").append(string).toString());
                    }
                    Map<String, Object> map = zzeym.zzc(object4, zzb3);
                    HashMap<String, T> hashMap = new HashMap<String, T>();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        hashMap.put(entry.getKey(), zzeym.zzb(entry.getValue(), type4, zzb3.zza(entry.getKey())));
                    }
                    return (T)hashMap;
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    throw zzeym.zzc(zzb3, "Collections are not supported, please use Lists instead");
                }
                Map<String, Object> map = zzeym.zzc(object4, zzb3);
                zza zza2 = zzeym.zza(clazz);
                HashMap hashMap = new HashMap();
                TypeVariable<Class<T>>[] typeVariableArray = zza2.zza.getTypeParameters();
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                if (typeArray.length != typeVariableArray.length) {
                    throw new IllegalStateException("Mismatched lengths for type variables and actual types");
                }
                for (int i = 0; i < typeVariableArray.length; ++i) {
                    hashMap.put(typeVariableArray[i], typeArray[i]);
                }
                return zza2.zza(map, hashMap, zzb3);
            }
            if (type instanceof Class) {
                return zzeym.zza(object, (Class)type, zzb2);
            }
            if (type instanceof WildcardType) {
                if (((WildcardType)type).getLowerBounds().length > 0) {
                    throw zzeym.zzc(zzb2, "Generic lower-bounded wildcard types are not supported");
                }
                object3 = ((WildcardType)type).getUpperBounds();
                boolean bl = ((Type[])object3).length > 0;
                String string = String.valueOf(type);
                zzeym.zzb(bl, new StringBuilder(35 + String.valueOf(string).length()).append("Unexpected type bounds on wildcard ").append(string).toString());
                type = object3[0];
                continue;
            }
            if (!(type instanceof TypeVariable)) break;
            object3 = String.valueOf(type);
            object2 = ((TypeVariable)type).getBounds();
            zzeym.zzb(((Type[])object2).length > 0, new StringBuilder(40 + String.valueOf(object3).length()).append("Unexpected type bounds on type variable ").append((String)object3).toString());
            type = object2[0];
        }
        if (type instanceof GenericArrayType) {
            throw zzeym.zzc(zzb2, "Generic Arrays are not supported, please use Lists instead");
        }
        object2 = String.valueOf(type);
        throw zzeym.zzc(zzb2, new StringBuilder(26 + String.valueOf(object2).length()).append("Unknown type encountered: ").append((String)object2).toString());
    }

    private static <T> T zza(Object object, Class<T> clazz, zzb zzb2) {
        if (object == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            zzb zzb3 = zzb2;
            Class<T> clazz2 = clazz;
            Object object2 = object;
            if (Integer.class.isAssignableFrom(clazz2) || Integer.TYPE.isAssignableFrom(clazz2)) {
                zzb zzb4 = zzb3;
                Object object3 = object2;
                if (object3 instanceof Integer) {
                    return (T)((Integer)object3);
                }
                if (object3 instanceof Long || object3 instanceof Double) {
                    double d;
                    double d2 = ((Number)object3).doubleValue();
                    if (d >= -2.147483648E9 && d2 <= 2.147483647E9) {
                        return (T)Integer.valueOf(((Number)object3).intValue());
                    }
                    throw zzeym.zzc(zzb4, new StringBuilder(124).append("Numeric value out of 32-bit integer range: ").append(d2).append(". Did you mean to use a long or double instead of an int?").toString());
                }
                String string = object3.getClass().getName();
                throw zzeym.zzc(zzb4, new StringBuilder(41 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to int").toString());
            }
            if (Boolean.class.isAssignableFrom(clazz2) || Boolean.TYPE.isAssignableFrom(clazz2)) {
                zzb zzb5 = zzb3;
                Object object4 = object2;
                if (object4 instanceof Boolean) {
                    return (T)((Boolean)object4);
                }
                String string = object4.getClass().getName();
                throw zzeym.zzc(zzb5, new StringBuilder(43 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to boolean").toString());
            }
            if (Double.class.isAssignableFrom(clazz2) || Double.TYPE.isAssignableFrom(clazz2)) {
                return (T)zzeym.zzd(object2, zzb3);
            }
            if (Long.class.isAssignableFrom(clazz2) || Long.TYPE.isAssignableFrom(clazz2)) {
                zzb zzb6 = zzb3;
                Object object5 = object2;
                if (object5 instanceof Integer) {
                    return (T)Long.valueOf(((Integer)object5).longValue());
                }
                if (object5 instanceof Long) {
                    return (T)((Long)object5);
                }
                if (object5 instanceof Double) {
                    Double d;
                    Double d3 = (Double)object5;
                    if (d >= -9.223372036854776E18 && d3 <= 9.223372036854776E18) {
                        return (T)Long.valueOf(d3.longValue());
                    }
                    String string = String.valueOf(d3);
                    throw zzeym.zzc(zzb6, new StringBuilder(89 + String.valueOf(string).length()).append("Numeric value out of 64-bit long range: ").append(string).append(". Did you mean to use a double instead of a long?").toString());
                }
                String string = object5.getClass().getName();
                throw zzeym.zzc(zzb6, new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to long").toString());
            }
            if (Float.class.isAssignableFrom(clazz2) || Float.TYPE.isAssignableFrom(clazz2)) {
                return (T)Float.valueOf(zzeym.zzd(object2, zzb3).floatValue());
            }
            if (Short.class.isAssignableFrom(clazz2) || Short.TYPE.isAssignableFrom(clazz2)) {
                throw zzeym.zzc(zzb3, "Deserializing to shorts is not supported");
            }
            if (Byte.class.isAssignableFrom(clazz2) || Byte.TYPE.isAssignableFrom(clazz2)) {
                throw zzeym.zzc(zzb3, "Deserializing to bytes is not supported");
            }
            if (Character.class.isAssignableFrom(clazz2) || Character.TYPE.isAssignableFrom(clazz2)) {
                throw zzeym.zzc(zzb3, "Deserializing to chars is not supported");
            }
            String string = String.valueOf(clazz2);
            throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unknown primitive type: ").append(string).toString());
        }
        if (String.class.isAssignableFrom(clazz)) {
            zzb zzb7 = zzb2;
            Object object6 = object;
            if (object6 instanceof String) {
                return (T)((String)object6);
            }
            String string = object6.getClass().getName();
            throw zzeym.zzc(zzb7, new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to String").toString());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            zzb zzb8 = zzb2;
            Object object7 = object;
            if (object7 instanceof Date) {
                return (T)((Date)object7);
            }
            String string = object7.getClass().getName();
            throw zzeym.zzc(zzb8, new StringBuilder(40 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to Date").toString());
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            zzb zzb9 = zzb2;
            Object object8 = object;
            if (object8 instanceof Blob) {
                return (T)((Blob)object8);
            }
            String string = object8.getClass().getName();
            throw zzeym.zzc(zzb9, new StringBuilder(40 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to Blob").toString());
        }
        if (GeoPoint.class.isAssignableFrom(clazz)) {
            zzb zzb10 = zzb2;
            Object object9 = object;
            if (object9 instanceof GeoPoint) {
                return (T)((GeoPoint)object9);
            }
            String string = object9.getClass().getName();
            throw zzeym.zzc(zzb10, new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to GeoPoint").toString());
        }
        if (DocumentReference.class.isAssignableFrom(clazz)) {
            zzb zzb11 = zzb2;
            Object object10 = object;
            if (object10 instanceof DocumentReference) {
                return (T)((DocumentReference)object10);
            }
            String string = object10.getClass().getName();
            throw zzeym.zzc(zzb11, new StringBuilder(53 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to DocumentReference").toString());
        }
        if (clazz.isArray()) {
            throw zzeym.zzc(zzb2, "Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            String string = clazz.getName();
            throw zzeym.zzc(zzb2, new StringBuilder(75 + String.valueOf(string).length()).append("Class ").append(string).append(" has generic type parameters, please use GenericTypeIndicator instead").toString());
        }
        if (clazz.equals(Object.class)) {
            return (T)object;
        }
        if (clazz.isEnum()) {
            return zzeym.zzb(object, clazz, zzb2);
        }
        zzb zzb12 = zzb2;
        Class<T> clazz3 = clazz;
        Object object11 = object;
        zza zza2 = zzeym.zza(clazz3);
        if (object11 instanceof Map) {
            zzb zzb13 = zzb12;
            Map<String, Object> map = zzeym.zzc(object11, zzb12);
            return zza2.zza(map, Collections.emptyMap(), zzb13);
        }
        String string = object11.getClass().getName();
        String string2 = clazz3.getName();
        throw zzeym.zzc(zzb12, new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't convert object of type ").append(string).append(" to type ").append(string2).toString());
    }

    private static <T> T zzb(Object object, Class<T> clazz, zzb zzb2) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = clazz.getName();
                throw zzeym.zzc(zzb2, new StringBuilder(42 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not find enum value of ").append(string2).append(" for value \"").append(string).append("\"").toString());
            }
        }
        String string = String.valueOf(clazz);
        String string3 = String.valueOf(object.getClass());
        throw zzeym.zzc(zzb2, new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Expected a String while deserializing to enum ").append(string).append(" but got a ").append(string3).toString());
    }

    private static <T> zza<T> zza(Class<T> clazz) {
        zza<T> zza2 = (zza<T>)zza.get(clazz);
        if (zza2 == null) {
            zza2 = new zza<T>(clazz);
            zza.put(clazz, zza2);
        }
        return zza2;
    }

    private static Map<String, Object> zzc(Object object, zzb zzb2) {
        if (object instanceof Map) {
            return (Map)object;
        }
        String string = String.valueOf(object.getClass());
        throw zzeym.zzc(zzb2, new StringBuilder(46 + String.valueOf(string).length()).append("Expected a Map while deserializing, but got a ").append(string).toString());
    }

    private static Double zzd(Object object, zzb zzb2) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            Double d = ((Long)object).doubleValue();
            if (d.longValue() == l.longValue()) {
                return d;
            }
            String string = String.valueOf(object);
            throw zzeym.zzc(zzb2, new StringBuilder(97 + String.valueOf(string).length()).append("Loss of precision while converting number to double: ").append(string).append(". Did you mean to use a 64-bit long instead?").toString());
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = object.getClass().getName();
        throw zzeym.zzc(zzb2, new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to double").toString());
    }

    private static RuntimeException zzb(zzb zzb2, String string) {
        String string2 = String.valueOf(string);
        String string3 = string = string2.length() != 0 ? "Could not serialize object. ".concat(string2) : new String("Could not serialize object. ");
        if (zzb2.zza() > 0) {
            String string4 = string;
            String string5 = zzb2.toString();
            string = new StringBuilder(20 + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string4).append(" (found in field '").append(string5).append("')").toString();
        }
        return new RuntimeException(string);
    }

    private static RuntimeException zzc(zzb zzb2, String string) {
        String string2 = String.valueOf(string);
        String string3 = string = string2.length() != 0 ? "Could not deserialize object. ".concat(string2) : new String("Could not deserialize object. ");
        if (zzb2.zza() > 0) {
            String string4 = string;
            String string5 = zzb2.toString();
            string = new StringBuilder(20 + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string4).append(" (found in field '").append(string5).append("')").toString();
        }
        return new RuntimeException(string);
    }

    static final class zzb {
        private final int zzb;
        private final zzb zzc;
        private final String zzd;
        static final zzb zza = new zzb(null, null, 0);

        private zzb(zzb zzb2, String string, int n) {
            this.zzc = zzb2;
            this.zzd = string;
            this.zzb = n;
        }

        final int zza() {
            return this.zzb;
        }

        public final zzb zza(String string) {
            return new zzb(this, string, this.zzb + 1);
        }

        public final String toString() {
            if (this.zzb == 0) {
                return "";
            }
            if (this.zzb == 1) {
                return this.zzd;
            }
            String string = this.zzc.toString();
            String string2 = this.zzd;
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
        }
    }

    static final class zza<T> {
        private final Class<T> zza;
        private final Constructor<T> zzb;
        private final boolean zzc;
        private final boolean zzd;
        private final Map<String, String> zze;
        private final Map<String, Method> zzf;
        private final Map<String, Method> zzg;
        private final Map<String, Field> zzh;
        private final HashSet<String> zzi;

        /*
         * WARNING - void declaration
         */
        public zza(Class<T> clazz) {
            Object object;
            Object object2;
            Object object3;
            Constructor<T> constructor;
            this.zza = clazz;
            this.zzc = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.zzd = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.zze = new HashMap<String, String>();
            this.zzg = new HashMap<String, Method>();
            this.zzf = new HashMap<String, Method>();
            this.zzh = new HashMap<String, Field>();
            this.zzi = new HashSet();
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = null;
            }
            this.zzb = constructor;
            for (Method accessibleObject : clazz.getMethods()) {
                object3 = accessibleObject;
                if (!(!accessibleObject.getName().startsWith("get") && !((Method)object3).getName().startsWith("is") ? false : (((Method)object3).getDeclaringClass().equals(Object.class) ? false : (!Modifier.isPublic(((Method)object3).getModifiers()) ? false : (Modifier.isStatic(((Method)object3).getModifiers()) ? false : (((Method)object3).getReturnType().equals(Void.TYPE) ? false : (((Method)object3).getParameterTypes().length != 0 ? false : !((AccessibleObject)object3).isAnnotationPresent(Exclude.class)))))))) continue;
                String string = com.google.android.gms.internal.zzeym$zza.zza(accessibleObject);
                this.zza(string);
                accessibleObject.setAccessible(true);
                if (this.zzf.containsKey(string)) {
                    String string2 = accessibleObject.getName();
                    String string3 = clazz.getName();
                    throw new RuntimeException(new StringBuilder(45 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Found conflicting getters for name ").append(string2).append(" on class ").append(string3).toString());
                }
                this.zzf.put(string, accessibleObject);
                object2 = accessibleObject;
                object3 = this;
                if (!((AccessibleObject)object2).isAnnotationPresent(ServerTimestamp.class)) continue;
                object = ((Method)object2).getReturnType();
                if (object != Date.class) {
                    String string4 = ((Method)object2).getName();
                    String string5 = String.valueOf(object);
                    throw new IllegalArgumentException(new StringBuilder(72 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Method ").append(string4).append(" is annotated with @ServerTimestamp but returns ").append(string5).append(" instead of Date.").toString());
                }
                ((zza)object3).zzi.add(com.google.android.gms.internal.zzeym$zza.zza((Method)object2));
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                object3 = accessibleObject;
                if (!(((Field)accessibleObject).getDeclaringClass().equals(Object.class) ? false : (!Modifier.isPublic(((Field)object3).getModifiers()) ? false : (Modifier.isStatic(((Field)object3).getModifiers()) ? false : (Modifier.isTransient(((Field)object3).getModifiers()) ? false : !((AccessibleObject)object3).isAnnotationPresent(Exclude.class)))))) continue;
                String string = com.google.android.gms.internal.zzeym$zza.zzb((Field)accessibleObject);
                this.zza(string);
                this.zza((Field)accessibleObject);
            }
            Object object5 = clazz;
            do {
                void var6_13;
                String string;
                int n;
                AccessibleObject[] accessibleObjectArray = ((Class)object5).getDeclaredMethods();
                int n2 = accessibleObjectArray.length;
                boolean bl = false;
                while (n < n2) {
                    String string6;
                    Method method = accessibleObjectArray[n];
                    object3 = method;
                    if ((!method.getName().startsWith("set") ? false : (((Method)object3).getDeclaringClass().equals(Object.class) ? false : (Modifier.isStatic(((Method)object3).getModifiers()) ? false : (!((Method)object3).getReturnType().equals(Void.TYPE) ? false : (((Method)object3).getParameterTypes().length != 1 ? false : !((AccessibleObject)object3).isAnnotationPresent(Exclude.class)))))) && (string6 = this.zze.get((string = com.google.android.gms.internal.zzeym$zza.zza(method)).toLowerCase(Locale.US))) != null) {
                        Object object4;
                        if (!string6.equals(string)) {
                            object4 = ((Class)object5).getName();
                            String string7 = method.getName();
                            throw new RuntimeException(new StringBuilder(51 + String.valueOf(object4).length() + String.valueOf(string7).length()).append("Found setter on ").append((String)object4).append(" with invalid case-sensitive name: ").append(string7).toString());
                        }
                        object4 = this.zzg.get(string);
                        if (object4 == null) {
                            method.setAccessible(true);
                            this.zzg.put(string, method);
                            object3 = method;
                            if (((AccessibleObject)object3).isAnnotationPresent(ServerTimestamp.class)) {
                                object = ((Method)object3).getName();
                                throw new IllegalArgumentException(new StringBuilder(134 + String.valueOf(object).length()).append("Method ").append((String)object).append(" is annotated with @ServerTimestamp but should not be. @ServerTimestamp can only be applied to fields and getters, not setters.").toString());
                            }
                        } else {
                            object2 = object4;
                            object3 = method;
                            zzeym.zzb(((Method)object3).getDeclaringClass().isAssignableFrom(((Method)object2).getDeclaringClass()), "Expected override from a base class");
                            zzeym.zzb(((Method)object3).getReturnType().equals(Void.TYPE), "Expected void return type");
                            zzeym.zzb(((Method)object2).getReturnType().equals(Void.TYPE), "Expected void return type");
                            object = ((Method)object3).getParameterTypes();
                            Class<?>[] classArray = ((Method)object2).getParameterTypes();
                            zzeym.zzb(((Class<?>[])object).length == 1, "Expected exactly one parameter");
                            zzeym.zzb(classArray.length == 1, "Expected exactly one parameter");
                            if (!(((Method)object3).getName().equals(((Method)object2).getName()) && object[0].equals(classArray[0]))) {
                                if (object5 == clazz) {
                                    String string8 = clazz.getName();
                                    String string9 = method.getName();
                                    throw new RuntimeException(new StringBuilder(47 + String.valueOf(string8).length() + String.valueOf(string9).length()).append("Class ").append(string8).append(" has multiple setter overloads with name ").append(string9).toString());
                                }
                                String string10 = method.getName();
                                String string11 = ((Method)object4).getName();
                                String string12 = ((Method)object4).getDeclaringClass().getName();
                                throw new RuntimeException(new StringBuilder(67 + String.valueOf(string10).length() + String.valueOf(string11).length() + String.valueOf(string12).length()).append("Found conflicting setters with name: ").append(string10).append(" (conflicts with ").append(string11).append(" defined on ").append(string12).append(")").toString());
                            }
                        }
                    }
                    ++n;
                }
                accessibleObjectArray = ((Class)object5).getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (var6_13 < n2) {
                    AccessibleObject accessibleObject = accessibleObjectArray[var6_13];
                    string = com.google.android.gms.internal.zzeym$zza.zzb((Field)accessibleObject);
                    if (this.zze.containsKey(string.toLowerCase(Locale.US)) && !this.zzh.containsKey(string)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.zzh.put(string, (Field)accessibleObject);
                        this.zza((Field)accessibleObject);
                    }
                    ++var6_13;
                }
            } while ((object5 = ((Class)object5).getSuperclass()) != null && !object5.equals(Object.class));
            if (this.zze.isEmpty()) {
                String string = String.valueOf(clazz.getName());
                throw new RuntimeException(string.length() != 0 ? "No properties to serialize found on class ".concat(string) : new String("No properties to serialize found on class "));
            }
        }

        private final void zza(String string) {
            String string2 = this.zze.put(string.toLowerCase(Locale.US), string);
            if (string2 != null && !string.equals(string2)) {
                String string3 = String.valueOf(string.toLowerCase(Locale.US));
                throw new RuntimeException(string3.length() != 0 ? "Found two getters or fields with conflicting case sensitivity for property: ".concat(string3) : new String("Found two getters or fields with conflicting case sensitivity for property: "));
            }
        }

        public final T zza(Map<String, Object> map, Map<TypeVariable<Class<T>>, Type> map2, zzb zzb2) {
            T t;
            if (this.zzb == null) {
                String string = this.zza.getName();
                throw zzeym.zzc(zzb2, new StringBuilder(122 + String.valueOf(string).length()).append("Class ").append(string).append(" does not define a no-argument constructor. If you are using ProGuard, make sure these constructors are not stripped").toString());
            }
            try {
                t = this.zzb.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object;
                Object object2;
                Object object3;
                String string = entry.getKey();
                zzb zzb3 = zzb2.zza(string);
                if (this.zzg.containsKey(string)) {
                    object3 = this.zzg.get(string);
                    object2 = ((Method)object3).getGenericParameterTypes();
                    if (((Type[])object2).length != 1) {
                        throw zzeym.zzc(zzb3, "Setter does not have exactly one parameter");
                    }
                    object = com.google.android.gms.internal.zzeym$zza.zza(object2[0], map2);
                    Object object4 = zzeym.zzb(entry.getValue(), (Type)object, zzb3);
                    try {
                        ((Method)object3).invoke(t, object4);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new RuntimeException(reflectiveOperationException);
                    }
                }
                if (this.zzh.containsKey(string)) {
                    object3 = this.zzh.get(string);
                    object2 = com.google.android.gms.internal.zzeym$zza.zza(((Field)object3).getGenericType(), map2);
                    object = zzeym.zzb(entry.getValue(), (Type)object2, zzb3);
                    try {
                        ((Field)object3).set(t, object);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
                object2 = this.zza.getName();
                object3 = new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(object2).length()).append("No setter/field for ").append(string).append(" found on class ").append((String)object2).toString();
                if (this.zze.containsKey(string.toLowerCase(Locale.US))) {
                    object3 = String.valueOf(object3).concat(" (fields/setters are case sensitive!)");
                }
                if (this.zzc) {
                    throw new RuntimeException((String)object3);
                }
                if (!this.zzd) continue;
                zzeyz.zza(zzeym.class.getSimpleName(), (String)object3, new Object[0]);
            }
            return t;
        }

        private static Type zza(Type type, Map<TypeVariable<Class<T>>, Type> map) {
            if (type instanceof TypeVariable) {
                Type type2 = map.get(type);
                if (type2 == null) {
                    String string = String.valueOf(type);
                    throw new IllegalStateException(new StringBuilder(23 + String.valueOf(string).length()).append("Could not resolve type ").append(string).toString());
                }
                return type2;
            }
            return type;
        }

        public final Map<String, Object> zza(T t, zzb zzb2) {
            if (!this.zza.isAssignableFrom(t.getClass())) {
                String string = String.valueOf(t.getClass());
                String string2 = String.valueOf(this.zza);
                throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't serialize object of class ").append(string).append(" with BeanMapper for class ").append(string2).toString());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : this.zze.values()) {
                Object object;
                Object object2;
                if (this.zzf.containsKey(string)) {
                    object2 = this.zzf.get(string);
                    try {
                        object = ((Method)object2).invoke(t, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new RuntimeException(reflectiveOperationException);
                    }
                }
                object2 = this.zzh.get(string);
                if (object2 == null) {
                    String string3 = String.valueOf(string);
                    throw new IllegalStateException(string3.length() != 0 ? "Bean property without field or getter: ".concat(string3) : new String("Bean property without field or getter: "));
                }
                try {
                    object = ((Field)object2).get(t);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                object2 = this.zzi.contains(string) && object == null ? FieldValue.serverTimestamp() : zzeym.zzb(object, zzb2.zza(string));
                hashMap.put(string, object2);
            }
            return hashMap;
        }

        private final void zza(Field field) {
            if (field.isAnnotationPresent(ServerTimestamp.class)) {
                Class<?> clazz = field.getType();
                if (clazz != Date.class) {
                    String string = field.getName();
                    String string2 = String.valueOf(clazz);
                    throw new IllegalArgumentException(new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Field ").append(string).append(" is annotated with @ServerTimestamp but is ").append(string2).append(" instead of Date.").toString());
                }
                this.zzi.add(com.google.android.gms.internal.zzeym$zza.zzb(field));
            }
        }

        private static String zzb(Field field) {
            String string = com.google.android.gms.internal.zzeym$zza.zza(field);
            if (string != null) {
                return string;
            }
            return field.getName();
        }

        private static String zza(Method method) {
            int n;
            String string = com.google.android.gms.internal.zzeym$zza.zza((AccessibleObject)method);
            if (string != null) {
                return string;
            }
            String string2 = method.getName();
            String[] stringArray = new String[]{"get", "set", "is"};
            String string3 = null;
            String[] stringArray2 = stringArray;
            for (n = 0; n < 3; ++n) {
                String string4 = stringArray2[n];
                if (!string2.startsWith(string4)) continue;
                string3 = string4;
            }
            if (string3 == null) {
                String string5 = String.valueOf(string2);
                throw new IllegalArgumentException(string5.length() != 0 ? "Unknown Bean prefix for method: ".concat(string5) : new String("Unknown Bean prefix for method: "));
            }
            char[] cArray = string2.substring(string3.length()).toCharArray();
            for (n = 0; n < cArray.length && Character.isUpperCase(cArray[n]); ++n) {
                cArray[n] = Character.toLowerCase(cArray[n]);
            }
            return new String(cArray);
        }

        private static String zza(AccessibleObject accessibleObject) {
            if (accessibleObject.isAnnotationPresent(PropertyName.class)) {
                return accessibleObject.getAnnotation(PropertyName.class).zza();
            }
            return null;
        }
    }
}

