/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyg;
import com.google.android.gms.internal.zzeyh;
import com.google.android.gms.internal.zzeyi;
import com.google.android.gms.internal.zzeyj;
import com.google.android.gms.internal.zzeyk;
import com.google.android.gms.internal.zzeyz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class zzeyf {
    private final Thread zza;
    private final ScheduledThreadPoolExecutor zzb;

    public static <TResult> Task<TResult> zza(Executor executor, Callable<Task<TResult>> callable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(new zzeyg(callable, executor, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    public zzeyf() {
        zza zza2 = new zza(this, null);
        this.zza = Executors.defaultThreadFactory().newThread(zza2);
        this.zza.setName("FirestoreWorker");
        this.zza.setDaemon(true);
        this.zza.setUncaughtExceptionHandler(new zzeyh(this));
        this.zzb = new zzeyk(this, 1, zza2);
        this.zzb.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final Executor zza() {
        return this.zzb;
    }

    public final void zzb() {
        Thread thread = Thread.currentThread();
        if (this.zza != thread) {
            zzeye.zza("We are running on the wrong thread. Expected to be on the AsyncQueue thread %s/%d but was %s/%d", this.zza.getName(), this.zza.getId(), thread.getName(), thread.getId());
        }
    }

    public final void zza(Runnable runnable) {
        try {
            this.zzb.execute(runnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            zzeyz.zza(zzeyf.class.getSimpleName(), "Refused to enqueue task after panic", new Object[0]);
            return;
        }
    }

    public final void zza(Throwable throwable) {
        this.zzb.shutdownNow();
        new Handler(Looper.getMainLooper()).post((Runnable)new zzeyi(throwable));
    }

    public final ScheduledFuture<?> zza(Runnable runnable, long l) {
        return this.zzb.schedule(runnable, l, TimeUnit.MILLISECONDS);
    }

    final /* synthetic */ void zza(Thread thread, Throwable throwable) {
        this.zza(throwable);
    }

    final class zza
    implements Runnable,
    ThreadFactory {
        private final CountDownLatch zza = new CountDownLatch(1);
        private Runnable zzb;
        private /* synthetic */ zzeyf zzc;

        private zza(zzeyf zzeyf2) {
            this.zzc = zzeyf2;
        }

        @Override
        public final void run() {
            try {
                this.zza.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.zzb.run();
        }

        @Override
        public final Thread newThread(@NonNull Runnable runnable) {
            zzeye.zza(this.zzb == null, "Only one thread may be created in an AsyncQueue.", new Object[0]);
            this.zzb = runnable;
            this.zza.countDown();
            return this.zzc.zza;
        }

        /* synthetic */ zza(zzeyf zzeyf2, zzeyj zzeyj2) {
            this(zzeyf2);
        }
    }
}

