/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.internal.zzeqf;
import com.google.android.gms.internal.zzesj;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetg;
import com.google.android.gms.internal.zzeth;
import com.google.android.gms.internal.zzetm;
import com.google.android.gms.internal.zzeto;
import com.google.android.gms.internal.zzeub;
import com.google.android.gms.internal.zzeuc;
import com.google.android.gms.internal.zzeue;
import com.google.android.gms.internal.zzeum;
import com.google.android.gms.internal.zzeus;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyz;
import com.google.android.gms.internal.zzezc;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class zzetz
extends zzetg {
    private final zzeub zzb;
    private final zzesj zzc;
    private SQLiteDatabase zzd;
    private boolean zze;

    @VisibleForTesting
    private static String zza(String string, zzeus zzeus2) {
        try {
            String string2 = URLEncoder.encode(string, "utf-8");
            String string3 = URLEncoder.encode(zzeus2.zza(), "utf-8");
            String string4 = URLEncoder.encode(zzeus2.zzb(), "utf-8");
            return new StringBuilder(12 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("firestore.").append(string2).append(".").append(string3).append(".").append(string4).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public zzetz(Context context, String string, zzeus zzeus2, zzesj zzesj2) {
        String string2 = zzetz.zza(string, zzeus2);
        this.zzb = new zzeub(context, string2);
        this.zzc = zzesj2;
    }

    @Override
    public final void zza() {
        zzeye.zza(!this.zze, "SQLitePersistence double-started!", new Object[0]);
        this.zze = true;
        try {
            this.zzd = this.zzb.getWritableDatabase();
            return;
        }
        catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
            throw new RuntimeException("Failed to gain exclusive lock to the Firestore client's offline persistence. This generally means you are using Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Firestore in your Application class. If you are intentionally using Firestore from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.", sQLiteDatabaseLockedException);
        }
    }

    @Override
    final zzete zza(zzeqf zzeqf2) {
        return new zzeto(this, this.zzc, zzeqf2);
    }

    @Override
    final zzeth zzb() {
        return new zzeue(this, this.zzc);
    }

    @Override
    final zzetm zzc() {
        return new zzeum(this, this.zzc);
    }

    @Override
    final void zza(String string, Runnable runnable) {
        try {
            zzeyz.zzb(zza, "Starting transaction: %s", string);
            this.zzd.beginTransaction();
            runnable.run();
            this.zzd.setTransactionSuccessful();
            return;
        }
        finally {
            this.zzd.endTransaction();
        }
    }

    @Override
    final <T> T zza(String string, zzezc<T> zzezc2) {
        try {
            zzeyz.zzb(zza, "Starting transaction: %s", string);
            this.zzd.beginTransaction();
            T t = zzezc2.zza();
            this.zzd.setTransactionSuccessful();
            T t2 = t;
            return t2;
        }
        finally {
            this.zzd.endTransaction();
        }
    }

    final void zza(String string, Object ... objectArray) {
        this.zzd.execSQL(string, objectArray);
    }

    final SQLiteStatement zza(String string) {
        return this.zzd.compileStatement(string);
    }

    static int zza(SQLiteStatement sQLiteStatement, Object ... objectArray) {
        sQLiteStatement.clearBindings();
        zzetz.zza((SQLiteProgram)sQLiteStatement, objectArray);
        return sQLiteStatement.executeUpdateDelete();
    }

    final zzeuc zzb(String string) {
        return new zzeuc(this, string, null);
    }

    private static void zza(SQLiteProgram sQLiteProgram, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                sQLiteProgram.bindNull(i + 1);
                continue;
            }
            if (object instanceof String) {
                sQLiteProgram.bindString(i + 1, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                sQLiteProgram.bindLong(i + 1, (long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                sQLiteProgram.bindLong(i + 1, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                sQLiteProgram.bindDouble(i + 1, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof byte[]) {
                sQLiteProgram.bindBlob(i + 1, (byte[])object);
                continue;
            }
            throw zzeye.zza("Unknown argument %s of type %s", object, object.getClass());
        }
    }

    static /* synthetic */ SQLiteDatabase zza(zzetz zzetz2) {
        return zzetz2.zzd;
    }

    static /* synthetic */ void zza(zzetz zzetz2, SQLiteProgram sQLiteProgram, Object[] objectArray) {
        zzetz.zza(sQLiteProgram, objectArray);
    }
}

