/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeqf;
import com.google.android.gms.internal.zzerf;
import com.google.android.gms.internal.zzesf;
import com.google.android.gms.internal.zzesg;
import com.google.android.gms.internal.zzesj;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetp;
import com.google.android.gms.internal.zzetq;
import com.google.android.gms.internal.zzetr;
import com.google.android.gms.internal.zzets;
import com.google.android.gms.internal.zzett;
import com.google.android.gms.internal.zzetu;
import com.google.android.gms.internal.zzetv;
import com.google.android.gms.internal.zzetw;
import com.google.android.gms.internal.zzetx;
import com.google.android.gms.internal.zzety;
import com.google.android.gms.internal.zzetz;
import com.google.android.gms.internal.zzeuw;
import com.google.android.gms.internal.zzevd;
import com.google.android.gms.internal.zzevk;
import com.google.android.gms.internal.zzevl;
import com.google.android.gms.internal.zzewm;
import com.google.android.gms.internal.zzeyc;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzfgs;
import com.google.android.gms.internal.zzfie;
import com.google.firebase.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzeto
implements zzete {
    private final zzetz zza;
    private final zzesj zzb;
    private final String zzc;
    private int zzd;
    private int zze;
    private zzfgs zzf;
    private zzesg zzg;

    zzeto(zzetz zzetz2, zzesj zzesj2, zzeqf zzeqf2) {
        this.zza = zzetz2;
        this.zzb = zzesj2;
        this.zzc = zzeqf2.zzb() ? zzeqf2.zza() : "";
        this.zzf = zzeyc.zzc;
    }

    @Override
    public final void zza() {
        zzeto zzeto2 = this;
        ArrayList arrayList = new ArrayList();
        zzeto2.zza.zzb("SELECT uid FROM mutation_queues").zza(new zzetq(arrayList));
        zzeto2.zzd = 0;
        ArrayList arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList2.get(i);
            String string = (String)e;
            zzeto2.zza.zzb("SELECT MAX(batch_id) FROM mutations WHERE uid = ?").zza(string).zza(new zzetr(zzeto2));
        }
        ++zzeto2.zzd;
        this.zze = -1;
        if (this.zza.zzb("SELECT last_acknowledged_batch_id, last_stream_token FROM mutation_queues WHERE uid = ?").zza(this.zzc).zzb(new zzetp(this)) == 0) {
            this.zzg();
            return;
        }
        if (this.zze >= this.zzd) {
            zzeye.zza(this.zzf(), "Reset nextBatchId is only possible when the queue is empty", new Object[0]);
            this.zze = -1;
            this.zzg();
        }
    }

    private final boolean zzf() {
        return this.zza.zzb("SELECT batch_id FROM mutations WHERE uid = ? LIMIT 1").zza(this.zzc).zza();
    }

    @Override
    public final int zzb() {
        return this.zze;
    }

    @Override
    public final void zza(zzevl zzevl2, zzfgs zzfgs2) {
        int n = zzevl2.zzb();
        zzeye.zza(n > this.zze, "Mutation batchIds must be acknowledged in order", new Object[0]);
        this.zze = n;
        this.zzf = (zzfgs)zzbq.zza((Object)zzfgs2);
        this.zzg();
    }

    @Override
    public final zzfgs zzc() {
        return this.zzf;
    }

    @Override
    public final void zza(zzfgs zzfgs2) {
        this.zzf = (zzfgs)zzbq.zza((Object)zzfgs2);
        this.zzg();
    }

    private final void zzg() {
        this.zza.zza("INSERT OR REPLACE INTO mutation_queues (uid, last_acknowledged_batch_id, last_stream_token) VALUES (?, ?, ?)", this.zzc, this.zze, this.zzf.zzc());
    }

    @Override
    public final zzevl zza(Timestamp timestamp, List<zzevk> list) {
        int n = this.zzd++;
        zzevl zzevl2 = new zzevl(n, timestamp, list);
        zzewm zzewm2 = this.zzb.zza(zzevl2);
        this.zza.zza("INSERT INTO mutations (uid, batch_id, mutations) VALUES (?, ?, ?)", this.zzc, n, zzewm2.zzq());
        HashSet<zzeuw> hashSet = new HashSet<zzeuw>();
        SQLiteStatement sQLiteStatement = this.zza.zza("INSERT INTO document_mutations (uid, path, batch_id) VALUES (?, ?, ?)");
        Iterator<zzevk> iterator = list.iterator();
        while (iterator.hasNext()) {
            zzeuw zzeuw2 = iterator.next().zza();
            if (!hashSet.add(zzeuw2)) continue;
            String string = zzesf.zza(zzeuw2.zzd());
            zzetz.zza(sQLiteStatement, this.zzc, string, n);
        }
        return zzevl2;
    }

    @Override
    public final zzevl zza(int n) {
        return (zzevl)this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? AND batch_id = ?").zza(this.zzc, n).zza(new zzets(this));
    }

    @Override
    public final zzevl zzb(int n) {
        return (zzevl)this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? AND batch_id > ? ORDER BY batch_id ASC LIMIT 1").zza(this.zzc, n).zza(new zzett(this));
    }

    @Override
    public final List<zzevl> zzd() {
        ArrayList<zzevl> arrayList = new ArrayList<zzevl>();
        this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? ORDER BY batch_id ASC").zza(this.zzc).zza(new zzetu(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzevl> zzc(int n) {
        ArrayList<zzevl> arrayList = new ArrayList<zzevl>();
        this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? AND batch_id <= ? ORDER BY batch_id ASC").zza(this.zzc, n).zza(new zzetv(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzevl> zzb(zzeuw zzeuw2) {
        String string = zzesf.zza(zzeuw2.zzd());
        ArrayList<zzevl> arrayList = new ArrayList<zzevl>();
        this.zza.zzb("SELECT m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path = ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id").zza(this.zzc, string).zza(new zzetw(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzevl> zza(zzerf zzerf2) {
        zzevd zzevd2 = zzerf2.zza();
        int n = zzevd2.zzg() + 1;
        String string = zzesf.zza(zzevd2);
        String string2 = zzesf.zzb(string);
        ArrayList<zzevl> arrayList = new ArrayList<zzevl>();
        this.zza.zzb("SELECT dm.batch_id, dm.path, m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path >= ? AND dm.path < ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").zza(this.zzc, string, string2).zza(new zzetx(this, arrayList, n));
        return arrayList;
    }

    @Override
    public final void zza(List<zzevl> list) {
        SQLiteStatement sQLiteStatement = this.zza.zza("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        SQLiteStatement sQLiteStatement2 = this.zza.zza("DELETE FROM document_mutations WHERE uid = ? AND path = ? AND batch_id = ?");
        for (zzevl zzevl2 : list) {
            int n = zzevl2.zzb();
            zzeye.zza(zzetz.zza(sQLiteStatement, this.zzc, n) != 0, "Mutation batch (%s, %d) did not exist", this.zzc, zzevl2.zzb());
            Iterator<zzevk> iterator = zzevl2.zzf().iterator();
            while (iterator.hasNext()) {
                zzeuw zzeuw2 = iterator.next().zza();
                String string = zzesf.zza(zzeuw2.zzd());
                zzetz.zza(sQLiteStatement2, this.zzc, string, n);
                if (this.zzg == null) continue;
                this.zzg.zza(zzeuw2);
            }
        }
    }

    @Override
    public final void zze() {
        if (!this.zzf()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.zza.zzb("SELECT path FROM document_mutations WHERE uid = ?").zza(this.zzc).zza(new zzety(arrayList));
        zzeye.zza(arrayList.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty. Dangling keys: %s", arrayList);
    }

    private final zzevl zza(byte[] byArray) {
        try {
            return this.zzb.zza(zzewm.zza(byArray));
        }
        catch (zzfie zzfie2) {
            throw zzeye.zza("MutationBatch failed to parse: %s", new Object[]{zzfie2});
        }
    }

    @Override
    public final void zza(zzesg zzesg2) {
        this.zzg = zzesg2;
    }

    @Override
    public final boolean zza(zzeuw zzeuw2) {
        String string = zzesf.zza(zzeuw2.zzd());
        return !this.zza.zzb("SELECT batch_id FROM document_mutations WHERE uid = ? AND path = ? LIMIT 1").zza(this.zzc, string).zza();
    }

    final /* synthetic */ void zza(List list, int n, Cursor cursor) {
        int n2 = cursor.getInt(0);
        int n3 = list.size();
        if (n3 > 0 && n2 == ((zzevl)list.get(n3 - 1)).zzb()) {
            return;
        }
        if (zzesf.zza(cursor.getString(1)).zzg() != n) {
            return;
        }
        list.add(this.zza(cursor.getBlob(2)));
    }

    final /* synthetic */ void zza(List list, Cursor cursor) {
        list.add(this.zza(cursor.getBlob(0)));
    }

    final /* synthetic */ void zzb(List list, Cursor cursor) {
        list.add(this.zza(cursor.getBlob(0)));
    }

    final /* synthetic */ void zzc(List list, Cursor cursor) {
        list.add(this.zza(cursor.getBlob(0)));
    }

    final /* synthetic */ zzevl zza(Cursor cursor) {
        return this.zza(cursor.getBlob(0));
    }

    final /* synthetic */ zzevl zzb(Cursor cursor) {
        return this.zza(cursor.getBlob(0));
    }

    final /* synthetic */ void zzc(Cursor cursor) {
        this.zzd = Math.max(this.zzd, cursor.getInt(0));
    }

    final /* synthetic */ void zzd(Cursor cursor) {
        this.zze = cursor.getInt(0);
        this.zzf = zzfgs.zza((byte[])cursor.getBlob(1));
    }
}

