/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzedv;
import com.google.android.gms.internal.zzerf;
import com.google.android.gms.internal.zzesb;
import com.google.android.gms.internal.zzesg;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzeur;
import com.google.android.gms.internal.zzeuw;
import com.google.android.gms.internal.zzevd;
import com.google.android.gms.internal.zzevk;
import com.google.android.gms.internal.zzevl;
import com.google.android.gms.internal.zzeyc;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzezd;
import com.google.android.gms.internal.zzfgs;
import com.google.firebase.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class zzeta
implements zzete {
    private final List<zzevl> zza = new ArrayList<zzevl>();
    private zzedv<zzesb> zzb = new zzedv(Collections.emptyList(), zzesb.zza);
    private int zzc = 1;
    private int zzd = -1;
    private zzfgs zze = zzeyc.zzc;
    private zzesg zzf;

    zzeta() {
    }

    @Override
    public final void zza() {
        if (this.zza.isEmpty()) {
            this.zzc = 1;
            this.zzd = -1;
        }
        zzeye.zza(this.zzd < this.zzc, "highestAcknowledgedBatchId must be less than the nextBatchId", new Object[0]);
    }

    @Override
    public final int zzb() {
        return this.zzd;
    }

    @Override
    public final void zza(zzevl zzevl2, zzfgs zzfgs2) {
        int n = zzevl2.zzb();
        zzeye.zza(n > this.zzd, "Mutation batchIds must be acknowledged in order", new Object[0]);
        int n2 = this.zza(n, "acknowledged");
        zzevl zzevl3 = this.zza.get(n2);
        zzeye.zza(n == zzevl3.zzb(), "Queue ordering failure: expected batch %d, got batch %d", n, zzevl3.zzb());
        zzeye.zza(!zzevl3.zzd(), "Can't acknowledge a previously removed batch", new Object[0]);
        this.zzd = n;
        this.zze = (zzfgs)zzbq.zza((Object)zzfgs2);
    }

    @Override
    public final zzfgs zzc() {
        return this.zze;
    }

    @Override
    public final void zza(zzfgs zzfgs2) {
        this.zze = (zzfgs)zzbq.zza((Object)zzfgs2);
    }

    @Override
    public final zzevl zza(Timestamp timestamp, List<zzevk> list) {
        zzeye.zza(!list.isEmpty(), "Mutation batches should not be empty", new Object[0]);
        int n = this.zzc++;
        int n2 = this.zza.size();
        if (n2 > 0) {
            zzeye.zza(this.zza.get(n2 - 1).zzb() < n, "Mutation batchIds must be monotonically increasing order", new Object[0]);
        }
        zzevl zzevl2 = new zzevl(n, timestamp, list);
        this.zza.add(zzevl2);
        for (zzevk zzevk2 : list) {
            this.zzb = this.zzb.zzc((Object)new zzesb(zzevk2.zza(), n));
        }
        return zzevl2;
    }

    @Override
    public final zzevl zza(int n) {
        int n2 = this.zze(n);
        if (n2 < 0 || n2 >= this.zza.size()) {
            return null;
        }
        zzevl zzevl2 = this.zza.get(n2);
        zzeye.zza(zzevl2.zzb() == n, "If found batch must match", new Object[0]);
        if (zzevl2.zzd()) {
            return null;
        }
        return zzevl2;
    }

    @Override
    public final zzevl zzb(int n) {
        int n2;
        int n3 = this.zza.size();
        int n4 = this.zze(n = Math.max(n + 1, this.zzd));
        int n5 = n2 = n4 < 0 ? 0 : n4;
        while (n2 < n3) {
            zzevl zzevl2 = this.zza.get(n2);
            if (!zzevl2.zzd()) {
                return zzevl2;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public final List<zzevl> zzd() {
        return this.zzd(this.zza.size());
    }

    @Override
    public final List<zzevl> zzc(int n) {
        int n2 = this.zza.size();
        int n3 = this.zze(n);
        n3 = n3 < 0 ? 0 : (n3 >= n2 ? n2 : ++n3);
        return this.zzd(n3);
    }

    @Override
    public final List<zzevl> zzb(zzeuw zzeuw2) {
        zzesb zzesb2;
        zzesb zzesb3 = new zzesb(zzeuw2, 0);
        ArrayList<zzevl> arrayList = new ArrayList<zzevl>();
        Iterator iterator = this.zzb.zzd((Object)zzesb3);
        while (iterator.hasNext() && zzeuw2.equals((zzesb2 = (zzesb)iterator.next()).zza())) {
            zzevl zzevl2 = this.zza(zzesb2.zzb());
            zzeye.zza(zzevl2 != null, "Batches in the index must exist in the main table", new Object[0]);
            arrayList.add(zzevl2);
        }
        return arrayList;
    }

    @Override
    public final List<zzevl> zza(zzerf zzerf2) {
        Object object;
        Object object2;
        zzevd zzevd2 = zzerf2.zza();
        int n = zzevd2.zzg() + 1;
        zzevd zzevd3 = zzevd2;
        if (!zzeuw.zzb(zzevd3)) {
            zzevd3 = (zzevd)((Object)zzevd3.zza(""));
        }
        zzesb zzesb2 = new zzesb(zzeuw.zza(zzevd3), 0);
        zzedv zzedv2 = new zzedv(Collections.emptyList(), zzezd.zzb());
        Iterator iterator = this.zzb.zzd((Object)zzesb2);
        while (iterator.hasNext() && zzevd2.zzc(object2 = ((zzesb)(object = (zzesb)iterator.next())).zza().zzd())) {
            if (((zzeur)object2).zzg() != n) continue;
            zzedv2 = zzedv2.zzc((Object)((zzesb)object).zzb());
        }
        object = new ArrayList();
        for (Integer n2 : zzedv2) {
            zzevl zzevl2 = this.zza(n2);
            if (zzevl2 == null) continue;
            object.add(zzevl2);
        }
        return object;
    }

    @Override
    public final void zza(List<zzevl> list) {
        int n = list.size();
        zzeye.zza(n > 0, "Should not remove mutations when none exist.", new Object[0]);
        int n2 = list.get(0).zzb();
        int n3 = this.zza.size();
        int n4 = this.zza(n2, "removed");
        zzeye.zza(this.zza.get(n4).zzb() == n2, "Removed batches must exist in the queue", new Object[0]);
        int n5 = 1;
        int n6 = n4 + 1;
        while (n5 < n && n6 < n3) {
            zzevl zzevl2 = this.zza.get(n6);
            if (zzevl2.zzd()) {
                ++n6;
                continue;
            }
            zzeye.zza(zzevl2.zzb() == list.get(n5).zzb(), "Removed batches must be contiguous in the queue", new Object[0]);
            ++n5;
            ++n6;
        }
        if (n4 == 0) {
            while (n6 < n3 && this.zza.get(n6).zzd()) {
                ++n6;
            }
            this.zza.subList(n4, n6).clear();
        } else {
            for (int i = n4; i < n6; ++i) {
                this.zza.set(i, this.zza.get(i).zze());
            }
        }
        zzedv zzedv2 = this.zzb;
        for (zzevl zzevl3 : list) {
            int n7 = zzevl3.zzb();
            Iterator<zzevk> iterator = zzevl3.zzf().iterator();
            while (iterator.hasNext()) {
                zzeuw zzeuw2 = iterator.next().zza();
                if (this.zzf != null) {
                    this.zzf.zza(zzeuw2);
                }
                zzesb zzesb2 = new zzesb(zzeuw2, n7);
                zzedv2 = zzedv2.zzb((Object)zzesb2);
            }
        }
        this.zzb = zzedv2;
    }

    @Override
    public final void zze() {
        if (this.zza.isEmpty()) {
            zzeye.zza(this.zzb.zzd(), "Document leak -- detected dangling mutation references when queue is empty.", new Object[0]);
        }
    }

    @Override
    public final void zza(zzesg zzesg2) {
        this.zzf = zzesg2;
    }

    @Override
    public final boolean zza(zzeuw zzeuw2) {
        zzesb zzesb2 = new zzesb(zzeuw2, 0);
        Iterator iterator = this.zzb.zzd((Object)zzesb2);
        if (!iterator.hasNext()) {
            return false;
        }
        return ((zzesb)iterator.next()).zza().equals(zzeuw2);
    }

    private final List<zzevl> zzd(int n) {
        ArrayList<zzevl> arrayList = new ArrayList<zzevl>(n);
        for (int i = 0; i < n; ++i) {
            zzevl zzevl2 = this.zza.get(i);
            if (zzevl2.zzd()) continue;
            arrayList.add(zzevl2);
        }
        return arrayList;
    }

    private final int zze(int n) {
        if (this.zza.isEmpty()) {
            return 0;
        }
        int n2 = this.zza.get(0).zzb();
        return n - n2;
    }

    private final int zza(int n, String string) {
        int n2 = this.zze(n);
        zzeye.zza(n2 >= 0 && n2 < this.zza.size(), "Batches must exist to be %s", string);
        return n2;
    }
}

