/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdol;
import com.google.android.gms.internal.zzdpq;
import com.google.android.gms.internal.zzdsd;
import com.google.android.gms.internal.zzdsf;
import java.math.RoundingMode;
import java.util.Arrays;

final class zzdsa {
    private final String zze;
    private final char[] zzf;
    final int zza;
    final int zzb;
    final int zzc;
    final int zzd;
    private final byte[] zzg;
    private final boolean[] zzh;

    zzdsa(String string, char[] cArray) {
        int n;
        this.zze = zzdpq.zza(string);
        this.zzf = zzdpq.zza(cArray);
        try {
            this.zzb = zzdsf.zza(cArray.length, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException arithmeticException) {
            int n2 = cArray.length;
            throw new IllegalArgumentException(new StringBuilder(35).append("Illegal alphabet length ").append(n2).toString(), arithmeticException);
        }
        int n3 = Math.min(8, Integer.lowestOneBit(this.zzb));
        try {
            this.zzc = 8 / n3;
            this.zzd = this.zzb / n3;
        }
        catch (ArithmeticException arithmeticException) {
            String string2 = String.valueOf(new String(cArray));
            throw new IllegalArgumentException(string2.length() != 0 ? "Illegal alphabet ".concat(string2) : new String("Illegal alphabet "), arithmeticException);
        }
        this.zza = cArray.length - 1;
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        for (int i = 0; i < cArray.length; ++i) {
            n = cArray[i];
            zzdpq.zza(n < 128, "Non-ASCII character: %s", (char)n);
            zzdpq.zza(byArray[n] == -1, "Duplicate character: %s", (char)n);
            byArray[n] = (byte)i;
        }
        this.zzg = byArray;
        boolean[] blArray = new boolean[this.zzc];
        for (n = 0; n < this.zzd; ++n) {
            blArray[zzdsf.zza((int)(n << 3), (int)this.zzb, (RoundingMode)RoundingMode.CEILING)] = true;
        }
        this.zzh = blArray;
    }

    final char zza(int n) {
        return this.zzf[n];
    }

    final boolean zzb(int n) {
        return this.zzh[n % this.zzc];
    }

    final int zza(char c) throws zzdsd {
        if (c > '\u007f') {
            String string = String.valueOf(Integer.toHexString(c));
            throw new zzdsd(string.length() != 0 ? "Unrecognized character: 0x".concat(string) : new String("Unrecognized character: 0x"));
        }
        byte by = this.zzg[c];
        if (by == -1) {
            if (c <= ' ' || c == '\u007f') {
                String string = String.valueOf(Integer.toHexString(c));
                throw new zzdsd(string.length() != 0 ? "Unrecognized character: 0x".concat(string) : new String("Unrecognized character: 0x"));
            }
            throw new zzdsd(new StringBuilder(25).append("Unrecognized character: ").append(c).toString());
        }
        return by;
    }

    final zzdsa zza() {
        boolean bl;
        block5: {
            boolean bl2;
            int n;
            int n2;
            char[] cArray;
            block4: {
                cArray = this.zzf;
                n2 = this.zzf.length;
                for (n = 0; n < n2; ++n) {
                    if (!zzdol.zza(cArray[n])) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            if (!bl2) {
                return this;
            }
            cArray = this.zzf;
            n2 = this.zzf.length;
            for (n = 0; n < n2; ++n) {
                char c = cArray[n];
                if (!(c >= 'a' && c <= 'z')) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        zzdpq.zzb(!bl, "Cannot call lowerCase() on a mixed-case alphabet");
        char[] cArray = new char[this.zzf.length];
        for (int i = 0; i < this.zzf.length; ++i) {
            char c = this.zzf[i];
            cArray[i] = zzdol.zza(c) ? (char)(c ^ 0x20) : c;
        }
        return new zzdsa(String.valueOf(this.zze).concat(".lowerCase()"), cArray);
    }

    public final boolean zzb(char c) {
        return c < this.zzg.length && this.zzg[c] != -1;
    }

    public final String toString() {
        return this.zze;
    }

    public final boolean equals(Object object) {
        if (object instanceof zzdsa) {
            zzdsa zzdsa2 = (zzdsa)object;
            return Arrays.equals(this.zzf, zzdsa2.zzf);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.zzf);
    }

    static /* synthetic */ char[] zza(zzdsa zzdsa2) {
        return zzdsa2.zzf;
    }
}

