/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzana;
import com.google.android.gms.internal.zzanb;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> aSH = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> aSI = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> aSJ = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> aSK = Arrays.asList(new String[0]);
    private static final Set<String> aSL = Collections.emptySet();
    private static final Object zzaok = new Object();
    static final Map<String, FirebaseApp> afS = new ArrayMap();
    private final Context zzask;
    private final String mName;
    private final FirebaseOptions aSM;
    private final AtomicBoolean aSN = new AtomicBoolean(false);
    private final AtomicBoolean aSO = new AtomicBoolean();
    private final List<zza> aSP = new CopyOnWriteArrayList<zza>();
    private final List<zzb> aSQ = new CopyOnWriteArrayList<zzb>();
    private final List<Object> aSR = new CopyOnWriteArrayList<Object>();
    private zzanb aSS;

    @NonNull
    public Context getApplicationContext() {
        this.zzcnt();
        return this.zzask;
    }

    @NonNull
    public String getName() {
        this.zzcnt();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzcnt();
        return this.aSM;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzab.zzx((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.aSM).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzana zzana2 = zzana.zzew(context);
        Object object = zzaok;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(afS.values());
            Set<String> set = zzana.N().O();
            set.removeAll(afS.keySet());
            for (String string : set) {
                FirebaseOptions firebaseOptions = zzana2.zzua(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, firebaseOptions, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzaok;
        synchronized (object) {
            FirebaseApp firebaseApp = afS.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = String.valueOf(zzt.zzaxy());
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzaok;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = afS.get(FirebaseApp.zzrr(string));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzcnw();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(zzz.zzhy((String)", ").zza(list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string2);
            throw new IllegalStateException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzaok;
        synchronized (object) {
            if (afS.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzana zzana2 = zzana.zzew(context);
        FirebaseApp.zzep(context);
        String string2 = FirebaseApp.zzrr(string);
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        Object object = zzaok;
        synchronized (object) {
            zzac.zza((!afS.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzac.zzb((Object)context2, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context2, string2, firebaseOptions);
            afS.put(string2, firebaseApp);
        }
        zzana2.zzg(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, aSH);
        if (firebaseApp.zzcnu()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, aSI);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), aSJ);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzcp(boolean bl) {
        Object object = zzaok;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(afS.values())) {
                if (!firebaseApp.aSN.get()) continue;
                firebaseApp.zzcq(bl);
            }
        }
    }

    public void zza(@NonNull zzanb zzanb2) {
        this.aSS = (zzanb)zzac.zzy((Object)zzanb2);
    }

    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzcnt();
        if (this.aSS == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.aSS.zzcr(bl);
    }

    protected FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzask = (Context)zzac.zzy((Object)context);
        this.mName = zzac.zzhz((String)string);
        this.aSM = (FirebaseOptions)zzac.zzy((Object)firebaseOptions);
    }

    private void zzcnt() {
        zzac.zza((!this.aSO.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public boolean zzcnu() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void zza(@NonNull zzanc zzanc2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (zza zza2 : this.aSP) {
            zza2.zzb(zzanc2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zzcq(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (zzb zzb2 : this.aSQ) {
            zzb2.zzcp(bl);
        }
    }

    public void zza(@NonNull zza zza2) {
        this.zzcnt();
        zzac.zzy((Object)zza2);
        this.aSP.add(zza2);
    }

    public void zza(zzb zzb2) {
        this.zzcnt();
        if (this.aSN.get() && zzamz.L().M()) {
            zzb2.zzcp(true);
        }
        this.aSQ.add(zzb2);
    }

    public String zzcnv() {
        String string = String.valueOf(com.google.android.gms.common.util.zzc.zzr((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(com.google.android.gms.common.util.zzc.zzr((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzcnw() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zzaok;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : afS.values()) {
                zza2.add(firebaseApp.getName());
            }
            zzana zzana2 = zzana.N();
            if (zzana2 != null) {
                zza2.addAll(zzana2.O());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private void zzcnx() {
        this.zza(FirebaseApp.class, this, aSH);
        if (this.zzcnu()) {
            this.zza(FirebaseApp.class, this, aSI);
            this.zza(Context.class, this.zzask, aSJ);
        }
    }

    private <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = false;
        if (zzs.zzaxw() && (bl = this.zzask.isDeviceProtectedStorage())) {
            zzc.zzeq(this.zzask);
        }
        for (String string : iterable) {
            try {
                Class<?> clazz2;
                Method method;
                int n;
                if (bl && !aSK.contains(string) || !Modifier.isPublic(n = (method = (clazz2 = Class.forName(string)).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (aSL.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    private static String zzrr(@NonNull String string) {
        return string.trim();
    }

    @TargetApi(value=14)
    private static void zzep(Context context) {
        if (zzs.zzaxn() && context.getApplicationContext() instanceof Application) {
            Application application = (Application)context.getApplicationContext();
            zzamz.zza(application);
        }
    }

    @TargetApi(value=24)
    private static class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> aST = new AtomicReference();
        private final Context zzask;

        public zzc(Context context) {
            this.zzask = context;
        }

        private static void zzeq(Context context) {
            zzc zzc2;
            if (aST.get() == null && aST.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                intentFilter.addDataScheme("package");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = zzaok;
            synchronized (object) {
                for (FirebaseApp firebaseApp : afS.values()) {
                    firebaseApp.zzcnx();
                }
            }
            this.unregister();
        }

        public void unregister() {
            this.zzask.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public static interface zzb {
        public void zzcp(boolean var1);
    }

    public static interface zza {
        public void zzb(@NonNull zzanc var1);
    }
}

