/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public final class Tenant {
    @Key(value="name")
    private String resourceName;
    @Key(value="displayName")
    private String displayName;
    @Key(value="allowPasswordSignup")
    private boolean passwordSignInAllowed;
    @Key(value="enableEmailLinkSignin")
    private boolean emailLinkSignInEnabled;

    public String getTenantId() {
        return this.resourceName.substring(this.resourceName.lastIndexOf("/") + 1);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isPasswordSignInAllowed() {
        return this.passwordSignInAllowed;
    }

    public boolean isEmailLinkSignInEnabled() {
        return this.emailLinkSignInEnabled;
    }

    public UpdateRequest updateRequest() {
        return new UpdateRequest(this.getTenantId());
    }

    public static final class UpdateRequest {
        private final String tenantId;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public UpdateRequest(String tenantId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tenantId) ? 1 : 0) != 0, (Object)"tenant ID must not be null or empty");
            this.tenantId = tenantId;
        }

        String getTenantId() {
            return this.tenantId;
        }

        public UpdateRequest setDisplayName(String displayName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)displayName) ? 1 : 0) != 0, (Object)"display name must not be null or empty");
            this.properties.put("displayName", displayName);
            return this;
        }

        public UpdateRequest setPasswordSignInAllowed(boolean passwordSignInAllowed) {
            this.properties.put("allowPasswordSignup", passwordSignInAllowed);
            return this;
        }

        public UpdateRequest setEmailLinkSignInEnabled(boolean emailLinkSignInEnabled) {
            this.properties.put("enableEmailLinkSignin", emailLinkSignInEnabled);
            return this;
        }

        Map<String, Object> getProperties() {
            return ImmutableMap.copyOf(this.properties);
        }
    }

    public static final class CreateRequest {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public CreateRequest setDisplayName(String displayName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)displayName) ? 1 : 0) != 0, (Object)"display name must not be null or empty");
            this.properties.put("displayName", displayName);
            return this;
        }

        public CreateRequest setPasswordSignInAllowed(boolean passwordSignInAllowed) {
            this.properties.put("allowPasswordSignup", passwordSignInAllowed);
            return this;
        }

        public CreateRequest setEmailLinkSignInEnabled(boolean emailLinkSignInEnabled) {
            this.properties.put("enableEmailLinkSignin", emailLinkSignInEnabled);
            return this;
        }

        Map<String, Object> getProperties() {
            return ImmutableMap.copyOf(this.properties);
        }
    }
}

