/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.UserImportHash;
import com.google.firebase.internal.NonNull;
import java.util.Map;

public final class UserImportOptions {
    private final UserImportHash hash;

    private UserImportOptions(Builder builder) {
        this.hash = (UserImportHash)Preconditions.checkNotNull((Object)builder.hash);
    }

    public static UserImportOptions withHash(@NonNull UserImportHash hash) {
        return UserImportOptions.builder().setHash((UserImportHash)Preconditions.checkNotNull((Object)hash)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    Map<String, Object> getProperties() {
        return ImmutableMap.builder().putAll(this.hash.getProperties()).build();
    }

    UserImportHash getHash() {
        return this.hash;
    }

    public static class Builder {
        private UserImportHash hash;

        private Builder() {
        }

        public Builder setHash(@NonNull UserImportHash hash) {
            this.hash = hash;
            return this;
        }

        public UserImportOptions build() {
            return new UserImportOptions(this);
        }
    }
}

