/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api.buildplan;

import com.google.cloud.tools.jib.api.buildplan.RelativeUnixPath;
import com.google.cloud.tools.jib.buildplan.UnixPathParser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AbsoluteUnixPath {
    private final List<String> pathComponents;
    private final String unixPath;

    public static AbsoluteUnixPath get(String unixPath) {
        if (!unixPath.startsWith("/")) {
            throw new IllegalArgumentException("Path does not start with forward slash (/): " + unixPath);
        }
        return new AbsoluteUnixPath(UnixPathParser.parse(unixPath));
    }

    public static AbsoluteUnixPath fromPath(Path path) {
        if (path.getRoot() == null) {
            throw new IllegalArgumentException("Cannot create AbsoluteUnixPath from non-absolute Path: " + path);
        }
        ArrayList<String> pathComponents = new ArrayList<String>(path.getNameCount());
        path.forEach(component -> pathComponents.add(component.toString()));
        return new AbsoluteUnixPath(pathComponents);
    }

    private AbsoluteUnixPath(List<String> pathComponents) {
        this.pathComponents = pathComponents;
        StringJoiner pathJoiner = new StringJoiner("/", "/", "");
        for (String pathComponent : pathComponents) {
            pathJoiner.add(pathComponent);
        }
        this.unixPath = pathJoiner.toString();
    }

    public AbsoluteUnixPath resolve(RelativeUnixPath relativeUnixPath) {
        int newSize = this.pathComponents.size() + relativeUnixPath.getRelativePathComponents().size();
        ArrayList<String> newPathComponents = new ArrayList<String>(newSize);
        newPathComponents.addAll(this.pathComponents);
        newPathComponents.addAll(relativeUnixPath.getRelativePathComponents());
        return new AbsoluteUnixPath(newPathComponents);
    }

    public AbsoluteUnixPath resolve(Path relativePath) {
        if (relativePath.getRoot() != null) {
            throw new IllegalArgumentException("Cannot resolve against absolute Path: " + relativePath);
        }
        return AbsoluteUnixPath.fromPath(Paths.get(this.unixPath, new String[0]).resolve(relativePath));
    }

    public AbsoluteUnixPath resolve(String relativeUnixPath) {
        return this.resolve(RelativeUnixPath.get(relativeUnixPath));
    }

    public String toString() {
        return this.unixPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbsoluteUnixPath)) {
            return false;
        }
        AbsoluteUnixPath otherAbsoluteUnixPath = (AbsoluteUnixPath)other;
        return this.unixPath.equals(otherAbsoluteUnixPath.unixPath);
    }

    public int hashCode() {
        return this.unixPath.hashCode();
    }
}

