/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.collection;

import com.google.api.core.InternalApi;
import com.google.cloud.firestore.collection.ImmutableSortedMap;
import com.google.cloud.firestore.collection.LLRBNode;
import com.google.cloud.firestore.collection.RBTreeSortedMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@InternalApi
public class ArraySortedMap<K, V>
extends ImmutableSortedMap<K, V> {
    private final K[] keys;
    private final V[] values;
    private final Comparator<K> comparator;

    public static <A, B, C> ArraySortedMap<A, C> buildFrom(List<A> keys, Map<B, C> values, ImmutableSortedMap.Builder.KeyTranslator<A, B> translator, Comparator<A> comparator) {
        Collections.sort(keys, comparator);
        int size = keys.size();
        Object[] keyArray = new Object[size];
        Object[] valueArray = new Object[size];
        int pos = 0;
        for (A k : keys) {
            keyArray[pos] = k;
            C value = values.get(translator.translate(k));
            valueArray[pos] = value;
            ++pos;
        }
        return new ArraySortedMap<Object, Object>(comparator, keyArray, valueArray);
    }

    public static <K, V> ArraySortedMap<K, V> fromMap(Map<K, V> map, Comparator<K> comparator) {
        return ArraySortedMap.buildFrom(new ArrayList<K>(map.keySet()), map, ImmutableSortedMap.Builder.identityTranslator(), comparator);
    }

    public ArraySortedMap(Comparator<K> comparator) {
        this.keys = new Object[0];
        this.values = new Object[0];
        this.comparator = comparator;
    }

    private ArraySortedMap(Comparator<K> comparator, K[] keys, V[] values) {
        this.keys = keys;
        this.values = values;
        this.comparator = comparator;
    }

    @Override
    public boolean containsKey(K key) {
        return this.findKey(key) != -1;
    }

    @Override
    public V get(K key) {
        int pos = this.findKey(key);
        return pos != -1 ? (V)this.values[pos] : null;
    }

    @Override
    public ImmutableSortedMap<K, V> remove(K key) {
        int pos = this.findKey(key);
        if (pos == -1) {
            return this;
        }
        K[] keys = ArraySortedMap.removeFromArray(this.keys, pos);
        V[] values = ArraySortedMap.removeFromArray(this.values, pos);
        return new ArraySortedMap<K, V>(this.comparator, keys, values);
    }

    @Override
    public ImmutableSortedMap<K, V> insert(K key, V value) {
        int pos = this.findKey(key);
        if (pos != -1) {
            if (this.keys[pos] == key && this.values[pos] == value) {
                return this;
            }
            K[] newKeys = ArraySortedMap.replaceInArray(this.keys, pos, key);
            V[] newValues = ArraySortedMap.replaceInArray(this.values, pos, value);
            return new ArraySortedMap<K, V>(this.comparator, newKeys, newValues);
        }
        if (this.keys.length > 25) {
            HashMap<K, V> map = new HashMap<K, V>(this.keys.length + 1);
            for (int i = 0; i < this.keys.length; ++i) {
                map.put(this.keys[i], this.values[i]);
            }
            map.put(key, value);
            return RBTreeSortedMap.fromMap(map, this.comparator);
        }
        int newPos = this.findKeyOrInsertPosition(key);
        K[] keys = ArraySortedMap.addToArray(this.keys, newPos, key);
        V[] values = ArraySortedMap.addToArray(this.values, newPos, value);
        return new ArraySortedMap<K, V>(this.comparator, keys, values);
    }

    @Override
    public K getMinKey() {
        return this.keys.length > 0 ? (K)this.keys[0] : null;
    }

    @Override
    public K getMaxKey() {
        return this.keys.length > 0 ? (K)this.keys[this.keys.length - 1] : null;
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public void inOrderTraversal(LLRBNode.NodeVisitor<K, V> visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            visitor.visitEntry(this.keys[i], this.values[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> iterator(final int pos, final boolean reverse) {
        return new Iterator<Map.Entry<K, V>>(){
            int currentPos;
            {
                this.currentPos = pos;
            }

            @Override
            public boolean hasNext() {
                return reverse ? this.currentPos >= 0 : this.currentPos < ArraySortedMap.this.keys.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object key = ArraySortedMap.this.keys[this.currentPos];
                Object value = ArraySortedMap.this.values[this.currentPos];
                this.currentPos = reverse ? this.currentPos - 1 : this.currentPos + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.iterator(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iteratorFrom(K key) {
        int pos = this.findKeyOrInsertPosition(key);
        return this.iterator(pos, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> reverseIteratorFrom(K key) {
        int pos = this.findKeyOrInsertPosition(key);
        if (pos < this.keys.length && this.comparator.compare(this.keys[pos], key) == 0) {
            return this.iterator(pos, true);
        }
        return this.iterator(pos - 1, true);
    }

    @Override
    public Iterator<Map.Entry<K, V>> reverseIterator() {
        return this.iterator(this.keys.length - 1, true);
    }

    @Override
    public K getPredecessorKey(K key) {
        int pos = this.findKey(key);
        if (pos == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return pos > 0 ? (K)this.keys[pos - 1] : null;
    }

    @Override
    public K getSuccessorKey(K key) {
        int pos = this.findKey(key);
        if (pos == -1) {
            throw new IllegalArgumentException("Can't find successor of nonexistent key");
        }
        return pos < this.keys.length - 1 ? (K)this.keys[pos + 1] : null;
    }

    @Override
    public int indexOf(K key) {
        return this.findKey(key);
    }

    @Override
    public Comparator<K> getComparator() {
        return this.comparator;
    }

    private static <T> T[] removeFromArray(T[] arr, int pos) {
        int newSize = arr.length - 1;
        Object[] newArray = new Object[newSize];
        System.arraycopy(arr, 0, newArray, 0, pos);
        System.arraycopy(arr, pos + 1, newArray, pos, newSize - pos);
        return newArray;
    }

    private static <T> T[] addToArray(T[] arr, int pos, T value) {
        int newSize = arr.length + 1;
        Object[] newArray = new Object[newSize];
        System.arraycopy(arr, 0, newArray, 0, pos);
        newArray[pos] = value;
        System.arraycopy(arr, pos, newArray, pos + 1, newSize - pos - 1);
        return newArray;
    }

    private static <T> T[] replaceInArray(T[] arr, int pos, T value) {
        int size = arr.length;
        Object[] newArray = new Object[size];
        System.arraycopy(arr, 0, newArray, 0, size);
        newArray[pos] = value;
        return newArray;
    }

    private int findKeyOrInsertPosition(K key) {
        int newPos;
        for (newPos = 0; newPos < this.keys.length && this.comparator.compare(this.keys[newPos], key) < 0; ++newPos) {
        }
        return newPos;
    }

    private int findKey(K key) {
        int i = 0;
        for (K otherKey : this.keys) {
            if (this.comparator.compare(key, otherKey) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

