/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@BetaApi
public final class RecursiveDelete {
    public static final String REFERENCE_NAME_MIN_ID = "__id-9223372036854775808__";
    public static final int MAX_PENDING_OPS = 5000;
    public static final int MIN_PENDING_OPS = 1000;
    private final FirestoreRpcContext<?> firestoreRpcContext;
    private final BulkWriter writer;
    private final ResourcePath path;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int errorCount = 0;
    @Nullable
    @GuardedBy(value="lock")
    private Throwable lastError;
    @GuardedBy(value="lock")
    private boolean documentsPending = true;
    private final SettableApiFuture<Void> completionFuture = SettableApiFuture.create();
    @GuardedBy(value="lock")
    private boolean streamInProgress = false;
    private boolean started = false;
    private final int maxPendingOps;
    private final int minPendingOps;
    @Nullable
    private DocumentSnapshot lastDocumentSnap;
    private int pendingOperationsCount = 0;

    RecursiveDelete(FirestoreRpcContext<?> firestoreRpcContext, BulkWriter writer, ResourcePath path, int maxLimit, int minLimit) {
        this.firestoreRpcContext = firestoreRpcContext;
        this.writer = writer;
        this.path = path;
        this.maxPendingOps = maxLimit;
        this.minPendingOps = minLimit;
    }

    public ApiFuture<Void> run() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"RecursiveDelete.run() should only be called once");
        this.started = true;
        this.writer.verifyNotClosed();
        this.streamDescendants();
        return this.completionFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamDescendants() {
        Query query = this.getAllDescendantsQuery();
        Object object = this.lock;
        synchronized (object) {
            this.streamInProgress = true;
        }
        final int[] streamedDocsCount = new int[]{0};
        ApiStreamObserver<DocumentSnapshot> responseObserver = new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot snapshot) {
                streamedDocsCount[0] = streamedDocsCount[0] + 1;
                RecursiveDelete.this.lastDocumentSnap = snapshot;
                RecursiveDelete.this.deleteReference(snapshot.getReference());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable throwable) {
                String message = "Failed to fetch children documents";
                Object object = RecursiveDelete.this.lock;
                synchronized (object) {
                    RecursiveDelete.this.lastError = (Throwable)((Object)FirestoreException.forServerRejection(Status.UNAVAILABLE, throwable, message, new Object[0]));
                }
                RecursiveDelete.this.onQueryEnd();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted() {
                Object object = RecursiveDelete.this.lock;
                synchronized (object) {
                    RecursiveDelete.this.streamInProgress = false;
                }
                if (streamedDocsCount[0] < RecursiveDelete.this.maxPendingOps) {
                    RecursiveDelete.this.onQueryEnd();
                } else if (RecursiveDelete.this.pendingOperationsCount == 0) {
                    RecursiveDelete.this.streamDescendants();
                }
            }
        };
        query.stream(responseObserver);
    }

    private Query getAllDescendantsQuery() {
        String collectionId;
        ResourcePath parentPath;
        if (this.path.isDocument()) {
            parentPath = this.path;
            Preconditions.checkState((this.path.getParent() != null ? 1 : 0) != 0, (Object)"Parent of a document should not be null.");
            collectionId = ((ResourcePath)this.path.getParent()).getId();
        } else {
            parentPath = this.path.popLast();
            collectionId = this.path.getId();
        }
        Query query = new Query(this.firestoreRpcContext, Query.QueryOptions.builder().setParentPath(parentPath).setCollectionId(collectionId).setAllDescendants(true).setKindless(true).setRequireConsistency(false).build());
        query = query.select(FieldPath.documentId()).limit(this.maxPendingOps);
        if (this.path.isCollection()) {
            char nullChar = '\u0000';
            String startAt = collectionId + "/" + REFERENCE_NAME_MIN_ID;
            String endAt = collectionId + nullChar + "/" + REFERENCE_NAME_MIN_ID;
            query = query.whereGreaterThanOrEqualTo(FieldPath.documentId(), (Object)startAt).whereLessThan(FieldPath.documentId(), (Object)endAt);
        }
        if (this.lastDocumentSnap != null) {
            query = query.startAfter(this.lastDocumentSnap);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryEnd() {
        Object object = this.lock;
        synchronized (object) {
            this.documentsPending = false;
        }
        ArrayList<ApiFuture<Void>> pendingFutures = new ArrayList<ApiFuture<Void>>();
        if (this.path.isDocument()) {
            pendingFutures.add(this.deleteReference(new DocumentReference(this.firestoreRpcContext, this.path)));
        }
        pendingFutures.add(this.writer.flush());
        ApiFutures.transformAsync((ApiFuture)ApiFutures.allAsList(pendingFutures), (ApiAsyncFunction)new ApiAsyncFunction<List<Void>, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ApiFuture<Void> apply(List<Void> unused) {
                Object object = RecursiveDelete.this.lock;
                synchronized (object) {
                    if (RecursiveDelete.this.lastError == null) {
                        RecursiveDelete.this.completionFuture.set(null);
                    } else {
                        String message = RecursiveDelete.this.errorCount + (RecursiveDelete.this.errorCount != 1 ? " deletes" : " delete") + " failed. " + RecursiveDelete.this.lastError.getMessage();
                        if (RecursiveDelete.this.lastError instanceof FirestoreException) {
                            RecursiveDelete.this.lastError = (Throwable)((Object)new FirestoreException(message, ((FirestoreException)((Object)RecursiveDelete.this.lastError)).getStatus()));
                        } else {
                            RecursiveDelete.this.lastError = new Throwable(message, RecursiveDelete.this.lastError);
                        }
                        RecursiveDelete.this.completionFuture.setException(RecursiveDelete.this.lastError);
                    }
                    return ApiFutures.immediateFuture(null);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiFuture<Void> deleteReference(DocumentReference reference) {
        Object object = this.lock;
        synchronized (object) {
            ++this.pendingOperationsCount;
        }
        ApiFuture catchingDeleteFuture = ApiFutures.catchingAsync(this.writer.delete(reference), Throwable.class, (ApiAsyncFunction)new ApiAsyncFunction<Throwable, WriteResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ApiFuture<WriteResult> apply(Throwable e) {
                Object object = RecursiveDelete.this.lock;
                synchronized (object) {
                    RecursiveDelete.this.errorCount++;
                    RecursiveDelete.this.lastError = e;
                    return ApiFutures.immediateFuture(null);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transformAsync((ApiFuture)catchingDeleteFuture, (ApiAsyncFunction)new ApiAsyncFunction<WriteResult, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ApiFuture<Void> apply(WriteResult result) {
                Object object = RecursiveDelete.this.lock;
                synchronized (object) {
                    RecursiveDelete.this.pendingOperationsCount--;
                    if (RecursiveDelete.this.documentsPending && !RecursiveDelete.this.streamInProgress && RecursiveDelete.this.pendingOperationsCount < RecursiveDelete.this.minPendingOps) {
                        RecursiveDelete.this.streamDescendants();
                    }
                    return ApiFutures.immediateFuture(null);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

