/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.firestore.bundle.BundleElement;
import com.google.firestore.bundle.BundleMetadata;
import com.google.firestore.bundle.BundledDocumentMetadata;
import com.google.firestore.bundle.BundledQuery;
import com.google.firestore.bundle.NamedQuery;
import com.google.firestore.v1.Document;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class FirestoreBundle {
    static final int BUNDLE_SCHEMA_VERSION = 1;
    private static final JsonFormat.Printer PRINTER = JsonFormat.printer();
    private byte[] bundleData;

    private FirestoreBundle(byte[] data) {
        this.bundleData = data;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.bundleData).asReadOnlyBuffer();
    }

    private static class BundledDocument {
        private BundledDocumentMetadata metadata;
        private final Document document;

        BundledDocument(BundledDocumentMetadata metadata, Document document) {
            this.metadata = metadata;
            this.document = document;
        }

        public BundledDocumentMetadata getMetadata() {
            return this.metadata;
        }

        void setMetadata(BundledDocumentMetadata metadata) {
            this.metadata = metadata;
        }

        public Document getDocument() {
            return this.document;
        }
    }

    public static final class Builder {
        private String id;
        private Map<String, BundledDocument> documents = new HashMap<String, BundledDocument>();
        private Map<String, NamedQuery> namedQueries = new HashMap<String, NamedQuery>();
        private Timestamp latestReadTime = Timestamp.MIN_VALUE;

        Builder(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Builder add(DocumentSnapshot documentSnapshot) {
            return this.add(documentSnapshot, (Optional<String>)Optional.absent());
        }

        private Builder add(DocumentSnapshot documentSnapshot, Optional<String> queryName) {
            Timestamp snapReadTime;
            String documentName = documentSnapshot.getReference().getName();
            BundledDocument originalDocument = this.documents.get(documentSnapshot.getReference().getName());
            ArrayList queries = originalDocument == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)originalDocument.getMetadata().getQueriesList());
            Timestamp timestamp = snapReadTime = documentSnapshot.getReadTime() == null ? Timestamp.MIN_VALUE : documentSnapshot.getReadTime();
            if (originalDocument == null || originalDocument.getMetadata().getReadTime() == null || snapReadTime.compareTo(Timestamp.fromProto((com.google.protobuf.Timestamp)originalDocument.getMetadata().getReadTime())) > 0) {
                BundledDocumentMetadata metadata = BundledDocumentMetadata.newBuilder().setName(documentName).setReadTime(snapReadTime.toProto()).setExists(documentSnapshot.exists()).build();
                Document document = documentSnapshot.exists() ? documentSnapshot.toDocumentPb().build() : null;
                this.documents.put(documentName, new BundledDocument(metadata, document));
            }
            if (queryName.isPresent()) {
                queries.add(queryName.get());
            }
            this.documents.get(documentName).setMetadata(this.documents.get(documentName).getMetadata().toBuilder().clearQueries().addAllQueries((Iterable)queries).build());
            if (documentSnapshot.getReadTime().compareTo(this.latestReadTime) > 0) {
                this.latestReadTime = documentSnapshot.getReadTime();
            }
            return this;
        }

        public Builder add(String queryName, QuerySnapshot querySnap) {
            BundledQuery query = querySnap.getQuery().toBundledQuery();
            NamedQuery namedQuery = NamedQuery.newBuilder().setName(queryName).setReadTime(querySnap.getReadTime().toProto()).setBundledQuery(query).build();
            this.namedQueries.put(queryName, namedQuery);
            for (QueryDocumentSnapshot snapshot : querySnap.getDocuments()) {
                this.add(snapshot, (Optional<String>)Optional.of((Object)queryName));
            }
            if (querySnap.getReadTime().compareTo(this.latestReadTime) > 0) {
                this.latestReadTime = querySnap.getReadTime();
            }
            return this;
        }

        public FirestoreBundle build() {
            StringBuilder buffer = new StringBuilder();
            for (NamedQuery namedQuery : this.namedQueries.values()) {
                buffer.append((CharSequence)this.elementToLengthPrefixedStringBuilder(BundleElement.newBuilder().setNamedQuery(namedQuery).build()));
            }
            for (BundledDocument bundledDocument : this.documents.values()) {
                buffer.append((CharSequence)this.elementToLengthPrefixedStringBuilder(BundleElement.newBuilder().setDocumentMetadata(bundledDocument.getMetadata()).build()));
                if (bundledDocument.getDocument() == null) continue;
                buffer.append((CharSequence)this.elementToLengthPrefixedStringBuilder(BundleElement.newBuilder().setDocument(bundledDocument.getDocument()).build()));
            }
            BundleMetadata metadata = BundleMetadata.newBuilder().setId(this.id).setCreateTime(this.latestReadTime.toProto()).setVersion(1).setTotalDocuments(this.documents.size()).setTotalBytes((long)buffer.toString().getBytes().length).build();
            BundleElement element = BundleElement.newBuilder().setMetadata(metadata).build();
            buffer.insert(0, this.elementToLengthPrefixedStringBuilder(element));
            return new FirestoreBundle(buffer.toString().getBytes(StandardCharsets.UTF_8));
        }

        private StringBuilder elementToLengthPrefixedStringBuilder(BundleElement element) {
            String elementJson = null;
            try {
                elementJson = PRINTER.print((MessageOrBuilder)element);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            return new StringBuilder().append(elementJson.getBytes().length).append(elementJson);
        }
    }
}

