/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A bulk restore objects request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BulkRestoreObjectsRequest extends com.google.api.client.json.GenericJson {

  /**
   * If false (default), the restore will not overwrite live objects with the same name at the
   * destination. This means some deleted objects may be skipped. If true, live objects will be
   * overwritten resulting in a noncurrent object (if versioning is enabled). If versioning is not
   * enabled, overwriting the object will result in a soft-deleted object. In either case, if a
   * noncurrent object already exists with the same name, a live version can be written without
   * issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowOverwrite;

  /**
   * If true, copies the source object's ACL; otherwise, uses the bucket's default object ACL. The
   * default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean copySourceAcl;

  /**
   * Restores only the objects that were created after this time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdAfterTime;

  /**
   * Restores only the objects that were created before this time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdBeforeTime;

  /**
   * Restores only the objects matching any of the specified glob(s). If this parameter is not
   * specified, all objects will be restored within the specified time range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> matchGlobs;

  /**
   * Restores only the objects that were soft-deleted after this time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime softDeletedAfterTime;

  /**
   * Restores only the objects that were soft-deleted before this time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime softDeletedBeforeTime;

  /**
   * If false (default), the restore will not overwrite live objects with the same name at the
   * destination. This means some deleted objects may be skipped. If true, live objects will be
   * overwritten resulting in a noncurrent object (if versioning is enabled). If versioning is not
   * enabled, overwriting the object will result in a soft-deleted object. In either case, if a
   * noncurrent object already exists with the same name, a live version can be written without
   * issue.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowOverwrite() {
    return allowOverwrite;
  }

  /**
   * If false (default), the restore will not overwrite live objects with the same name at the
   * destination. This means some deleted objects may be skipped. If true, live objects will be
   * overwritten resulting in a noncurrent object (if versioning is enabled). If versioning is not
   * enabled, overwriting the object will result in a soft-deleted object. In either case, if a
   * noncurrent object already exists with the same name, a live version can be written without
   * issue.
   * @param allowOverwrite allowOverwrite or {@code null} for none
   */
  public BulkRestoreObjectsRequest setAllowOverwrite(java.lang.Boolean allowOverwrite) {
    this.allowOverwrite = allowOverwrite;
    return this;
  }

  /**
   * If true, copies the source object's ACL; otherwise, uses the bucket's default object ACL. The
   * default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCopySourceAcl() {
    return copySourceAcl;
  }

  /**
   * If true, copies the source object's ACL; otherwise, uses the bucket's default object ACL. The
   * default is false.
   * @param copySourceAcl copySourceAcl or {@code null} for none
   */
  public BulkRestoreObjectsRequest setCopySourceAcl(java.lang.Boolean copySourceAcl) {
    this.copySourceAcl = copySourceAcl;
    return this;
  }

  /**
   * Restores only the objects that were created after this time.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedAfterTime() {
    return createdAfterTime;
  }

  /**
   * Restores only the objects that were created after this time.
   * @param createdAfterTime createdAfterTime or {@code null} for none
   */
  public BulkRestoreObjectsRequest setCreatedAfterTime(com.google.api.client.util.DateTime createdAfterTime) {
    this.createdAfterTime = createdAfterTime;
    return this;
  }

  /**
   * Restores only the objects that were created before this time.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedBeforeTime() {
    return createdBeforeTime;
  }

  /**
   * Restores only the objects that were created before this time.
   * @param createdBeforeTime createdBeforeTime or {@code null} for none
   */
  public BulkRestoreObjectsRequest setCreatedBeforeTime(com.google.api.client.util.DateTime createdBeforeTime) {
    this.createdBeforeTime = createdBeforeTime;
    return this;
  }

  /**
   * Restores only the objects matching any of the specified glob(s). If this parameter is not
   * specified, all objects will be restored within the specified time range.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMatchGlobs() {
    return matchGlobs;
  }

  /**
   * Restores only the objects matching any of the specified glob(s). If this parameter is not
   * specified, all objects will be restored within the specified time range.
   * @param matchGlobs matchGlobs or {@code null} for none
   */
  public BulkRestoreObjectsRequest setMatchGlobs(java.util.List<java.lang.String> matchGlobs) {
    this.matchGlobs = matchGlobs;
    return this;
  }

  /**
   * Restores only the objects that were soft-deleted after this time.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getSoftDeletedAfterTime() {
    return softDeletedAfterTime;
  }

  /**
   * Restores only the objects that were soft-deleted after this time.
   * @param softDeletedAfterTime softDeletedAfterTime or {@code null} for none
   */
  public BulkRestoreObjectsRequest setSoftDeletedAfterTime(com.google.api.client.util.DateTime softDeletedAfterTime) {
    this.softDeletedAfterTime = softDeletedAfterTime;
    return this;
  }

  /**
   * Restores only the objects that were soft-deleted before this time.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getSoftDeletedBeforeTime() {
    return softDeletedBeforeTime;
  }

  /**
   * Restores only the objects that were soft-deleted before this time.
   * @param softDeletedBeforeTime softDeletedBeforeTime or {@code null} for none
   */
  public BulkRestoreObjectsRequest setSoftDeletedBeforeTime(com.google.api.client.util.DateTime softDeletedBeforeTime) {
    this.softDeletedBeforeTime = softDeletedBeforeTime;
    return this;
  }

  @Override
  public BulkRestoreObjectsRequest set(String fieldName, Object value) {
    return (BulkRestoreObjectsRequest) super.set(fieldName, value);
  }

  @Override
  public BulkRestoreObjectsRequest clone() {
    return (BulkRestoreObjectsRequest) super.clone();
  }

}
