/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The spec for modifying the path before sending the request to the matched backend service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UrlRewrite extends com.google.api.client.json.GenericJson {

  /**
   * Before forwarding the request to the selected service, the request's host header is replaced
   * with contents of hostRewrite.
   *
   * The value must be from 1 to 255 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostRewrite;

  /**
   * Before forwarding the request to the selected backend service, the matching portion of the
   * request's path is replaced bypathPrefixRewrite.
   *
   * The value must be from 1 to 1024 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pathPrefixRewrite;

  /**
   * If specified, the pattern rewrites the URL path (based on the :path header) using the HTTP
   * template syntax.
   *
   * A corresponding path_template_match must be specified. Any template variables must exist in the
   * path_template_match field.                - -At least one variable must be specified in the
   * path_template_match       field     - You can omit variables from the rewritten URL       - The
   * * and ** operators cannot be matched       unless they have a corresponding variable name -
   * e.g.       {format=*} or {var=**}.
   *
   * For example, a path_template_match of /static/{format=**} could be rewritten as
   * /static/content/{format} to prefix/content to the URL. Variables can also be re-ordered in a
   * rewrite, so that /{country}/{format}/{suffix=**} can be rewritten as
   * /content/{format}/{country}/{suffix}.
   *
   * At least one non-empty routeRules[].matchRules[].path_template_match is required.
   *
   * Only one of path_prefix_rewrite orpath_template_rewrite may be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pathTemplateRewrite;

  /**
   * Before forwarding the request to the selected service, the request's host header is replaced
   * with contents of hostRewrite.
   *
   * The value must be from 1 to 255 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getHostRewrite() {
    return hostRewrite;
  }

  /**
   * Before forwarding the request to the selected service, the request's host header is replaced
   * with contents of hostRewrite.
   *
   * The value must be from 1 to 255 characters.
   * @param hostRewrite hostRewrite or {@code null} for none
   */
  public UrlRewrite setHostRewrite(java.lang.String hostRewrite) {
    this.hostRewrite = hostRewrite;
    return this;
  }

  /**
   * Before forwarding the request to the selected backend service, the matching portion of the
   * request's path is replaced bypathPrefixRewrite.
   *
   * The value must be from 1 to 1024 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getPathPrefixRewrite() {
    return pathPrefixRewrite;
  }

  /**
   * Before forwarding the request to the selected backend service, the matching portion of the
   * request's path is replaced bypathPrefixRewrite.
   *
   * The value must be from 1 to 1024 characters.
   * @param pathPrefixRewrite pathPrefixRewrite or {@code null} for none
   */
  public UrlRewrite setPathPrefixRewrite(java.lang.String pathPrefixRewrite) {
    this.pathPrefixRewrite = pathPrefixRewrite;
    return this;
  }

  /**
   * If specified, the pattern rewrites the URL path (based on the :path header) using the HTTP
   * template syntax.
   *
   * A corresponding path_template_match must be specified. Any template variables must exist in the
   * path_template_match field.                - -At least one variable must be specified in the
   * path_template_match       field     - You can omit variables from the rewritten URL       - The
   * * and ** operators cannot be matched       unless they have a corresponding variable name -
   * e.g.       {format=*} or {var=**}.
   *
   * For example, a path_template_match of /static/{format=**} could be rewritten as
   * /static/content/{format} to prefix/content to the URL. Variables can also be re-ordered in a
   * rewrite, so that /{country}/{format}/{suffix=**} can be rewritten as
   * /content/{format}/{country}/{suffix}.
   *
   * At least one non-empty routeRules[].matchRules[].path_template_match is required.
   *
   * Only one of path_prefix_rewrite orpath_template_rewrite may be specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getPathTemplateRewrite() {
    return pathTemplateRewrite;
  }

  /**
   * If specified, the pattern rewrites the URL path (based on the :path header) using the HTTP
   * template syntax.
   *
   * A corresponding path_template_match must be specified. Any template variables must exist in the
   * path_template_match field.                - -At least one variable must be specified in the
   * path_template_match       field     - You can omit variables from the rewritten URL       - The
   * * and ** operators cannot be matched       unless they have a corresponding variable name -
   * e.g.       {format=*} or {var=**}.
   *
   * For example, a path_template_match of /static/{format=**} could be rewritten as
   * /static/content/{format} to prefix/content to the URL. Variables can also be re-ordered in a
   * rewrite, so that /{country}/{format}/{suffix=**} can be rewritten as
   * /content/{format}/{country}/{suffix}.
   *
   * At least one non-empty routeRules[].matchRules[].path_template_match is required.
   *
   * Only one of path_prefix_rewrite orpath_template_rewrite may be specified.
   * @param pathTemplateRewrite pathTemplateRewrite or {@code null} for none
   */
  public UrlRewrite setPathTemplateRewrite(java.lang.String pathTemplateRewrite) {
    this.pathTemplateRewrite = pathTemplateRewrite;
    return this;
  }

  @Override
  public UrlRewrite set(String fieldName, Object value) {
    return (UrlRewrite) super.set(fieldName, value);
  }

  @Override
  public UrlRewrite clone() {
    return (UrlRewrite) super.clone();
  }

}
