/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The current IP utilization of all subnetwork ranges. Contains the total number of allocated and
 * free IPs in each range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SubnetworkUtilizationDetails extends com.google.api.client.json.GenericJson {

  /**
   * Utilizations of external IPV6 IP range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubnetworkUtilizationDetailsIPV6Utilization externalIpv6InstanceUtilization;

  /**
   * Utilizations of external IPV6 IP range for NetLB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubnetworkUtilizationDetailsIPV6Utilization externalIpv6LbUtilization;

  /**
   * Utilizations of internal IPV6 IP range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubnetworkUtilizationDetailsIPV6Utilization internalIpv6Utilization;

  /**
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SubnetworkUtilizationDetailsIPV4Utilization> ipv4Utilizations;

  /**
   * Utilizations of external IPV6 IP range.
   * @return value or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV6Utilization getExternalIpv6InstanceUtilization() {
    return externalIpv6InstanceUtilization;
  }

  /**
   * Utilizations of external IPV6 IP range.
   * @param externalIpv6InstanceUtilization externalIpv6InstanceUtilization or {@code null} for none
   */
  public SubnetworkUtilizationDetails setExternalIpv6InstanceUtilization(SubnetworkUtilizationDetailsIPV6Utilization externalIpv6InstanceUtilization) {
    this.externalIpv6InstanceUtilization = externalIpv6InstanceUtilization;
    return this;
  }

  /**
   * Utilizations of external IPV6 IP range for NetLB.
   * @return value or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV6Utilization getExternalIpv6LbUtilization() {
    return externalIpv6LbUtilization;
  }

  /**
   * Utilizations of external IPV6 IP range for NetLB.
   * @param externalIpv6LbUtilization externalIpv6LbUtilization or {@code null} for none
   */
  public SubnetworkUtilizationDetails setExternalIpv6LbUtilization(SubnetworkUtilizationDetailsIPV6Utilization externalIpv6LbUtilization) {
    this.externalIpv6LbUtilization = externalIpv6LbUtilization;
    return this;
  }

  /**
   * Utilizations of internal IPV6 IP range.
   * @return value or {@code null} for none
   */
  public SubnetworkUtilizationDetailsIPV6Utilization getInternalIpv6Utilization() {
    return internalIpv6Utilization;
  }

  /**
   * Utilizations of internal IPV6 IP range.
   * @param internalIpv6Utilization internalIpv6Utilization or {@code null} for none
   */
  public SubnetworkUtilizationDetails setInternalIpv6Utilization(SubnetworkUtilizationDetailsIPV6Utilization internalIpv6Utilization) {
    this.internalIpv6Utilization = internalIpv6Utilization;
    return this;
  }

  /**
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<SubnetworkUtilizationDetailsIPV4Utilization> getIpv4Utilizations() {
    return ipv4Utilizations;
  }

  /**
   * Utilizations of all IPV4 IP ranges. For primary ranges, the range name will be empty.
   * @param ipv4Utilizations ipv4Utilizations or {@code null} for none
   */
  public SubnetworkUtilizationDetails setIpv4Utilizations(java.util.List<SubnetworkUtilizationDetailsIPV4Utilization> ipv4Utilizations) {
    this.ipv4Utilizations = ipv4Utilizations;
    return this;
  }

  @Override
  public SubnetworkUtilizationDetails set(String fieldName, Object value) {
    return (SubnetworkUtilizationDetails) super.set(fieldName, value);
  }

  @Override
  public SubnetworkUtilizationDetails clone() {
    return (SubnetworkUtilizationDetails) super.clone();
  }

}
